/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.init;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.init.GaugeCollector;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.primitives.Doubles;
import org.glowroot.agent.shaded.com.google.common.primitives.Longs;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="GaugeCollector.RawCounterValue", generator="Immutables")
@Immutable
final class ImmutableRawCounterValue
implements GaugeCollector.RawCounterValue {
    private final double value;
    private final long captureTick;

    private ImmutableRawCounterValue(double value, long captureTick) {
        this.value = value;
        this.captureTick = captureTick;
    }

    @Override
    @JsonProperty(value="value")
    public double value() {
        return this.value;
    }

    @Override
    @JsonProperty(value="captureTick")
    public long captureTick() {
        return this.captureTick;
    }

    public final ImmutableRawCounterValue withValue(double value) {
        if (Double.doubleToLongBits(this.value) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableRawCounterValue(value, this.captureTick);
    }

    public final ImmutableRawCounterValue withCaptureTick(long value) {
        if (this.captureTick == value) {
            return this;
        }
        return new ImmutableRawCounterValue(this.value, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRawCounterValue && this.equalTo((ImmutableRawCounterValue)another);
    }

    private boolean equalTo(ImmutableRawCounterValue another) {
        return Double.doubleToLongBits(this.value) == Double.doubleToLongBits(another.value) && this.captureTick == another.captureTick;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Doubles.hashCode(this.value);
        h += (h << 5) + Longs.hashCode(this.captureTick);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("RawCounterValue").omitNullValues().add("value", this.value).add("captureTick", this.captureTick).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableRawCounterValue fromJson(Json json) {
        Builder builder = ImmutableRawCounterValue.builder();
        if (json.valueIsSet) {
            builder.value(json.value);
        }
        if (json.captureTickIsSet) {
            builder.captureTick(json.captureTick);
        }
        return builder.build();
    }

    public static ImmutableRawCounterValue of(double value, long captureTick) {
        return new ImmutableRawCounterValue(value, captureTick);
    }

    public static ImmutableRawCounterValue copyOf(GaugeCollector.RawCounterValue instance) {
        if (instance instanceof ImmutableRawCounterValue) {
            return (ImmutableRawCounterValue)instance;
        }
        return ImmutableRawCounterValue.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="GaugeCollector.RawCounterValue", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_VALUE = 1L;
        private static final long INIT_BIT_CAPTURE_TICK = 2L;
        private long initBits = 3L;
        private double value;
        private long captureTick;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(GaugeCollector.RawCounterValue instance) {
            Objects.requireNonNull(instance, "instance");
            this.value(instance.value());
            this.captureTick(instance.captureTick());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder value(double value) {
            this.value = value;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder captureTick(long captureTick) {
            this.captureTick = captureTick;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableRawCounterValue build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRawCounterValue(this.value, this.captureTick);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("value");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("captureTick");
            }
            return "Cannot build RawCounterValue, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="GaugeCollector.RawCounterValue", generator="Immutables")
    static final class Json
    implements GaugeCollector.RawCounterValue {
        double value;
        boolean valueIsSet;
        long captureTick;
        boolean captureTickIsSet;

        Json() {
        }

        @JsonProperty(value="value")
        public void setValue(double value) {
            this.value = value;
            this.valueIsSet = true;
        }

        @JsonProperty(value="captureTick")
        public void setCaptureTick(long captureTick) {
            this.captureTick = captureTick;
            this.captureTickIsSet = true;
        }

        @Override
        public double value() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long captureTick() {
            throw new UnsupportedOperationException();
        }
    }
}

