/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.model;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.model.TransactionTimer;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.primitives.Booleans;
import org.glowroot.agent.shaded.com.google.common.primitives.Longs;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TransactionTimer.TransactionTimerSnapshot", generator="Immutables")
@Immutable
public final class ImmutableTransactionTimerSnapshot
implements TransactionTimer.TransactionTimerSnapshot {
    private final long totalNanos;
    private final long count;
    private final boolean active;

    private ImmutableTransactionTimerSnapshot(long totalNanos, long count, boolean active) {
        this.totalNanos = totalNanos;
        this.count = count;
        this.active = active;
    }

    @Override
    @JsonProperty(value="totalNanos")
    public long totalNanos() {
        return this.totalNanos;
    }

    @Override
    @JsonProperty(value="count")
    public long count() {
        return this.count;
    }

    @Override
    @JsonProperty(value="active")
    public boolean active() {
        return this.active;
    }

    public final ImmutableTransactionTimerSnapshot withTotalNanos(long value) {
        if (this.totalNanos == value) {
            return this;
        }
        return new ImmutableTransactionTimerSnapshot(value, this.count, this.active);
    }

    public final ImmutableTransactionTimerSnapshot withCount(long value) {
        if (this.count == value) {
            return this;
        }
        return new ImmutableTransactionTimerSnapshot(this.totalNanos, value, this.active);
    }

    public final ImmutableTransactionTimerSnapshot withActive(boolean value) {
        if (this.active == value) {
            return this;
        }
        return new ImmutableTransactionTimerSnapshot(this.totalNanos, this.count, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTransactionTimerSnapshot && this.equalTo((ImmutableTransactionTimerSnapshot)another);
    }

    private boolean equalTo(ImmutableTransactionTimerSnapshot another) {
        return this.totalNanos == another.totalNanos && this.count == another.count && this.active == another.active;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Longs.hashCode(this.totalNanos);
        h += (h << 5) + Longs.hashCode(this.count);
        h += (h << 5) + Booleans.hashCode(this.active);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("TransactionTimerSnapshot").omitNullValues().add("totalNanos", this.totalNanos).add("count", this.count).add("active", this.active).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableTransactionTimerSnapshot fromJson(Json json) {
        Builder builder = ImmutableTransactionTimerSnapshot.builder();
        if (json.totalNanosIsSet) {
            builder.totalNanos(json.totalNanos);
        }
        if (json.countIsSet) {
            builder.count(json.count);
        }
        if (json.activeIsSet) {
            builder.active(json.active);
        }
        return builder.build();
    }

    public static ImmutableTransactionTimerSnapshot of(long totalNanos, long count, boolean active) {
        return new ImmutableTransactionTimerSnapshot(totalNanos, count, active);
    }

    public static ImmutableTransactionTimerSnapshot copyOf(TransactionTimer.TransactionTimerSnapshot instance) {
        if (instance instanceof ImmutableTransactionTimerSnapshot) {
            return (ImmutableTransactionTimerSnapshot)instance;
        }
        return ImmutableTransactionTimerSnapshot.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TransactionTimer.TransactionTimerSnapshot", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TOTAL_NANOS = 1L;
        private static final long INIT_BIT_COUNT = 2L;
        private static final long INIT_BIT_ACTIVE = 4L;
        private long initBits = 7L;
        private long totalNanos;
        private long count;
        private boolean active;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(TransactionTimer.TransactionTimerSnapshot instance) {
            Objects.requireNonNull(instance, "instance");
            this.totalNanos(instance.totalNanos());
            this.count(instance.count());
            this.active(instance.active());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder totalNanos(long totalNanos) {
            this.totalNanos = totalNanos;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder count(long count) {
            this.count = count;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder active(boolean active) {
            this.active = active;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableTransactionTimerSnapshot build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTransactionTimerSnapshot(this.totalNanos, this.count, this.active);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("totalNanos");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("count");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("active");
            }
            return "Cannot build TransactionTimerSnapshot, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="TransactionTimer.TransactionTimerSnapshot", generator="Immutables")
    static final class Json
    implements TransactionTimer.TransactionTimerSnapshot {
        long totalNanos;
        boolean totalNanosIsSet;
        long count;
        boolean countIsSet;
        boolean active;
        boolean activeIsSet;

        Json() {
        }

        @JsonProperty(value="totalNanos")
        public void setTotalNanos(long totalNanos) {
            this.totalNanos = totalNanos;
            this.totalNanosIsSet = true;
        }

        @JsonProperty(value="count")
        public void setCount(long count) {
            this.count = count;
            this.countIsSet = true;
        }

        @JsonProperty(value="active")
        public void setActive(boolean active) {
            this.active = active;
            this.activeIsSet = true;
        }

        @Override
        public long totalNanos() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long count() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean active() {
            throw new UnsupportedOperationException();
        }
    }
}

