/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.model;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import javax.annotation.concurrent.GuardedBy;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;
import org.glowroot.agent.model.ThreadStats;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.util.ThreadAllocatedBytes;

public class ThreadStatsComponent {
    private static final ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
    private static final boolean IS_THREAD_CPU_TIME_SUPPORTED = threadMXBean.isThreadCpuTimeSupported();
    private static final boolean IS_THREAD_CONTENTION_MONITORING_SUPPORTED = threadMXBean.isThreadContentionMonitoringSupported();
    private final long threadId;
    private final long startingCpuNanos;
    private final long startingBlockedMillis;
    private final long startingWaitedMillis;
    private final long startingAllocatedBytes;
    private final @Nullable ThreadAllocatedBytes threadAllocatedBytes;
    @GuardedBy(value="lock")
    private volatile @MonotonicNonNull ThreadStats completedThreadStats;
    private final Object lock = new Object();

    public ThreadStatsComponent(@Nullable ThreadAllocatedBytes threadAllocatedBytes) {
        this.threadId = Thread.currentThread().getId();
        ThreadInfo threadInfo = threadMXBean.getThreadInfo(this.threadId, 0);
        Preconditions.checkNotNull(threadInfo);
        this.startingCpuNanos = IS_THREAD_CPU_TIME_SUPPORTED ? threadMXBean.getCurrentThreadCpuTime() : -1L;
        if (IS_THREAD_CONTENTION_MONITORING_SUPPORTED) {
            this.startingBlockedMillis = threadInfo.getBlockedTime();
            this.startingWaitedMillis = threadInfo.getWaitedTime();
        } else {
            this.startingBlockedMillis = -1L;
            this.startingWaitedMillis = -1L;
        }
        this.startingAllocatedBytes = threadAllocatedBytes != null ? threadAllocatedBytes.getThreadAllocatedBytesSafely(this.threadId) : -1L;
        this.threadAllocatedBytes = threadAllocatedBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onComplete() {
        Object object = this.lock;
        synchronized (object) {
            this.completedThreadStats = this.getThreadStats();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadStats getThreadStats() {
        Object object = this.lock;
        synchronized (object) {
            if (this.completedThreadStats == null) {
                return this.getThreadStatsInternal();
            }
            return this.completedThreadStats;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCpuNanos() {
        Object object = this.lock;
        synchronized (object) {
            if (this.completedThreadStats == null) {
                if (IS_THREAD_CPU_TIME_SUPPORTED) {
                    return this.getCpuNanosInternal();
                }
                return -1L;
            }
            return this.completedThreadStats.getCpuNanos();
        }
    }

    private ThreadStats getThreadStatsInternal() {
        long blockedMillis;
        long waitedMillis;
        long cpuNanos = IS_THREAD_CPU_TIME_SUPPORTED ? this.getCpuNanosInternal() : -1L;
        ThreadInfo threadInfo = threadMXBean.getThreadInfo(this.threadId, 0);
        if (threadInfo == null) {
            return new ThreadStats(0L, 0L, 0L, 0L);
        }
        if (IS_THREAD_CONTENTION_MONITORING_SUPPORTED) {
            waitedMillis = this.getWaitedMillisInternal(threadInfo);
            blockedMillis = this.getBlockedMillisInternal(threadInfo);
        } else {
            blockedMillis = -1L;
            waitedMillis = -1L;
        }
        long allocatedBytes = this.threadAllocatedBytes != null ? this.getAllocatedBytesInternal() : -1L;
        return new ThreadStats(cpuNanos, blockedMillis, waitedMillis, allocatedBytes);
    }

    private long getCpuNanosInternal() {
        long threadCpuNanos = threadMXBean.getThreadCpuTime(this.threadId);
        if (this.startingCpuNanos != -1L && threadCpuNanos != -1L) {
            return threadCpuNanos - this.startingCpuNanos;
        }
        return -1L;
    }

    private long getBlockedMillisInternal(ThreadInfo threadInfo) {
        long threadBlockedTimeMillis = threadInfo.getBlockedTime();
        if (this.startingBlockedMillis != -1L && threadBlockedTimeMillis != -1L) {
            return threadBlockedTimeMillis - this.startingBlockedMillis;
        }
        return -1L;
    }

    private long getWaitedMillisInternal(ThreadInfo threadInfo) {
        long threadWaitedTimeMillis = threadInfo.getWaitedTime();
        if (this.startingWaitedMillis != -1L && threadWaitedTimeMillis != -1L) {
            return threadWaitedTimeMillis - this.startingWaitedMillis;
        }
        return -1L;
    }

    @RequiresNonNull(value={"threadAllocatedBytes"})
    private long getAllocatedBytesInternal() {
        long allocatedBytes = this.threadAllocatedBytes.getThreadAllocatedBytesSafely(this.threadId);
        if (this.startingAllocatedBytes != -1L && allocatedBytes != -1L) {
            return allocatedBytes - this.startingAllocatedBytes;
        }
        return -1L;
    }
}

