/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.plugin.grails;

import org.glowroot.agent.plugin.api.Agent;
import org.glowroot.agent.plugin.api.MessageSupplier;
import org.glowroot.agent.plugin.api.ThreadContext;
import org.glowroot.agent.plugin.api.TimerName;
import org.glowroot.agent.plugin.api.TraceEntry;
import org.glowroot.agent.plugin.api.weaving.BindParameter;
import org.glowroot.agent.plugin.api.weaving.BindReceiver;
import org.glowroot.agent.plugin.api.weaving.BindThrowable;
import org.glowroot.agent.plugin.api.weaving.BindTraveler;
import org.glowroot.agent.plugin.api.weaving.OnBefore;
import org.glowroot.agent.plugin.api.weaving.OnReturn;
import org.glowroot.agent.plugin.api.weaving.OnThrow;
import org.glowroot.agent.plugin.api.weaving.Pointcut;
import org.glowroot.agent.plugin.api.weaving.Shim;

public class GrailsControllerClassAspect {

    @Pointcut(className="grails.core.GrailsControllerClass", methodName="invoke", methodParameterTypes={"java.lang.Object", "java.lang.String"}, timerName="grails controller")
    public static class ControllerAdvice {
        private static final TimerName timerName = Agent.getTimerName(ControllerAdvice.class);

        @OnBefore
        public static TraceEntry onBefore(ThreadContext context, @BindReceiver GrailsControllerClass grailsController, @BindParameter Object controller, @BindParameter String action) {
            String actionName = action == null ? grailsController.getDefaultAction() : action;
            context.setTransactionName(grailsController.getName() + "#" + actionName, -100);
            return context.startTraceEntry(MessageSupplier.create("grails controller: {}.{}()", grailsController.getFullName(), actionName), timerName);
        }

        @OnReturn
        public static void onReturn(@BindTraveler TraceEntry traceEntry) {
            traceEntry.end();
        }

        @OnThrow
        public static void onThrow(@BindThrowable Throwable t, @BindTraveler TraceEntry traceEntry) {
            traceEntry.endWithError(t);
        }
    }

    @Shim(value={"grails.core.GrailsControllerClass"})
    public static interface GrailsControllerClass {
        public String getDefaultAction();

        public String getName();

        public String getFullName();
    }
}

