/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.plugin.httpclient._;

import java.lang.reflect.Method;
import java.net.URI;
import org.glowroot.agent.plugin.api.ClassInfo;
import org.glowroot.agent.plugin.api.Logger;
import org.glowroot.agent.plugin.api.checker.Nullable;
import org.glowroot.agent.plugin.api.util.Reflection;

public class AsyncHttpClientRequestInvoker {
    private static final Logger logger = Logger.getLogger(AsyncHttpClientRequestInvoker.class);
    @Nullable
    private final Method getUrlMethod;
    @Nullable
    private final Method getURIMethod;

    public AsyncHttpClientRequestInvoker(ClassInfo classInfo) {
        Class<?> requestClass = Reflection.getClassWithWarnIfNotFound("com.ning.http.client.Request", classInfo.getLoader());
        this.getUrlMethod = Reflection.getMethod(requestClass, "getUrl", new Class[0]);
        Method getURIMethod = null;
        if (requestClass != null) {
            try {
                getURIMethod = requestClass.getMethod("getURI", new Class[0]);
            }
            catch (Exception e) {
                logger.debug(e.getMessage(), e);
            }
        }
        this.getURIMethod = getURIMethod;
    }

    public String getUrl(Object request) {
        if (this.getURIMethod == null) {
            return Reflection.invokeWithDefault(this.getUrlMethod, request, "", new Object[0]);
        }
        URI uri = (URI)Reflection.invoke(this.getURIMethod, request, new Object[0]);
        return uri == null ? "" : uri.toString();
    }
}

