/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.plugin.jdbc;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.glowroot.agent.plugin.api.checker.Nullable;
import org.glowroot.agent.plugin.jdbc.StatementMirror;
import org.glowroot.agent.plugin.jdbc.message.BindParameterList;

class PreparedStatementMirror
extends StatementMirror {
    private static final int CAPTURED_BATCH_SIZE_LIMIT = 1000;
    private static final int PARAMETERS_INITIAL_CAPACITY = 4;
    private final String sql;
    private BindParameterList parameters;
    private boolean parametersShared;
    @Nullable
    private Collection<BindParameterList> batchedParameters;
    private int batchSize;

    PreparedStatementMirror(String sql) {
        this.sql = sql;
        this.parameters = new BindParameterList(4);
    }

    void addBatch() {
        if (this.batchedParameters == null) {
            this.batchedParameters = new ConcurrentLinkedQueue<BindParameterList>();
        }
        if (this.batchSize++ < 1000) {
            this.batchedParameters.add(this.parameters);
            this.parametersShared = true;
        }
    }

    Collection<BindParameterList> getBatchedParameters() {
        if (this.batchedParameters == null) {
            return Collections.emptyList();
        }
        return this.batchedParameters;
    }

    @Nullable
    BindParameterList getParameters() {
        this.parametersShared = true;
        return this.parameters;
    }

    String getSql() {
        return this.sql;
    }

    int getBatchSize() {
        return this.batchSize;
    }

    void setParameterValue(int parameterIndex, @Nullable Object object) {
        if (this.parametersShared) {
            this.copyParameters();
        }
        this.parameters.set(parameterIndex - 1, object);
    }

    private void copyParameters() {
        this.parameters = BindParameterList.copyOf(this.parameters);
        this.parametersShared = false;
    }

    void clearParameters() {
        if (this.parametersShared) {
            this.parameters = new BindParameterList(this.parameters.size());
            this.parametersShared = false;
        } else {
            this.parameters.clear();
        }
    }

    @Override
    public void clearBatch() {
        if (this.parametersShared) {
            this.parameters = new BindParameterList(this.parameters.size());
            this.parametersShared = false;
        } else {
            this.parameters.clear();
        }
        this.batchedParameters = null;
        this.batchSize = 0;
    }

    static class StreamingParameterValue {
        private final Class<?> clazz;

        StreamingParameterValue(Class<?> clazz) {
            this.clazz = clazz;
        }

        public String toString() {
            return "{stream:" + this.clazz.getSimpleName() + "}";
        }
    }

    static class ByteArrayParameterValue {
        private static final char[] hexDigits = "0123456789abcdef".toCharArray();
        private final int length;
        private final byte[] bytes;

        ByteArrayParameterValue(byte[] bytes, boolean displayAsHex) {
            this.length = bytes.length;
            this.bytes = (byte[])(displayAsHex ? bytes : null);
        }

        public String toString() {
            if (this.bytes != null) {
                StringBuilder sb = new StringBuilder(2 + 2 * this.bytes.length);
                sb.append("0x");
                for (byte b : this.bytes) {
                    sb.append(hexDigits[b >> 4 & 0xF]).append(hexDigits[b & 0xF]);
                }
                return sb.toString();
            }
            return "{" + this.length + " bytes}";
        }
    }
}

