/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.plugin.jdbc.message;

import java.util.Collection;
import org.glowroot.agent.plugin.api.QueryMessage;
import org.glowroot.agent.plugin.api.QueryMessageSupplier;
import org.glowroot.agent.plugin.jdbc.message.BindParameterList;
import org.glowroot.agent.plugin.jdbc.message.PreparedStatementMessageSupplier;

public class BatchPreparedStatementMessageSupplier
extends QueryMessageSupplier {
    private static final int MESSAGE_CHAR_LIMIT = Integer.getInteger("glowroot.message.char.limit", 524288);
    private final Collection<BindParameterList> batchedParameters;
    private final int batchSize;

    public BatchPreparedStatementMessageSupplier(Collection<BindParameterList> batchedParameters, int batchSize) {
        this.batchedParameters = batchedParameters;
        this.batchSize = batchSize;
    }

    @Override
    public QueryMessage get() {
        String suffix;
        int capturedBatchSize = 0;
        if (this.batchedParameters.isEmpty()) {
            suffix = "";
        } else {
            StringBuilder sb = new StringBuilder();
            boolean exceededMessageCharLimit = false;
            for (BindParameterList oneParameters : this.batchedParameters) {
                PreparedStatementMessageSupplier.appendParameters(sb, oneParameters);
                ++capturedBatchSize;
                if (sb.length() <= MESSAGE_CHAR_LIMIT) continue;
                sb.setLength(MESSAGE_CHAR_LIMIT);
                sb.append(" [truncated to ");
                sb.append(MESSAGE_CHAR_LIMIT);
                sb.append(" characters]");
                exceededMessageCharLimit = true;
                break;
            }
            if (!exceededMessageCharLimit && this.batchSize > capturedBatchSize) {
                sb.append(" ...");
            }
            suffix = sb.toString();
        }
        String prefix = this.batchSize > 1 ? "jdbc query: " + this.batchSize + " x " : "jdbc query: ";
        return QueryMessage.create(prefix, suffix);
    }
}

