/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.plugin.jdbc.message;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.glowroot.agent.plugin.api.Agent;
import org.glowroot.agent.plugin.api.Logger;
import org.glowroot.agent.plugin.api.QueryMessage;
import org.glowroot.agent.plugin.api.QueryMessageSupplier;
import org.glowroot.agent.plugin.api.checker.Nullable;
import org.glowroot.agent.plugin.api.config.ConfigListener;
import org.glowroot.agent.plugin.api.config.ConfigService;
import org.glowroot.agent.plugin.api.util.ImmutableList;
import org.glowroot.agent.plugin.jdbc.message.BindParameterList;

public class PreparedStatementMessageSupplier
extends QueryMessageSupplier {
    private static final Logger logger = Logger.getLogger(PreparedStatementMessageSupplier.class);
    private static final ConfigService configService = Agent.getConfigService("jdbc");
    private static List<Pattern> captureBindParametersIncludePatterns = Collections.emptyList();
    private static List<Pattern> captureBindParametersExcludePatterns = Collections.emptyList();
    @Nullable
    private final BindParameterList parameters;
    private final String queryText;

    public PreparedStatementMessageSupplier(@Nullable BindParameterList parameters, String queryText) {
        this.parameters = parameters;
        this.queryText = queryText;
    }

    @Override
    public QueryMessage get() {
        String suffix = "";
        if (this.parameters != null && !this.parameters.isEmpty() && this.capture()) {
            StringBuilder sb = new StringBuilder();
            PreparedStatementMessageSupplier.appendParameters(sb, this.parameters);
            suffix = sb.toString();
        }
        return QueryMessage.create("jdbc query: ", suffix);
    }

    private boolean capture() {
        String queryTextTrimmed = this.queryText.trim();
        boolean include = false;
        for (Pattern includePattern : captureBindParametersIncludePatterns) {
            if (!includePattern.matcher(queryTextTrimmed).matches()) continue;
            include = true;
            break;
        }
        if (!include) {
            return false;
        }
        for (Pattern excludePattern : captureBindParametersExcludePatterns) {
            if (!excludePattern.matcher(queryTextTrimmed).matches()) continue;
            return false;
        }
        return true;
    }

    static void appendParameters(StringBuilder sb, BindParameterList parameters) {
        sb.append(" [");
        boolean first = true;
        for (Object parameter : parameters) {
            if (!first) {
                sb.append(", ");
            }
            if (parameter instanceof String) {
                sb.append("'");
                sb.append((String)parameter);
                sb.append("'");
            } else if (parameter == null) {
                sb.append("NULL");
            } else {
                sb.append(String.valueOf(parameter));
            }
            first = false;
        }
        sb.append("]");
    }

    static {
        configService.registerConfigListener(new ConfigListener(){

            @Override
            public void onChange() {
                captureBindParametersIncludePatterns = this.buildPatternList("captureBindParametersIncludes");
                captureBindParametersExcludePatterns = this.buildPatternList("captureBindParametersExcludes");
            }

            private List<Pattern> buildPatternList(String propertyName) {
                List<String> values = configService.getListProperty(propertyName).value();
                ArrayList<Pattern> patterns = new ArrayList<Pattern>();
                for (String value : values) {
                    try {
                        patterns.add(Pattern.compile(value.trim(), 32));
                    }
                    catch (PatternSyntaxException e) {
                        logger.warn("the jdbc plugin configuration property {} contains an invalid regular expression: {}\n{}", propertyName, value.trim(), e.getMessage());
                    }
                }
                return ImmutableList.copyOf(patterns);
            }
        });
    }
}

