/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.plugin.logger;

import org.glowroot.agent.plugin.api.Agent;
import org.glowroot.agent.plugin.api.Message;
import org.glowroot.agent.plugin.api.MessageSupplier;
import org.glowroot.agent.plugin.api.ThreadContext;
import org.glowroot.agent.plugin.api.TimerName;
import org.glowroot.agent.plugin.api.TraceEntry;
import org.glowroot.agent.plugin.api.checker.Nullable;
import org.glowroot.agent.plugin.api.weaving.BindClassMeta;
import org.glowroot.agent.plugin.api.weaving.BindParameter;
import org.glowroot.agent.plugin.api.weaving.BindReceiver;
import org.glowroot.agent.plugin.api.weaving.BindTraveler;
import org.glowroot.agent.plugin.api.weaving.OnAfter;
import org.glowroot.agent.plugin.api.weaving.OnBefore;
import org.glowroot.agent.plugin.api.weaving.Pointcut;
import org.glowroot.agent.plugin.api.weaving.Shim;
import org.glowroot.agent.plugin.logger.LoggerPlugin;
import org.glowroot.agent.plugin.logger.LoggingEventInvoker;

public class LogbackAspect {
    private static final String TIMER_NAME = "logging";
    private static final int OFF_INT = Integer.MAX_VALUE;
    private static final int ERROR_INT = 40000;
    private static final int WARN_INT = 30000;
    private static final int INFO_INT = 20000;
    private static final int DEBUG_INT = 10000;
    private static final int TRACE_INT = 5000;
    private static final int ALL_INT = Integer.MIN_VALUE;

    private static class LogMessageSupplier
    extends MessageSupplier {
        private final int level;
        @Nullable
        private final String loggerName;
        private final String messageText;

        private LogMessageSupplier(int level, @Nullable String loggerName, String messageText) {
            this.level = level;
            this.loggerName = loggerName;
            this.messageText = messageText;
        }

        @Override
        public Message get() {
            return Message.create("log {}: {} - {}", LogMessageSupplier.getLevelStr(this.level), LoggerPlugin.getAbbreviatedLoggerName(this.loggerName), this.messageText);
        }

        private static String getLevelStr(int lvl) {
            switch (lvl) {
                case -2147483648: {
                    return "all";
                }
                case 5000: {
                    return "trace";
                }
                case 10000: {
                    return "debug";
                }
                case 20000: {
                    return "info";
                }
                case 30000: {
                    return "warn";
                }
                case 40000: {
                    return "error";
                }
                case 0x7FFFFFFF: {
                    return "off";
                }
            }
            return "unknown (" + lvl + ")";
        }
    }

    private static class LogAdviceTraveler {
        private final TraceEntry traceEntry;
        private final int level;
        private final String formattedMessage;
        @Nullable
        private final Throwable throwable;

        private LogAdviceTraveler(TraceEntry traceEntry, int level, String formattedMessage, @Nullable Throwable throwable) {
            this.traceEntry = traceEntry;
            this.level = level;
            this.formattedMessage = formattedMessage;
            this.throwable = throwable;
        }
    }

    @Pointcut(className="ch.qos.logback.classic.Logger", methodName="callAppenders", methodParameterTypes={"ch.qos.logback.classic.spi.LoggingEvent"}, nestingGroup="logging", timerName="logging")
    public static class CallAppenders0xAdvice {
        private static final TimerName timerName = Agent.getTimerName(CallAppenders0xAdvice.class);

        @OnBefore
        @Nullable
        public static LogAdviceTraveler onBefore(ThreadContext context, @BindReceiver Object logger, @BindParameter @Nullable Object loggingEvent, @BindClassMeta LoggingEventInvoker invoker) {
            Throwable t;
            if (loggingEvent == null) {
                return null;
            }
            String formattedMessage = invoker.getFormattedMessage(loggingEvent);
            int lvl = invoker.getLevel(loggingEvent);
            if (LoggerPlugin.markTraceAsError(lvl >= 40000, lvl >= 30000, (t = invoker.getThrowable(loggingEvent)) != null)) {
                context.setTransactionError(formattedMessage, t);
            }
            TraceEntry traceEntry = context.startTraceEntry(new LogMessageSupplier(lvl, invoker.getLoggerName(logger), formattedMessage), timerName);
            return new LogAdviceTraveler(traceEntry, lvl, formattedMessage, t);
        }

        @OnAfter
        public static void onAfter(@BindTraveler @Nullable LogAdviceTraveler traveler) {
            if (traveler == null) {
                return;
            }
            Throwable t = traveler.throwable;
            if (t != null) {
                if (traveler.level >= 30000) {
                    traveler.traceEntry.endWithError(t);
                } else {
                    traveler.traceEntry.endWithInfo(t);
                }
            } else if (traveler.level >= 30000) {
                traveler.traceEntry.endWithError(traveler.formattedMessage);
            } else {
                traveler.traceEntry.end();
            }
        }
    }

    @Pointcut(className="ch.qos.logback.classic.Logger", methodName="callAppenders", methodParameterTypes={"ch.qos.logback.classic.spi.ILoggingEvent"}, nestingGroup="logging", timerName="logging")
    public static class CallAppendersAdvice {
        private static final TimerName timerName = Agent.getTimerName(CallAppendersAdvice.class);

        @OnBefore
        @Nullable
        public static LogAdviceTraveler onBefore(ThreadContext context, @BindParameter @Nullable ILoggingEvent loggingEvent) {
            if (loggingEvent == null) {
                return null;
            }
            String formattedMessage = CallAppendersAdvice.nullToEmpty(loggingEvent.getFormattedMessage());
            Level level = loggingEvent.glowroot$getLevel();
            int lvl = level == null ? 0 : level.toInt();
            Object throwableProxy = loggingEvent.glowroot$getThrowableProxy();
            Throwable t = null;
            if (throwableProxy instanceof ThrowableProxy) {
                t = ((ThrowableProxy)throwableProxy).getThrowable();
            }
            if (LoggerPlugin.markTraceAsError(lvl >= 40000, lvl >= 30000, t != null)) {
                context.setTransactionError(formattedMessage, t);
            }
            TraceEntry traceEntry = context.startTraceEntry(new LogMessageSupplier(lvl, loggingEvent.getLoggerName(), formattedMessage), timerName);
            return new LogAdviceTraveler(traceEntry, lvl, formattedMessage, t);
        }

        @OnAfter
        public static void onAfter(@BindTraveler @Nullable LogAdviceTraveler traveler) {
            if (traveler == null) {
                return;
            }
            Throwable t = traveler.throwable;
            if (t != null) {
                if (traveler.level >= 30000) {
                    traveler.traceEntry.endWithError(t);
                } else {
                    traveler.traceEntry.endWithInfo(t);
                }
            } else if (traveler.level >= 30000) {
                traveler.traceEntry.endWithError(traveler.formattedMessage);
            } else {
                traveler.traceEntry.end();
            }
        }

        private static String nullToEmpty(@Nullable String s) {
            return s == null ? "" : s;
        }
    }

    @Shim(value={"ch.qos.logback.classic.spi.ThrowableProxy"})
    public static interface ThrowableProxy {
        @Nullable
        public Throwable getThrowable();
    }

    @Shim(value={"ch.qos.logback.classic.Level"})
    public static interface Level {
        public int toInt();
    }

    @Shim(value={"ch.qos.logback.classic.spi.ILoggingEvent"})
    public static interface ILoggingEvent {
        @Shim(value={"ch.qos.logback.classic.Level getLevel()"})
        @Nullable
        public Level glowroot$getLevel();

        @Nullable
        public String getFormattedMessage();

        @Nullable
        public String getLoggerName();

        @Shim(value={"ch.qos.logback.classic.spi.IThrowableProxy getThrowableProxy()"})
        @Nullable
        public Object glowroot$getThrowableProxy();
    }
}

