/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.ch.qos.logback.classic.spi;

import java.util.List;
import org.glowroot.agent.shaded.ch.qos.logback.core.CoreConstants;

public class CallerData {
    public static final String CALLER_DATA_NA = "?#?:?" + CoreConstants.LINE_SEPARATOR;
    public static final StackTraceElement[] EMPTY_CALLER_DATA_ARRAY = new StackTraceElement[0];

    public static StackTraceElement[] extract(Throwable t, String fqnOfInvokingClass, int maxDepth, List<String> frameworkPackageList) {
        if (t == null) {
            return null;
        }
        StackTraceElement[] steArray = t.getStackTrace();
        int found = -1;
        for (int i = 0; i < steArray.length; ++i) {
            if (CallerData.isInFrameworkSpace(steArray[i].getClassName(), fqnOfInvokingClass, frameworkPackageList)) {
                found = i + 1;
                continue;
            }
            if (found != -1) break;
        }
        if (found == -1) {
            return EMPTY_CALLER_DATA_ARRAY;
        }
        int availableDepth = steArray.length - found;
        int desiredDepth = maxDepth < availableDepth ? maxDepth : availableDepth;
        StackTraceElement[] callerDataArray = new StackTraceElement[desiredDepth];
        for (int i = 0; i < desiredDepth; ++i) {
            callerDataArray[i] = steArray[found + i];
        }
        return callerDataArray;
    }

    static boolean isInFrameworkSpace(String currentClass, String fqnOfInvokingClass, List<String> frameworkPackageList) {
        return currentClass.equals(fqnOfInvokingClass) || currentClass.equals("org.apache.log4j.Category") || currentClass.startsWith("org.glowroot.agent.shaded.org.slf4j.Logger") || CallerData.isInFrameworkSpaceList(currentClass, frameworkPackageList);
    }

    private static boolean isInFrameworkSpaceList(String currentClass, List<String> frameworkPackageList) {
        if (frameworkPackageList == null) {
            return false;
        }
        for (String s : frameworkPackageList) {
            if (!currentClass.startsWith(s)) continue;
            return true;
        }
        return false;
    }
}

