/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.com.fasterxml.jackson.core.util;

import java.lang.ref.SoftReference;
import org.glowroot.agent.shaded.com.fasterxml.jackson.core.util.BufferRecycler;
import org.glowroot.agent.shaded.com.fasterxml.jackson.core.util.ThreadLocalBufferManager;

public class BufferRecyclers {
    private static final ThreadLocalBufferManager _bufferRecyclerTracker;
    protected static final ThreadLocal<SoftReference<BufferRecycler>> _recyclerRef;

    public static BufferRecycler getBufferRecycler() {
        BufferRecycler br;
        SoftReference<BufferRecycler> ref = _recyclerRef.get();
        BufferRecycler bufferRecycler = br = ref == null ? null : ref.get();
        if (br == null) {
            br = new BufferRecycler();
            ref = _bufferRecyclerTracker != null ? _bufferRecyclerTracker.wrapAndTrack(br) : new SoftReference<BufferRecycler>(br);
            _recyclerRef.set(ref);
        }
        return br;
    }

    static {
        boolean trackReusableBuffers = false;
        try {
            trackReusableBuffers = "true".equals(System.getProperty("org.glowroot.agent.shaded.com.fasterxml.jackson.core.util.BufferRecyclers.trackReusableBuffers"));
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        _bufferRecyclerTracker = trackReusableBuffers ? ThreadLocalBufferManager.instance() : null;
        _recyclerRef = new ThreadLocal();
    }
}

