/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.com.fasterxml.jackson.databind.deser.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.JavaType;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.deser.std.StdDelegatingDeserializer;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.type.TypeFactory;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.util.Converter;

public abstract class JavaUtilCollectionsDeserializers {
    public static JsonDeserializer<?> findForCollection(DeserializationContext ctxt, JavaType type) throws JsonMappingException {
        String clsName = type.getRawClass().getName();
        if (!clsName.startsWith("java.util.")) {
            return null;
        }
        String localName = JavaUtilCollectionsDeserializers._findUtilCollectionsTypeName(clsName);
        if (localName != null) {
            JavaUtilCollectionsConverter conv = null;
            String name = JavaUtilCollectionsDeserializers._findUnmodifiableTypeName(localName);
            if (name != null) {
                if (name.endsWith("Set")) {
                    conv = JavaUtilCollectionsDeserializers.converter(4, type, Set.class);
                } else if (name.endsWith("List")) {
                    conv = JavaUtilCollectionsDeserializers.converter(5, type, List.class);
                }
            } else {
                name = JavaUtilCollectionsDeserializers._findSingletonTypeName(localName);
                if (name != null) {
                    if (name.endsWith("Set")) {
                        conv = JavaUtilCollectionsDeserializers.converter(1, type, Set.class);
                    } else if (name.endsWith("List")) {
                        conv = JavaUtilCollectionsDeserializers.converter(2, type, List.class);
                    }
                } else {
                    name = JavaUtilCollectionsDeserializers._findSyncTypeName(localName);
                    if (name != null) {
                        if (name.endsWith("Set")) {
                            conv = JavaUtilCollectionsDeserializers.converter(7, type, Set.class);
                        } else if (name.endsWith("List")) {
                            conv = JavaUtilCollectionsDeserializers.converter(9, type, List.class);
                        } else if (name.endsWith("Collection")) {
                            conv = JavaUtilCollectionsDeserializers.converter(8, type, Collection.class);
                        }
                    }
                }
            }
            return conv == null ? null : new StdDelegatingDeserializer<Object>(conv);
        }
        localName = JavaUtilCollectionsDeserializers._findUtilArrayTypeName(clsName);
        if (localName != null) {
            if (localName.contains("List")) {
                return new StdDelegatingDeserializer<Object>(JavaUtilCollectionsDeserializers.converter(5, type, List.class));
            }
            return null;
        }
        localName = JavaUtilCollectionsDeserializers._findUtilCollectionsImmutableTypeName(clsName);
        if (localName != null) {
            if (localName.contains("List")) {
                return new StdDelegatingDeserializer<Object>(JavaUtilCollectionsDeserializers.converter(11, type, List.class));
            }
            return null;
        }
        return null;
    }

    public static JsonDeserializer<?> findForMap(DeserializationContext ctxt, JavaType type) throws JsonMappingException {
        String clsName = type.getRawClass().getName();
        JavaUtilCollectionsConverter conv = null;
        String localName = JavaUtilCollectionsDeserializers._findUtilCollectionsTypeName(clsName);
        if (localName != null) {
            String name = JavaUtilCollectionsDeserializers._findUnmodifiableTypeName(localName);
            if (name != null) {
                if (name.contains("Map")) {
                    conv = JavaUtilCollectionsDeserializers.converter(6, type, Map.class);
                }
            } else {
                name = JavaUtilCollectionsDeserializers._findSingletonTypeName(localName);
                if (name != null) {
                    if (name.contains("Map")) {
                        conv = JavaUtilCollectionsDeserializers.converter(3, type, Map.class);
                    }
                } else {
                    name = JavaUtilCollectionsDeserializers._findSyncTypeName(localName);
                    if (name != null && name.contains("Map")) {
                        conv = JavaUtilCollectionsDeserializers.converter(10, type, Map.class);
                    }
                }
            }
        } else {
            localName = JavaUtilCollectionsDeserializers._findUtilCollectionsImmutableTypeName(clsName);
            if (localName != null && localName.contains("Map")) {
                conv = JavaUtilCollectionsDeserializers.converter(6, type, Map.class);
            }
        }
        return conv == null ? null : new StdDelegatingDeserializer(conv);
    }

    static JavaUtilCollectionsConverter converter(int kind, JavaType concreteType, Class<?> rawSuper) {
        return new JavaUtilCollectionsConverter(kind, concreteType.findSuperType(rawSuper));
    }

    private static String _findUtilArrayTypeName(String clsName) {
        if (clsName.startsWith("java.util.Arrays$")) {
            return clsName.substring("java.util.Arrays$".length());
        }
        return null;
    }

    private static String _findUtilCollectionsTypeName(String clsName) {
        if (clsName.startsWith("java.util.Collections$")) {
            return clsName.substring("java.util.Collections$".length());
        }
        return null;
    }

    private static String _findUtilCollectionsImmutableTypeName(String clsName) {
        if (clsName.startsWith("java.util.ImmutableCollections$")) {
            return clsName.substring("java.util.ImmutableCollections$".length());
        }
        return null;
    }

    private static String _findSingletonTypeName(String localName) {
        return localName.startsWith("Singleton") ? localName.substring(9) : null;
    }

    private static String _findSyncTypeName(String localName) {
        return localName.startsWith("Synchronized") ? localName.substring(12) : null;
    }

    private static String _findUnmodifiableTypeName(String localName) {
        return localName.startsWith("Unmodifiable") ? localName.substring(12) : null;
    }

    private static class JavaUtilCollectionsConverter
    implements Converter<Object, Object> {
        private final JavaType _inputType;
        private final int _kind;

        JavaUtilCollectionsConverter(int kind, JavaType inputType) {
            this._inputType = inputType;
            this._kind = kind;
        }

        @Override
        public Object convert(Object value) {
            if (value == null) {
                return null;
            }
            switch (this._kind) {
                case 1: {
                    Set set = (Set)value;
                    this._checkSingleton(set.size());
                    return Collections.singleton(set.iterator().next());
                }
                case 2: {
                    List list = (List)value;
                    this._checkSingleton(list.size());
                    return Collections.singletonList(list.get(0));
                }
                case 3: {
                    Map map = (Map)value;
                    this._checkSingleton(map.size());
                    Map.Entry entry = map.entrySet().iterator().next();
                    return Collections.singletonMap(entry.getKey(), entry.getValue());
                }
                case 4: {
                    return Collections.unmodifiableSet((Set)value);
                }
                case 5: {
                    return Collections.unmodifiableList((List)value);
                }
                case 6: {
                    return Collections.unmodifiableMap((Map)value);
                }
                case 7: {
                    return Collections.synchronizedSet((Set)value);
                }
                case 9: {
                    return Collections.synchronizedList((List)value);
                }
                case 8: {
                    return Collections.synchronizedCollection((Collection)value);
                }
                case 10: {
                    return Collections.synchronizedMap((Map)value);
                }
            }
            return value;
        }

        @Override
        public JavaType getInputType(TypeFactory typeFactory) {
            return this._inputType;
        }

        @Override
        public JavaType getOutputType(TypeFactory typeFactory) {
            return this._inputType;
        }

        private void _checkSingleton(int size) {
            if (size != 1) {
                throw new IllegalArgumentException("Can not deserialize Singleton container from " + size + " entries");
            }
        }
    }
}

