/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.com.fasterxml.jackson.databind.util;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.util.LookupCache;

public class LRUMap<K, V>
implements Serializable,
LookupCache<K, V> {
    protected final transient int _maxEntries;
    protected final transient ConcurrentHashMap<K, V> _map;

    public LRUMap(int initialEntries, int maxEntries) {
        this._map = new ConcurrentHashMap(initialEntries, 0.8f, 4);
        this._maxEntries = maxEntries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V put(K key, V value) {
        if (this._map.size() >= this._maxEntries) {
            LRUMap lRUMap = this;
            synchronized (lRUMap) {
                if (this._map.size() >= this._maxEntries) {
                    this.clear();
                }
            }
        }
        return this._map.put(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V putIfAbsent(K key, V value) {
        if (this._map.size() >= this._maxEntries) {
            LRUMap lRUMap = this;
            synchronized (lRUMap) {
                if (this._map.size() >= this._maxEntries) {
                    this.clear();
                }
            }
        }
        return this._map.putIfAbsent(key, value);
    }

    @Override
    public V get(Object key) {
        return this._map.get(key);
    }

    public void clear() {
        this._map.clear();
    }
}

