/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.com.fasterxml.jackson.datatype.guava.deser;

import java.io.IOException;
import java.util.List;
import org.glowroot.agent.shaded.com.fasterxml.jackson.core.JsonParseException;
import org.glowroot.agent.shaded.com.fasterxml.jackson.core.JsonParser;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.BeanProperty;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.JavaType;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.type.LogicalType;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableRangeSet;
import org.glowroot.agent.shaded.com.google.common.collect.Range;
import org.glowroot.agent.shaded.com.google.common.collect.RangeSet;

public class RangeSetDeserializer
extends JsonDeserializer<RangeSet<Comparable<?>>>
implements ContextualDeserializer {
    private JavaType genericRangeListType;

    @Override
    public LogicalType logicalType() {
        return LogicalType.Collection;
    }

    @Override
    public RangeSet<Comparable<?>> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (this.genericRangeListType == null) {
            throw new JsonParseException(p, "RangeSetJsonSerializer was not contextualized (no deserialize target type). You need to specify the generic type down to the generic parameter of RangeSet.");
        }
        Iterable ranges = (Iterable)ctxt.findContextualValueDeserializer(this.genericRangeListType, null).deserialize(p, ctxt);
        ImmutableRangeSet.Builder builder = ImmutableRangeSet.builder();
        for (Range range : ranges) {
            builder.add(range);
        }
        return builder.build();
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) {
        JavaType genericType = ctxt.getContextualType().containedType(0);
        if (genericType == null) {
            return this;
        }
        RangeSetDeserializer deserializer = new RangeSetDeserializer();
        deserializer.genericRangeListType = ctxt.getTypeFactory().constructCollectionType(List.class, ctxt.getTypeFactory().constructParametricType(Range.class, genericType));
        return deserializer;
    }
}

