/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.com.google.common.base;

import javax.annotation.CheckForNull;
import org.glowroot.agent.jul.Level;
import org.glowroot.agent.jul.Logger;
import org.glowroot.agent.shaded.com.google.common.base.Platform;

public final class Strings {
    public static String nullToEmpty(@CheckForNull String string) {
        return Platform.nullToEmpty(string);
    }

    @CheckForNull
    public static String emptyToNull(@CheckForNull String string) {
        return Platform.emptyToNull(string);
    }

    public static boolean isNullOrEmpty(@CheckForNull String string) {
        return Platform.stringIsNullOrEmpty(string);
    }

    public static String lenientFormat(@CheckForNull String template, Object ... args) {
        int placeholderStart;
        template = String.valueOf(template);
        if (args == null) {
            args = new Object[]{"(Object[])null"};
        } else {
            for (int i = 0; i < args.length; ++i) {
                args[i] = Strings.lenientToString(args[i]);
            }
        }
        StringBuilder builder = new StringBuilder(template.length() + 16 * args.length);
        int templateStart = 0;
        int i = 0;
        while (i < args.length && (placeholderStart = template.indexOf("%s", templateStart)) != -1) {
            builder.append(template, templateStart, placeholderStart);
            builder.append(args[i++]);
            templateStart = placeholderStart + 2;
        }
        builder.append(template, templateStart, template.length());
        if (i < args.length) {
            builder.append(" [");
            builder.append(args[i++]);
            while (i < args.length) {
                builder.append(", ");
                builder.append(args[i++]);
            }
            builder.append(']');
        }
        return builder.toString();
    }

    private static String lenientToString(@CheckForNull Object o) {
        if (o == null) {
            return "null";
        }
        try {
            return o.toString();
        }
        catch (Exception e) {
            String string = o.getClass().getName();
            String string2 = Integer.toHexString(System.identityHashCode(o));
            String objectToString = new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append('@').append(string2).toString();
            String string3 = String.valueOf(objectToString);
            Logger.getLogger("org.glowroot.agent.shaded.com.google.common.base.Strings").log(Level.WARNING, string3.length() != 0 ? "Exception during lenientFormat for ".concat(string3) : new String("Exception during lenientFormat for "), e);
            string = e.getClass().getName();
            return new StringBuilder(9 + String.valueOf(objectToString).length() + String.valueOf(string).length()).append("<").append(objectToString).append(" threw ").append(string).append(">").toString();
        }
    }
}

