/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.com.google.common.math;

import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;

@CanIgnoreReturnValue
final class MathPreconditions {
    static int checkPositive(String role, int x) {
        if (x <= 0) {
            throw new IllegalArgumentException(new StringBuilder(26 + String.valueOf(role).length()).append(role).append(" (").append(x).append(") must be > 0").toString());
        }
        return x;
    }

    static int checkNonNegative(String role, int x) {
        if (x < 0) {
            throw new IllegalArgumentException(new StringBuilder(27 + String.valueOf(role).length()).append(role).append(" (").append(x).append(") must be >= 0").toString());
        }
        return x;
    }

    static void checkRoundingUnnecessary(boolean condition) {
        if (!condition) {
            throw new ArithmeticException("mode was UNNECESSARY, but rounding was necessary");
        }
    }

    static void checkNoOverflow(boolean condition, String methodName, int a, int b) {
        if (!condition) {
            throw new ArithmeticException(new StringBuilder(36 + String.valueOf(methodName).length()).append("overflow: ").append(methodName).append("(").append(a).append(", ").append(b).append(")").toString());
        }
    }

    static void checkNoOverflow(boolean condition, String methodName, long a, long b) {
        if (!condition) {
            throw new ArithmeticException(new StringBuilder(54 + String.valueOf(methodName).length()).append("overflow: ").append(methodName).append("(").append(a).append(", ").append(b).append(")").toString());
        }
    }
}

