/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.com.google.common.util.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.RunnableFuture;
import javax.annotation.CheckForNull;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.util.concurrent.FluentFuture;
import org.glowroot.agent.shaded.com.google.common.util.concurrent.InterruptibleTask;

class TrustedListenableFutureTask<V>
extends FluentFuture.TrustedFuture<V>
implements RunnableFuture<V> {
    @CheckForNull
    private volatile InterruptibleTask<?> task;

    static <V> TrustedListenableFutureTask<V> create(Callable<V> callable) {
        return new TrustedListenableFutureTask<V>(callable);
    }

    static <V> TrustedListenableFutureTask<V> create(Runnable runnable, V result) {
        return new TrustedListenableFutureTask<V>(Executors.callable(runnable, result));
    }

    TrustedListenableFutureTask(Callable<V> callable) {
        this.task = new TrustedFutureInterruptibleTask(callable);
    }

    @Override
    public void run() {
        InterruptibleTask<?> localTask = this.task;
        if (localTask != null) {
            localTask.run();
        }
        this.task = null;
    }

    @Override
    protected void afterDone() {
        InterruptibleTask<?> localTask;
        super.afterDone();
        if (this.wasInterrupted() && (localTask = this.task) != null) {
            localTask.interruptTask();
        }
        this.task = null;
    }

    @Override
    @CheckForNull
    protected String pendingToString() {
        InterruptibleTask<?> localTask = this.task;
        if (localTask != null) {
            String string = String.valueOf(localTask);
            return new StringBuilder(7 + String.valueOf(string).length()).append("task=[").append(string).append("]").toString();
        }
        return super.pendingToString();
    }

    private final class TrustedFutureInterruptibleTask
    extends InterruptibleTask<V> {
        private final Callable<V> callable;

        TrustedFutureInterruptibleTask(Callable<V> callable) {
            this.callable = Preconditions.checkNotNull(callable);
        }

        @Override
        final boolean isDone() {
            return TrustedListenableFutureTask.this.isDone();
        }

        @Override
        V runInterruptibly() throws Exception {
            return this.callable.call();
        }

        @Override
        void afterRanInterruptiblySuccess(V result) {
            TrustedListenableFutureTask.this.set(result);
        }

        @Override
        void afterRanInterruptiblyFailure(Throwable error) {
            TrustedListenableFutureTask.this.setException(error);
        }

        @Override
        String toPendingString() {
            return this.callable.toString();
        }
    }
}

