/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.com.google.protobuf;

import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import org.glowroot.agent.shaded.com.google.protobuf.BinaryReader;
import org.glowroot.agent.shaded.com.google.protobuf.ByteString;
import org.glowroot.agent.shaded.com.google.protobuf.Descriptors;
import org.glowroot.agent.shaded.com.google.protobuf.ExtensionRegistry;
import org.glowroot.agent.shaded.com.google.protobuf.ExtensionRegistryLite;
import org.glowroot.agent.shaded.com.google.protobuf.ExtensionSchema;
import org.glowroot.agent.shaded.com.google.protobuf.FieldSet;
import org.glowroot.agent.shaded.com.google.protobuf.GeneratedMessageV3;
import org.glowroot.agent.shaded.com.google.protobuf.Internal;
import org.glowroot.agent.shaded.com.google.protobuf.InvalidProtocolBufferException;
import org.glowroot.agent.shaded.com.google.protobuf.LazyField;
import org.glowroot.agent.shaded.com.google.protobuf.Message;
import org.glowroot.agent.shaded.com.google.protobuf.MessageLite;
import org.glowroot.agent.shaded.com.google.protobuf.Protobuf;
import org.glowroot.agent.shaded.com.google.protobuf.Reader;
import org.glowroot.agent.shaded.com.google.protobuf.SchemaUtil;
import org.glowroot.agent.shaded.com.google.protobuf.UnknownFieldSchema;
import org.glowroot.agent.shaded.com.google.protobuf.UnsafeUtil;
import org.glowroot.agent.shaded.com.google.protobuf.WireFormat;

final class ExtensionSchemaFull
extends ExtensionSchema<Descriptors.FieldDescriptor> {
    private static final long EXTENSION_FIELD_OFFSET = ExtensionSchemaFull.getExtensionsFieldOffset();

    ExtensionSchemaFull() {
    }

    private static <T> long getExtensionsFieldOffset() {
        try {
            Field field = GeneratedMessageV3.ExtendableMessage.class.getDeclaredField("extensions");
            return UnsafeUtil.objectFieldOffset(field);
        }
        catch (Throwable e) {
            throw new IllegalStateException("Unable to lookup extension field offset");
        }
    }

    @Override
    boolean hasExtensions(MessageLite prototype) {
        return prototype instanceof GeneratedMessageV3.ExtendableMessage;
    }

    @Override
    public FieldSet<Descriptors.FieldDescriptor> getExtensions(Object message) {
        return (FieldSet)UnsafeUtil.getObject(message, EXTENSION_FIELD_OFFSET);
    }

    @Override
    void setExtensions(Object message, FieldSet<Descriptors.FieldDescriptor> extensions) {
        UnsafeUtil.putObject(message, EXTENSION_FIELD_OFFSET, extensions);
    }

    @Override
    FieldSet<Descriptors.FieldDescriptor> getMutableExtensions(Object message) {
        FieldSet<Descriptors.FieldDescriptor> extensions = this.getExtensions(message);
        if (extensions.isImmutable()) {
            extensions = extensions.clone();
            this.setExtensions(message, extensions);
        }
        return extensions;
    }

    @Override
    void makeImmutable(Object message) {
        this.getExtensions(message).makeImmutable();
    }

    @Override
    <UT, UB> UB parseExtension(Reader reader, Object extensionObject, ExtensionRegistryLite extensionRegistry, FieldSet<Descriptors.FieldDescriptor> extensions, UB unknownFields, UnknownFieldSchema<UT, UB> unknownFieldSchema) throws IOException {
        ExtensionRegistry.ExtensionInfo extension = (ExtensionRegistry.ExtensionInfo)extensionObject;
        int fieldNumber = extension.descriptor.getNumber();
        if (extension.descriptor.isRepeated() && extension.descriptor.isPacked()) {
            ArrayList<Object> value = null;
            switch (extension.descriptor.getLiteType()) {
                case DOUBLE: {
                    ArrayList<Double> list = new ArrayList<Double>();
                    reader.readDoubleList(list);
                    value = list;
                    break;
                }
                case FLOAT: {
                    ArrayList<Float> list = new ArrayList<Float>();
                    reader.readFloatList(list);
                    value = list;
                    break;
                }
                case INT64: {
                    ArrayList<Long> list = new ArrayList<Long>();
                    reader.readInt64List(list);
                    value = list;
                    break;
                }
                case UINT64: {
                    ArrayList<Long> list = new ArrayList<Long>();
                    reader.readUInt64List(list);
                    value = list;
                    break;
                }
                case INT32: {
                    ArrayList<Integer> list = new ArrayList<Integer>();
                    reader.readInt32List(list);
                    value = list;
                    break;
                }
                case FIXED64: {
                    ArrayList<Long> list = new ArrayList<Long>();
                    reader.readFixed64List(list);
                    value = list;
                    break;
                }
                case FIXED32: {
                    ArrayList<Integer> list = new ArrayList<Integer>();
                    reader.readFixed32List(list);
                    value = list;
                    break;
                }
                case BOOL: {
                    ArrayList<Boolean> list = new ArrayList<Boolean>();
                    reader.readBoolList(list);
                    value = list;
                    break;
                }
                case UINT32: {
                    ArrayList<Integer> list = new ArrayList<Integer>();
                    reader.readUInt32List(list);
                    value = list;
                    break;
                }
                case SFIXED32: {
                    ArrayList<Integer> list = new ArrayList<Integer>();
                    reader.readSFixed32List(list);
                    value = list;
                    break;
                }
                case SFIXED64: {
                    ArrayList<Long> list = new ArrayList<Long>();
                    reader.readSFixed64List(list);
                    value = list;
                    break;
                }
                case SINT32: {
                    ArrayList<Integer> list = new ArrayList<Integer>();
                    reader.readSInt32List(list);
                    value = list;
                    break;
                }
                case SINT64: {
                    ArrayList<Long> list = new ArrayList<Long>();
                    reader.readSInt64List(list);
                    value = list;
                    break;
                }
                case ENUM: {
                    ArrayList<Integer> list = new ArrayList<Integer>();
                    reader.readEnumList(list);
                    ArrayList<Descriptors.EnumValueDescriptor> enumList = new ArrayList<Descriptors.EnumValueDescriptor>();
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        int number = (Integer)iterator.next();
                        Descriptors.EnumValueDescriptor enumDescriptor = extension.descriptor.getEnumType().findValueByNumber(number);
                        if (enumDescriptor != null) {
                            enumList.add(enumDescriptor);
                            continue;
                        }
                        unknownFields = SchemaUtil.storeUnknownEnum(fieldNumber, number, unknownFields, unknownFieldSchema);
                    }
                    value = enumList;
                    break;
                }
                default: {
                    throw new IllegalStateException("Type cannot be packed: " + (Object)((Object)extension.descriptor.getLiteType()));
                }
            }
            extensions.setField(extension.descriptor, value);
        } else {
            Object value = null;
            if (extension.descriptor.getLiteType() == WireFormat.FieldType.ENUM) {
                int number = reader.readInt32();
                Descriptors.EnumValueDescriptor enumValue = extension.descriptor.getEnumType().findValueByNumber(number);
                if (enumValue == null) {
                    return SchemaUtil.storeUnknownEnum(fieldNumber, number, unknownFields, unknownFieldSchema);
                }
                value = enumValue;
            } else {
                switch (extension.descriptor.getLiteType()) {
                    case DOUBLE: {
                        value = reader.readDouble();
                        break;
                    }
                    case FLOAT: {
                        value = Float.valueOf(reader.readFloat());
                        break;
                    }
                    case INT64: {
                        value = reader.readInt64();
                        break;
                    }
                    case UINT64: {
                        value = reader.readUInt64();
                        break;
                    }
                    case INT32: {
                        value = reader.readInt32();
                        break;
                    }
                    case FIXED64: {
                        value = reader.readFixed64();
                        break;
                    }
                    case FIXED32: {
                        value = reader.readFixed32();
                        break;
                    }
                    case BOOL: {
                        value = reader.readBool();
                        break;
                    }
                    case BYTES: {
                        value = reader.readBytes();
                        break;
                    }
                    case UINT32: {
                        value = reader.readUInt32();
                        break;
                    }
                    case SFIXED32: {
                        value = reader.readSFixed32();
                        break;
                    }
                    case SFIXED64: {
                        value = reader.readSFixed64();
                        break;
                    }
                    case SINT32: {
                        value = reader.readSInt32();
                        break;
                    }
                    case SINT64: {
                        value = reader.readSInt64();
                        break;
                    }
                    case STRING: {
                        value = reader.readString();
                        break;
                    }
                    case GROUP: {
                        value = reader.readGroup(extension.defaultInstance.getClass(), extensionRegistry);
                        break;
                    }
                    case MESSAGE: {
                        value = reader.readMessage(extension.defaultInstance.getClass(), extensionRegistry);
                        break;
                    }
                    case ENUM: {
                        throw new IllegalStateException("Shouldn't reach here.");
                    }
                }
            }
            if (extension.descriptor.isRepeated()) {
                extensions.addRepeatedField(extension.descriptor, value);
            } else {
                switch (extension.descriptor.getLiteType()) {
                    case GROUP: 
                    case MESSAGE: {
                        Object oldValue = extensions.getField(extension.descriptor);
                        if (oldValue == null) break;
                        value = Internal.mergeMessage(oldValue, value);
                        break;
                    }
                }
                extensions.setField(extension.descriptor, value);
            }
        }
        return unknownFields;
    }

    @Override
    Object findExtensionByNumber(ExtensionRegistryLite extensionRegistry, MessageLite defaultInstance, int number) {
        return ((ExtensionRegistry)extensionRegistry).findExtensionByNumber(((Message)defaultInstance).getDescriptorForType(), number);
    }

    @Override
    void parseLengthPrefixedMessageSetItem(Reader reader, Object extension, ExtensionRegistryLite extensionRegistry, FieldSet<Descriptors.FieldDescriptor> extensions) throws IOException {
        ExtensionRegistry.ExtensionInfo extensionInfo = (ExtensionRegistry.ExtensionInfo)extension;
        if (ExtensionRegistryLite.isEagerlyParseMessageSets()) {
            Object value = reader.readMessage(extensionInfo.defaultInstance.getClass(), extensionRegistry);
            extensions.setField(extensionInfo.descriptor, value);
        } else {
            extensions.setField(extensionInfo.descriptor, new LazyField(extensionInfo.defaultInstance, extensionRegistry, reader.readBytes()));
        }
    }

    @Override
    void parseMessageSetItem(ByteString data, Object extension, ExtensionRegistryLite extensionRegistry, FieldSet<Descriptors.FieldDescriptor> extensions) throws IOException {
        ExtensionRegistry.ExtensionInfo extensionInfo = (ExtensionRegistry.ExtensionInfo)extension;
        Message value = extensionInfo.defaultInstance.newBuilderForType().buildPartial();
        if (ExtensionRegistryLite.isEagerlyParseMessageSets()) {
            BinaryReader reader = BinaryReader.newInstance(ByteBuffer.wrap(data.toByteArray()), true);
            Protobuf.getInstance().mergeFrom(value, reader, extensionRegistry);
            extensions.setField(extensionInfo.descriptor, value);
            if (reader.getFieldNumber() != Integer.MAX_VALUE) {
                throw InvalidProtocolBufferException.invalidEndTag();
            }
        } else {
            extensions.setField(extensionInfo.descriptor, new LazyField(extensionInfo.defaultInstance, extensionRegistry, data));
        }
    }
}

