/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.com.google.protobuf;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import org.glowroot.agent.shaded.com.google.protobuf.ByteOutput;
import org.glowroot.agent.shaded.com.google.protobuf.ByteString;
import org.glowroot.agent.shaded.com.google.protobuf.CodedInputStream;
import org.glowroot.agent.shaded.com.google.protobuf.Internal;
import org.glowroot.agent.shaded.com.google.protobuf.RopeByteString;
import org.glowroot.agent.shaded.com.google.protobuf.Utf8;

final class NioByteString
extends ByteString.LeafByteString {
    private final ByteBuffer buffer;

    NioByteString(ByteBuffer buffer) {
        Internal.checkNotNull(buffer, "buffer");
        this.buffer = buffer.slice().order(ByteOrder.nativeOrder());
    }

    @Override
    public byte byteAt(int index) {
        try {
            return this.buffer.get(index);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw e;
        }
        catch (IndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException(e.getMessage());
        }
    }

    @Override
    public byte internalByteAt(int index) {
        return this.byteAt(index);
    }

    @Override
    public int size() {
        return this.buffer.remaining();
    }

    @Override
    public ByteString substring(int beginIndex, int endIndex) {
        try {
            ByteBuffer slice = this.slice(beginIndex, endIndex);
            return new NioByteString(slice);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw e;
        }
        catch (IndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException(e.getMessage());
        }
    }

    @Override
    protected void copyToInternal(byte[] target, int sourceOffset, int targetOffset, int numberToCopy) {
        ByteBuffer slice = this.buffer.slice();
        ((Buffer)slice).position(sourceOffset);
        slice.get(target, targetOffset, numberToCopy);
    }

    @Override
    boolean equalsRange(ByteString other, int offset, int length) {
        return this.substring(0, length).equals(other.substring(offset, offset + length));
    }

    @Override
    void writeTo(ByteOutput output) throws IOException {
        output.writeLazy(this.buffer.slice());
    }

    @Override
    public ByteBuffer asReadOnlyByteBuffer() {
        return this.buffer.asReadOnlyBuffer();
    }

    @Override
    protected String toStringInternal(Charset charset) {
        int length;
        int offset;
        byte[] bytes;
        if (this.buffer.hasArray()) {
            bytes = this.buffer.array();
            offset = this.buffer.arrayOffset() + this.buffer.position();
            length = this.buffer.remaining();
        } else {
            bytes = this.toByteArray();
            offset = 0;
            length = bytes.length;
        }
        return new String(bytes, offset, length, charset);
    }

    @Override
    public boolean isValidUtf8() {
        return Utf8.isValidUtf8(this.buffer);
    }

    @Override
    protected int partialIsValidUtf8(int state, int offset, int length) {
        return Utf8.partialIsValidUtf8(state, this.buffer, offset, offset + length);
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ByteString)) {
            return false;
        }
        ByteString otherString = (ByteString)other;
        if (this.size() != otherString.size()) {
            return false;
        }
        if (this.size() == 0) {
            return true;
        }
        if (other instanceof NioByteString) {
            return this.buffer.equals(((NioByteString)other).buffer);
        }
        if (other instanceof RopeByteString) {
            return other.equals(this);
        }
        return this.buffer.equals(otherString.asReadOnlyByteBuffer());
    }

    @Override
    protected int partialHash(int h, int offset, int length) {
        for (int i = offset; i < offset + length; ++i) {
            h = h * 31 + this.buffer.get(i);
        }
        return h;
    }

    @Override
    public CodedInputStream newCodedInput() {
        return CodedInputStream.newInstance(this.buffer, true);
    }

    private ByteBuffer slice(int beginIndex, int endIndex) {
        if (beginIndex < this.buffer.position() || endIndex > this.buffer.limit() || beginIndex > endIndex) {
            throw new IllegalArgumentException(String.format("Invalid indices [%d, %d]", beginIndex, endIndex));
        }
        ByteBuffer slice = this.buffer.slice();
        ((Buffer)slice).position(beginIndex - this.buffer.position());
        ((Buffer)slice).limit(endIndex - this.buffer.position());
        return slice;
    }
}

