/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.io.grpc;

import java.security.cert.Certificate;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.glowroot.agent.jul.Level;
import org.glowroot.agent.jul.Logger;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.base.Objects;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.io.grpc.InternalInstrumented;
import org.glowroot.agent.shaded.io.grpc.InternalWithLogId;

public final class InternalChannelz {
    private static final Logger log = Logger.getLogger(InternalChannelz.class.getName());
    private static final InternalChannelz INSTANCE = new InternalChannelz();
    private final ConcurrentNavigableMap<Long, InternalInstrumented<Object>> servers = new ConcurrentSkipListMap<Long, InternalInstrumented<Object>>();
    private final ConcurrentNavigableMap<Long, InternalInstrumented<Object>> rootChannels = new ConcurrentSkipListMap<Long, InternalInstrumented<Object>>();
    private final ConcurrentMap<Long, InternalInstrumented<Object>> subchannels = new ConcurrentHashMap<Long, InternalInstrumented<Object>>();
    private final ConcurrentMap<Long, InternalInstrumented<Object>> otherSockets = new ConcurrentHashMap<Long, InternalInstrumented<Object>>();
    private final ConcurrentMap<Long, Object> perServerSockets = new ConcurrentHashMap<Long, Object>();

    public static InternalChannelz instance() {
        return INSTANCE;
    }

    public void addSubchannel(InternalInstrumented<Object> subchannel) {
        InternalChannelz.add(this.subchannels, subchannel);
    }

    public void addRootChannel(InternalInstrumented<Object> rootChannel) {
        InternalChannelz.add(this.rootChannels, rootChannel);
    }

    public void addClientSocket(InternalInstrumented<Object> socket) {
        InternalChannelz.add(this.otherSockets, socket);
    }

    public void removeSubchannel(InternalInstrumented<Object> subchannel) {
        InternalChannelz.remove(this.subchannels, subchannel);
    }

    public void removeRootChannel(InternalInstrumented<Object> channel) {
        InternalChannelz.remove(this.rootChannels, channel);
    }

    public void removeClientSocket(InternalInstrumented<Object> socket) {
        InternalChannelz.remove(this.otherSockets, socket);
    }

    private static <T extends InternalInstrumented<?>> void add(Map<Long, T> map, T object) {
        InternalInstrumented prev = (InternalInstrumented)map.put(object.getLogId().getId(), object);
        assert (prev == null);
    }

    private static <T extends InternalInstrumented<?>> void remove(Map<Long, T> map, T object) {
        InternalInstrumented prev = (InternalInstrumented)map.remove(InternalChannelz.id(object));
        assert (prev != null);
    }

    public static long id(InternalWithLogId withLogId) {
        return withLogId.getLogId().getId();
    }

    @Immutable
    public static final class Tls {
        public final String cipherSuiteStandardName;
        @Nullable
        public final Certificate localCert;
        @Nullable
        public final Certificate remoteCert;

        public Tls(SSLSession session) {
            String cipherSuiteStandardName = session.getCipherSuite();
            Certificate localCert = null;
            Certificate remoteCert = null;
            Certificate[] localCerts = session.getLocalCertificates();
            if (localCerts != null) {
                localCert = localCerts[0];
            }
            try {
                Certificate[] peerCerts = session.getPeerCertificates();
                if (peerCerts != null) {
                    remoteCert = peerCerts[0];
                }
            }
            catch (SSLPeerUnverifiedException e) {
                log.log(Level.FINE, String.format("Peer cert not available for peerHost=%s", session.getPeerHost()), e);
            }
            this.cipherSuiteStandardName = cipherSuiteStandardName;
            this.localCert = localCert;
            this.remoteCert = remoteCert;
        }
    }

    public static final class OtherSecurity {
    }

    public static final class Security {
        @Nullable
        public final Tls tls;
        @Nullable
        public final OtherSecurity other;

        public Security(Tls tls) {
            this.tls = Preconditions.checkNotNull(tls);
            this.other = null;
        }
    }

    @Immutable
    public static final class ChannelTrace {

        @Immutable
        public static final class Event {
            public final String description;
            public final Severity severity;
            public final long timestampNanos;
            @Nullable
            public final InternalWithLogId channelRef;
            @Nullable
            public final InternalWithLogId subchannelRef;

            private Event(String description, Severity severity, long timestampNanos, @Nullable InternalWithLogId channelRef, @Nullable InternalWithLogId subchannelRef) {
                this.description = description;
                this.severity = Preconditions.checkNotNull(severity, "severity");
                this.timestampNanos = timestampNanos;
                this.channelRef = channelRef;
                this.subchannelRef = subchannelRef;
            }

            public int hashCode() {
                return Objects.hashCode(new Object[]{this.description, this.severity, this.timestampNanos, this.channelRef, this.subchannelRef});
            }

            public boolean equals(Object o) {
                if (o instanceof Event) {
                    Event that = (Event)o;
                    return Objects.equal(this.description, that.description) && Objects.equal((Object)this.severity, (Object)that.severity) && this.timestampNanos == that.timestampNanos && Objects.equal(this.channelRef, that.channelRef) && Objects.equal(this.subchannelRef, that.subchannelRef);
                }
                return false;
            }

            public String toString() {
                return MoreObjects.toStringHelper(this).add("description", this.description).add("severity", (Object)this.severity).add("timestampNanos", this.timestampNanos).add("channelRef", this.channelRef).add("subchannelRef", this.subchannelRef).toString();
            }

            public static final class Builder {
                private String description;
                private Severity severity;
                private Long timestampNanos;
                private InternalWithLogId channelRef;
                private InternalWithLogId subchannelRef;

                public Builder setDescription(String description) {
                    this.description = description;
                    return this;
                }

                public Builder setTimestampNanos(long timestampNanos) {
                    this.timestampNanos = timestampNanos;
                    return this;
                }

                public Builder setSeverity(Severity severity) {
                    this.severity = severity;
                    return this;
                }

                public Builder setSubchannelRef(InternalWithLogId subchannelRef) {
                    this.subchannelRef = subchannelRef;
                    return this;
                }

                public Event build() {
                    Preconditions.checkNotNull(this.description, "description");
                    Preconditions.checkNotNull(this.severity, "severity");
                    Preconditions.checkNotNull(this.timestampNanos, "timestampNanos");
                    Preconditions.checkState(this.channelRef == null || this.subchannelRef == null, "at least one of channelRef and subchannelRef must be null");
                    return new Event(this.description, this.severity, this.timestampNanos, this.channelRef, this.subchannelRef);
                }
            }

            public static enum Severity {
                CT_UNKNOWN,
                CT_INFO,
                CT_WARNING,
                CT_ERROR;

            }
        }
    }
}

