/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.io.grpc;

import javax.annotation.Nullable;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.io.grpc.Attributes;
import org.glowroot.agent.shaded.io.grpc.ClientInterceptor;
import org.glowroot.agent.shaded.io.grpc.LoadBalancer;
import org.glowroot.agent.shaded.io.grpc.Status;

public abstract class InternalConfigSelector {
    public static final Attributes.Key<InternalConfigSelector> KEY = Attributes.Key.create("org.glowroot.agent.shaded.io.grpc.config-selector");

    public abstract Result selectConfig(LoadBalancer.PickSubchannelArgs var1);

    public static final class Result {
        private final Status status;
        private final Object config;
        @Nullable
        public ClientInterceptor interceptor;

        private Result(Status status, Object config, ClientInterceptor interceptor) {
            this.status = Preconditions.checkNotNull(status, "status");
            this.config = config;
            this.interceptor = interceptor;
        }

        public Status getStatus() {
            return this.status;
        }

        public Object getConfig() {
            return this.config;
        }

        @Nullable
        public ClientInterceptor getInterceptor() {
            return this.interceptor;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static final class Builder {
            private Object config;
            private ClientInterceptor interceptor;

            private Builder() {
            }

            public Builder setConfig(Object config) {
                this.config = Preconditions.checkNotNull(config, "config");
                return this;
            }

            public Result build() {
                Preconditions.checkState(this.config != null, "config is not set");
                return new Result(Status.OK, this.config, this.interceptor);
            }
        }
    }
}

