/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.io.grpc.internal;

import java.net.URI;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.base.Stopwatch;
import org.glowroot.agent.shaded.io.grpc.InternalServiceProviders;
import org.glowroot.agent.shaded.io.grpc.NameResolver;
import org.glowroot.agent.shaded.io.grpc.NameResolverProvider;
import org.glowroot.agent.shaded.io.grpc.internal.DnsNameResolver;
import org.glowroot.agent.shaded.io.grpc.internal.GrpcUtil;

public final class DnsNameResolverProvider
extends NameResolverProvider {
    @Override
    public DnsNameResolver newNameResolver(URI targetUri, NameResolver.Args args) {
        if ("dns".equals(targetUri.getScheme())) {
            String targetPath = Preconditions.checkNotNull(targetUri.getPath(), "targetPath");
            Preconditions.checkArgument(targetPath.startsWith("/"), "the path component (%s) of the target (%s) must start with '/'", targetPath, (Object)targetUri);
            String name = targetPath.substring(1);
            return new DnsNameResolver(targetUri.getAuthority(), name, args, GrpcUtil.SHARED_CHANNEL_EXECUTOR, Stopwatch.createUnstarted(), InternalServiceProviders.isAndroid(this.getClass().getClassLoader()));
        }
        return null;
    }

    @Override
    public String getDefaultScheme() {
        return "dns";
    }

    @Override
    protected boolean isAvailable() {
        return true;
    }

    @Override
    public int priority() {
        return 5;
    }
}

