/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.io.grpc.internal;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.glowroot.agent.jul.Level;
import org.glowroot.agent.jul.Logger;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.base.Splitter;
import org.glowroot.agent.shaded.com.google.common.base.Stopwatch;
import org.glowroot.agent.shaded.com.google.common.base.Supplier;
import org.glowroot.agent.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.glowroot.agent.shaded.io.grpc.CallOptions;
import org.glowroot.agent.shaded.io.grpc.ClientStreamTracer;
import org.glowroot.agent.shaded.io.grpc.InternalLogId;
import org.glowroot.agent.shaded.io.grpc.InternalMetadata;
import org.glowroot.agent.shaded.io.grpc.LoadBalancer;
import org.glowroot.agent.shaded.io.grpc.Metadata;
import org.glowroot.agent.shaded.io.grpc.MethodDescriptor;
import org.glowroot.agent.shaded.io.grpc.ProxiedSocketAddress;
import org.glowroot.agent.shaded.io.grpc.ProxyDetector;
import org.glowroot.agent.shaded.io.grpc.Status;
import org.glowroot.agent.shaded.io.grpc.internal.ClientStream;
import org.glowroot.agent.shaded.io.grpc.internal.ClientStreamListener;
import org.glowroot.agent.shaded.io.grpc.internal.ClientTransport;
import org.glowroot.agent.shaded.io.grpc.internal.FailingClientTransport;
import org.glowroot.agent.shaded.io.grpc.internal.ProxyDetectorImpl;
import org.glowroot.agent.shaded.io.grpc.internal.SharedResourceHolder;
import org.glowroot.agent.shaded.io.grpc.internal.StreamListener;
import org.glowroot.agent.shaded.io.grpc.internal.TransportProvider;

public final class GrpcUtil {
    private static final Logger log = Logger.getLogger(GrpcUtil.class.getName());
    public static final Charset US_ASCII = StandardCharsets.US_ASCII;
    public static final Metadata.Key<Long> TIMEOUT_KEY = Metadata.Key.of("grpc-timeout", new TimeoutMarshaller());
    public static final Metadata.Key<String> MESSAGE_ENCODING_KEY = Metadata.Key.of("grpc-encoding", Metadata.ASCII_STRING_MARSHALLER);
    public static final Metadata.Key<byte[]> MESSAGE_ACCEPT_ENCODING_KEY = InternalMetadata.keyOf("grpc-accept-encoding", new AcceptEncodingMarshaller());
    public static final Metadata.Key<String> CONTENT_ENCODING_KEY = Metadata.Key.of("content-encoding", Metadata.ASCII_STRING_MARSHALLER);
    public static final Metadata.Key<byte[]> CONTENT_ACCEPT_ENCODING_KEY = InternalMetadata.keyOf("accept-encoding", new AcceptEncodingMarshaller());
    static final Metadata.Key<String> CONTENT_LENGTH_KEY = Metadata.Key.of("content-length", Metadata.ASCII_STRING_MARSHALLER);
    public static final Metadata.Key<String> CONTENT_TYPE_KEY = Metadata.Key.of("content-type", Metadata.ASCII_STRING_MARSHALLER);
    public static final Metadata.Key<String> TE_HEADER = Metadata.Key.of("te", Metadata.ASCII_STRING_MARSHALLER);
    public static final Metadata.Key<String> USER_AGENT_KEY = Metadata.Key.of("user-agent", Metadata.ASCII_STRING_MARSHALLER);
    public static final Splitter ACCEPT_ENCODING_SPLITTER = Splitter.on(',').trimResults();
    public static final long DEFAULT_KEEPALIVE_TIMEOUT_NANOS = TimeUnit.SECONDS.toNanos(20L);
    public static final long DEFAULT_SERVER_KEEPALIVE_TIME_NANOS = TimeUnit.HOURS.toNanos(2L);
    public static final long DEFAULT_SERVER_KEEPALIVE_TIMEOUT_NANOS = TimeUnit.SECONDS.toNanos(20L);
    public static final ProxyDetector DEFAULT_PROXY_DETECTOR = new ProxyDetectorImpl();
    public static final ProxyDetector NOOP_PROXY_DETECTOR = new ProxyDetector(){

        @Override
        @Nullable
        public ProxiedSocketAddress proxyFor(SocketAddress targetServerAddress) {
            return null;
        }
    };
    public static final CallOptions.Key<Boolean> CALL_OPTIONS_RPC_OWNED_BY_BALANCER = CallOptions.Key.create("org.glowroot.agent.shaded.io.grpc.internal.CALL_OPTIONS_RPC_OWNED_BY_BALANCER");
    private static final ClientStreamTracer NOOP_TRACER = new ClientStreamTracer(){};
    public static final SharedResourceHolder.Resource<Executor> SHARED_CHANNEL_EXECUTOR = new SharedResourceHolder.Resource<Executor>(){

        @Override
        public Executor create() {
            return Executors.newCachedThreadPool(GrpcUtil.getThreadFactory("grpc-default-executor-%d", true));
        }

        @Override
        public void close(Executor instance) {
            ((ExecutorService)instance).shutdown();
        }

        public String toString() {
            return "grpc-default-executor";
        }
    };
    public static final SharedResourceHolder.Resource<ScheduledExecutorService> TIMER_SERVICE = new SharedResourceHolder.Resource<ScheduledExecutorService>(){

        @Override
        public ScheduledExecutorService create() {
            ScheduledExecutorService service = Executors.newScheduledThreadPool(1, GrpcUtil.getThreadFactory("grpc-timer-%d", true));
            try {
                Method method = service.getClass().getMethod("setRemoveOnCancelPolicy", Boolean.TYPE);
                method.invoke((Object)service, true);
            }
            catch (NoSuchMethodException method) {
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return Executors.unconfigurableScheduledExecutorService(service);
        }

        @Override
        public void close(ScheduledExecutorService instance) {
            instance.shutdown();
        }
    };
    public static final Supplier<Stopwatch> STOPWATCH_SUPPLIER = new Supplier<Stopwatch>(){

        @Override
        public Stopwatch get() {
            return Stopwatch.createUnstarted();
        }
    };

    public static boolean shouldBeCountedForInUse(CallOptions callOptions) {
        return !Boolean.TRUE.equals(callOptions.getOption(CALL_OPTIONS_RPC_OWNED_BY_BALANCER));
    }

    public static Status httpStatusToGrpcStatus(int httpStatusCode) {
        return GrpcUtil.httpStatusToGrpcCode(httpStatusCode).toStatus().withDescription("HTTP status code " + httpStatusCode);
    }

    private static Status.Code httpStatusToGrpcCode(int httpStatusCode) {
        if (httpStatusCode >= 100 && httpStatusCode < 200) {
            return Status.Code.INTERNAL;
        }
        switch (httpStatusCode) {
            case 400: 
            case 431: {
                return Status.Code.INTERNAL;
            }
            case 401: {
                return Status.Code.UNAUTHENTICATED;
            }
            case 403: {
                return Status.Code.PERMISSION_DENIED;
            }
            case 404: {
                return Status.Code.UNIMPLEMENTED;
            }
            case 429: 
            case 502: 
            case 503: 
            case 504: {
                return Status.Code.UNAVAILABLE;
            }
        }
        return Status.Code.UNKNOWN;
    }

    public static boolean isGrpcContentType(String contentType) {
        if (contentType == null) {
            return false;
        }
        if ("application/grpc".length() > contentType.length()) {
            return false;
        }
        if (!(contentType = contentType.toLowerCase()).startsWith("application/grpc")) {
            return false;
        }
        if (contentType.length() == "application/grpc".length()) {
            return true;
        }
        char nextChar = contentType.charAt("application/grpc".length());
        return nextChar == '+' || nextChar == ';';
    }

    public static String getGrpcUserAgent(String transportName, @Nullable String applicationUserAgent) {
        StringBuilder builder = new StringBuilder();
        if (applicationUserAgent != null) {
            builder.append(applicationUserAgent);
            builder.append(' ');
        }
        builder.append("grpc-java-");
        builder.append(transportName);
        builder.append('/');
        builder.append("1.44.1");
        return builder.toString();
    }

    public static URI authorityToUri(String authority) {
        URI uri;
        Preconditions.checkNotNull(authority, "authority");
        try {
            uri = new URI(null, authority, null, null, null);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException("Invalid authority: " + authority, ex);
        }
        return uri;
    }

    public static String checkAuthority(String authority) {
        URI uri = GrpcUtil.authorityToUri(authority);
        Preconditions.checkArgument(uri.getHost() != null, "No host in authority '%s'", authority);
        Preconditions.checkArgument(uri.getUserInfo() == null, "Userinfo must not be present on authority: '%s'", authority);
        return authority;
    }

    public static String authorityFromHostAndPort(String host, int port) {
        try {
            return new URI(null, null, host, port, null, null, null).getAuthority();
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException("Invalid host or port: " + host + " " + port, ex);
        }
    }

    public static ThreadFactory getThreadFactory(String nameFormat, boolean daemon) {
        return new ThreadFactoryBuilder().setDaemon(daemon).setNameFormat(nameFormat).build();
    }

    public static String getHost(InetSocketAddress addr) {
        try {
            Method getHostStringMethod = InetSocketAddress.class.getMethod("getHostString", new Class[0]);
            return (String)getHostStringMethod.invoke((Object)addr, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return addr.getHostName();
    }

    @Nullable
    static ClientTransport getTransportFromPickResult(LoadBalancer.PickResult result, boolean isWaitForReady) {
        LoadBalancer.Subchannel subchannel = result.getSubchannel();
        final ClientTransport transport = subchannel != null ? ((TransportProvider)subchannel.getInternalSubchannel()).obtainActiveTransport() : null;
        if (transport != null) {
            final ClientStreamTracer.Factory streamTracerFactory = result.getStreamTracerFactory();
            if (streamTracerFactory == null) {
                return transport;
            }
            return new ClientTransport(){

                @Override
                public ClientStream newStream(MethodDescriptor<?, ?> method, Metadata headers, CallOptions callOptions, ClientStreamTracer[] tracers) {
                    ClientStreamTracer.StreamInfo info = ClientStreamTracer.StreamInfo.newBuilder().setCallOptions(callOptions).build();
                    ClientStreamTracer streamTracer = streamTracerFactory.newClientStreamTracer(info, headers);
                    Preconditions.checkState(tracers[tracers.length - 1] == NOOP_TRACER, "lb tracer already assigned");
                    tracers[tracers.length - 1] = streamTracer;
                    return transport.newStream(method, headers, callOptions, tracers);
                }

                @Override
                public void ping(ClientTransport.PingCallback callback, Executor executor) {
                    transport.ping(callback, executor);
                }

                @Override
                public InternalLogId getLogId() {
                    return transport.getLogId();
                }
            };
        }
        if (!result.getStatus().isOk()) {
            if (result.isDrop()) {
                return new FailingClientTransport(result.getStatus(), ClientStreamListener.RpcProgress.DROPPED);
            }
            if (!isWaitForReady) {
                return new FailingClientTransport(result.getStatus(), ClientStreamListener.RpcProgress.PROCESSED);
            }
        }
        return null;
    }

    public static ClientStreamTracer[] getClientStreamTracers(CallOptions callOptions, Metadata headers, int previousAttempts, boolean isTransparentRetry) {
        List<ClientStreamTracer.Factory> factories = callOptions.getStreamTracerFactories();
        ClientStreamTracer[] tracers = new ClientStreamTracer[factories.size() + 1];
        ClientStreamTracer.StreamInfo streamInfo = ClientStreamTracer.StreamInfo.newBuilder().setCallOptions(callOptions).setPreviousAttempts(previousAttempts).setIsTransparentRetry(isTransparentRetry).build();
        for (int i = 0; i < factories.size(); ++i) {
            tracers[i] = factories.get(i).newClientStreamTracer(streamInfo, headers);
        }
        tracers[tracers.length - 1] = NOOP_TRACER;
        return tracers;
    }

    static void closeQuietly(StreamListener.MessageProducer producer) {
        InputStream message;
        while ((message = producer.next()) != null) {
            GrpcUtil.closeQuietly(message);
        }
    }

    public static void closeQuietly(@Nullable Closeable message) {
        if (message == null) {
            return;
        }
        try {
            message.close();
        }
        catch (IOException ioException) {
            log.log(Level.WARNING, "exception caught in closeQuietly", ioException);
        }
    }

    private GrpcUtil() {
    }

    static class TimeoutMarshaller
    implements Metadata.AsciiMarshaller<Long> {
        TimeoutMarshaller() {
        }

        @Override
        public String toAsciiString(Long timeoutNanos) {
            long cutoff = 100000000L;
            TimeUnit unit = TimeUnit.NANOSECONDS;
            if (timeoutNanos < 0L) {
                throw new IllegalArgumentException("Timeout too small");
            }
            if (timeoutNanos < cutoff) {
                return timeoutNanos + "n";
            }
            if (timeoutNanos < cutoff * 1000L) {
                return unit.toMicros(timeoutNanos) + "u";
            }
            if (timeoutNanos < cutoff * 1000L * 1000L) {
                return unit.toMillis(timeoutNanos) + "m";
            }
            if (timeoutNanos < cutoff * 1000L * 1000L * 1000L) {
                return unit.toSeconds(timeoutNanos) + "S";
            }
            if (timeoutNanos < cutoff * 1000L * 1000L * 1000L * 60L) {
                return unit.toMinutes(timeoutNanos) + "M";
            }
            return unit.toHours(timeoutNanos) + "H";
        }

        @Override
        public Long parseAsciiString(String serialized) {
            Preconditions.checkArgument(serialized.length() > 0, "empty timeout");
            Preconditions.checkArgument(serialized.length() <= 9, "bad timeout format");
            long value = Long.parseLong(serialized.substring(0, serialized.length() - 1));
            char unit = serialized.charAt(serialized.length() - 1);
            switch (unit) {
                case 'n': {
                    return value;
                }
                case 'u': {
                    return TimeUnit.MICROSECONDS.toNanos(value);
                }
                case 'm': {
                    return TimeUnit.MILLISECONDS.toNanos(value);
                }
                case 'S': {
                    return TimeUnit.SECONDS.toNanos(value);
                }
                case 'M': {
                    return TimeUnit.MINUTES.toNanos(value);
                }
                case 'H': {
                    return TimeUnit.HOURS.toNanos(value);
                }
            }
            throw new IllegalArgumentException(String.format("Invalid timeout unit: %s", Character.valueOf(unit)));
        }
    }

    public static enum Http2Error {
        NO_ERROR(0, Status.UNAVAILABLE),
        PROTOCOL_ERROR(1, Status.INTERNAL),
        INTERNAL_ERROR(2, Status.INTERNAL),
        FLOW_CONTROL_ERROR(3, Status.INTERNAL),
        SETTINGS_TIMEOUT(4, Status.INTERNAL),
        STREAM_CLOSED(5, Status.INTERNAL),
        FRAME_SIZE_ERROR(6, Status.INTERNAL),
        REFUSED_STREAM(7, Status.UNAVAILABLE),
        CANCEL(8, Status.CANCELLED),
        COMPRESSION_ERROR(9, Status.INTERNAL),
        CONNECT_ERROR(10, Status.INTERNAL),
        ENHANCE_YOUR_CALM(11, Status.RESOURCE_EXHAUSTED.withDescription("Bandwidth exhausted")),
        INADEQUATE_SECURITY(12, Status.PERMISSION_DENIED.withDescription("Permission denied as protocol is not secure enough to call")),
        HTTP_1_1_REQUIRED(13, Status.UNKNOWN);

        private static final Http2Error[] codeMap;
        private final int code;
        private final Status status;

        private static Http2Error[] buildHttp2CodeMap() {
            Http2Error[] errors = Http2Error.values();
            int size = (int)errors[errors.length - 1].code() + 1;
            Http2Error[] http2CodeMap = new Http2Error[size];
            for (Http2Error error : errors) {
                int index = (int)error.code();
                http2CodeMap[index] = error;
            }
            return http2CodeMap;
        }

        private Http2Error(int code, Status status) {
            this.code = code;
            String description = "HTTP/2 error code: " + this.name();
            if (status.getDescription() != null) {
                description = description + " (" + status.getDescription() + ")";
            }
            this.status = status.withDescription(description);
        }

        public long code() {
            return this.code;
        }

        public Status status() {
            return this.status;
        }

        public static Http2Error forCode(long code) {
            if (code >= (long)codeMap.length || code < 0L) {
                return null;
            }
            return codeMap[(int)code];
        }

        public static Status statusForCode(long code) {
            Http2Error error = Http2Error.forCode(code);
            if (error == null) {
                Status.Code statusCode = INTERNAL_ERROR.status().getCode();
                return Status.fromCodeValue(statusCode.value()).withDescription("Unrecognized HTTP/2 error code: " + code);
            }
            return error.status();
        }

        static {
            codeMap = Http2Error.buildHttp2CodeMap();
        }
    }

    private static final class AcceptEncodingMarshaller
    implements InternalMetadata.TrustedAsciiMarshaller<byte[]> {
        private AcceptEncodingMarshaller() {
        }

        @Override
        public byte[] toAsciiString(byte[] value) {
            return value;
        }

        @Override
        public byte[] parseAsciiString(byte[] serialized) {
            return serialized;
        }
    }
}

