/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.io.grpc.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.glowroot.agent.jul.Level;
import org.glowroot.agent.jul.Logger;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.io.grpc.BinaryLog;
import org.glowroot.agent.shaded.io.grpc.CallCredentials;
import org.glowroot.agent.shaded.io.grpc.ChannelCredentials;
import org.glowroot.agent.shaded.io.grpc.ClientInterceptor;
import org.glowroot.agent.shaded.io.grpc.CompressorRegistry;
import org.glowroot.agent.shaded.io.grpc.DecompressorRegistry;
import org.glowroot.agent.shaded.io.grpc.InternalChannelz;
import org.glowroot.agent.shaded.io.grpc.ManagedChannel;
import org.glowroot.agent.shaded.io.grpc.ManagedChannelBuilder;
import org.glowroot.agent.shaded.io.grpc.NameResolver;
import org.glowroot.agent.shaded.io.grpc.NameResolverRegistry;
import org.glowroot.agent.shaded.io.grpc.ProxyDetector;
import org.glowroot.agent.shaded.io.grpc.internal.ClientTransportFactory;
import org.glowroot.agent.shaded.io.grpc.internal.ExponentialBackoffPolicy;
import org.glowroot.agent.shaded.io.grpc.internal.FixedObjectPool;
import org.glowroot.agent.shaded.io.grpc.internal.GrpcUtil;
import org.glowroot.agent.shaded.io.grpc.internal.ManagedChannelImpl;
import org.glowroot.agent.shaded.io.grpc.internal.ManagedChannelOrphanWrapper;
import org.glowroot.agent.shaded.io.grpc.internal.ObjectPool;
import org.glowroot.agent.shaded.io.grpc.internal.SharedResourcePool;
import org.glowroot.agent.shaded.io.grpc.internal.TimeProvider;

public final class ManagedChannelImplBuilder
extends ManagedChannelBuilder<ManagedChannelImplBuilder> {
    private static final Logger log = Logger.getLogger(ManagedChannelImplBuilder.class.getName());
    static final long IDLE_MODE_DEFAULT_TIMEOUT_MILLIS = TimeUnit.MINUTES.toMillis(30L);
    static final long IDLE_MODE_MIN_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(1L);
    private static final ObjectPool<? extends Executor> DEFAULT_EXECUTOR_POOL = SharedResourcePool.forResource(GrpcUtil.SHARED_CHANNEL_EXECUTOR);
    private static final DecompressorRegistry DEFAULT_DECOMPRESSOR_REGISTRY = DecompressorRegistry.getDefaultInstance();
    private static final CompressorRegistry DEFAULT_COMPRESSOR_REGISTRY = CompressorRegistry.getDefaultInstance();
    ObjectPool<? extends Executor> executorPool = DEFAULT_EXECUTOR_POOL;
    ObjectPool<? extends Executor> offloadExecutorPool = DEFAULT_EXECUTOR_POOL;
    private final List<ClientInterceptor> interceptors = new ArrayList<ClientInterceptor>();
    final NameResolverRegistry nameResolverRegistry = NameResolverRegistry.getDefaultRegistry();
    NameResolver.Factory nameResolverFactory = this.nameResolverRegistry.asFactory();
    final String target;
    @Nullable
    final ChannelCredentials channelCredentials;
    @Nullable
    final CallCredentials callCredentials;
    @Nullable
    private final SocketAddress directServerAddress;
    @Nullable
    String userAgent;
    @Nullable
    String authorityOverride;
    String defaultLbPolicy = "pick_first";
    boolean fullStreamDecompression;
    DecompressorRegistry decompressorRegistry = DEFAULT_DECOMPRESSOR_REGISTRY;
    CompressorRegistry compressorRegistry = DEFAULT_COMPRESSOR_REGISTRY;
    long idleTimeoutMillis = IDLE_MODE_DEFAULT_TIMEOUT_MILLIS;
    int maxRetryAttempts = 5;
    int maxHedgedAttempts = 5;
    long retryBufferSize = 0x1000000L;
    long perRpcBufferLimit = 0x100000L;
    boolean retryEnabled = true;
    InternalChannelz channelz = InternalChannelz.instance();
    int maxTraceEvents;
    @Nullable
    Map<String, ?> defaultServiceConfig;
    boolean lookUpServiceConfig = true;
    @Nullable
    BinaryLog binlog;
    @Nullable
    ProxyDetector proxyDetector;
    private boolean authorityCheckerDisabled;
    private boolean statsEnabled = true;
    private boolean recordStartedRpcs = true;
    private boolean recordFinishedRpcs = true;
    private boolean recordRealTimeMetrics = false;
    private boolean recordRetryMetrics = true;
    private boolean tracingEnabled = true;
    private final ClientTransportFactoryBuilder clientTransportFactoryBuilder;
    private final ChannelBuilderDefaultPortProvider channelBuilderDefaultPortProvider;

    public ManagedChannelImplBuilder(String target, ClientTransportFactoryBuilder clientTransportFactoryBuilder, @Nullable ChannelBuilderDefaultPortProvider channelBuilderDefaultPortProvider) {
        this(target, null, null, clientTransportFactoryBuilder, channelBuilderDefaultPortProvider);
    }

    public ManagedChannelImplBuilder(String target, @Nullable ChannelCredentials channelCreds, @Nullable CallCredentials callCreds, ClientTransportFactoryBuilder clientTransportFactoryBuilder, @Nullable ChannelBuilderDefaultPortProvider channelBuilderDefaultPortProvider) {
        this.target = Preconditions.checkNotNull(target, "target");
        this.channelCredentials = channelCreds;
        this.callCredentials = callCreds;
        this.clientTransportFactoryBuilder = Preconditions.checkNotNull(clientTransportFactoryBuilder, "clientTransportFactoryBuilder");
        this.directServerAddress = null;
        this.channelBuilderDefaultPortProvider = channelBuilderDefaultPortProvider != null ? channelBuilderDefaultPortProvider : new ManagedChannelDefaultPortProvider();
    }

    @Override
    public ManagedChannelImplBuilder executor(Executor executor) {
        this.executorPool = executor != null ? new FixedObjectPool<Executor>(executor) : DEFAULT_EXECUTOR_POOL;
        return this;
    }

    @Override
    @Deprecated
    public ManagedChannelImplBuilder nameResolverFactory(NameResolver.Factory resolverFactory) {
        Preconditions.checkState(this.directServerAddress == null, "directServerAddress is set (%s), which forbids the use of NameResolverFactory", this.directServerAddress);
        this.nameResolverFactory = resolverFactory != null ? resolverFactory : this.nameResolverRegistry.asFactory();
        return this;
    }

    @Override
    public ManagedChannelImplBuilder defaultLoadBalancingPolicy(String policy) {
        Preconditions.checkState(this.directServerAddress == null, "directServerAddress is set (%s), which forbids the use of load-balancing policy", this.directServerAddress);
        Preconditions.checkArgument(policy != null, "policy cannot be null");
        this.defaultLbPolicy = policy;
        return this;
    }

    @Override
    public ManagedChannelImplBuilder overrideAuthority(String authority) {
        this.authorityOverride = this.checkAuthority(authority);
        return this;
    }

    String checkAuthority(String authority) {
        if (this.authorityCheckerDisabled) {
            return authority;
        }
        return GrpcUtil.checkAuthority(authority);
    }

    @Override
    public ManagedChannel build() {
        return new ManagedChannelOrphanWrapper(new ManagedChannelImpl(this, this.clientTransportFactoryBuilder.buildClientTransportFactory(), new ExponentialBackoffPolicy.Provider(), SharedResourcePool.forResource(GrpcUtil.SHARED_CHANNEL_EXECUTOR), GrpcUtil.STOPWATCH_SUPPLIER, this.getEffectiveInterceptors(), TimeProvider.SYSTEM_TIME_PROVIDER));
    }

    List<ClientInterceptor> getEffectiveInterceptors() {
        ArrayList<ClientInterceptor> effectiveInterceptors = new ArrayList<ClientInterceptor>(this.interceptors);
        if (this.statsEnabled) {
            ClientInterceptor statsInterceptor = null;
            try {
                Class<?> censusStatsAccessor = Class.forName("org.glowroot.agent.shaded.io.grpc.census.InternalCensusStatsAccessor");
                Method getClientInterceptorMethod = censusStatsAccessor.getDeclaredMethod("getClientInterceptor", Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE);
                statsInterceptor = (ClientInterceptor)getClientInterceptorMethod.invoke(null, this.recordStartedRpcs, this.recordFinishedRpcs, this.recordRealTimeMetrics, this.recordRetryMetrics);
            }
            catch (ClassNotFoundException e) {
                log.log(Level.FINE, "Unable to apply census stats", e);
            }
            catch (NoSuchMethodException e) {
                log.log(Level.FINE, "Unable to apply census stats", e);
            }
            catch (IllegalAccessException e) {
                log.log(Level.FINE, "Unable to apply census stats", e);
            }
            catch (InvocationTargetException e) {
                log.log(Level.FINE, "Unable to apply census stats", e);
            }
            if (statsInterceptor != null) {
                effectiveInterceptors.add(0, statsInterceptor);
            }
        }
        if (this.tracingEnabled) {
            ClientInterceptor tracingInterceptor = null;
            try {
                Class<?> censusTracingAccessor = Class.forName("org.glowroot.agent.shaded.io.grpc.census.InternalCensusTracingAccessor");
                Method getClientInterceptroMethod = censusTracingAccessor.getDeclaredMethod("getClientInterceptor", new Class[0]);
                tracingInterceptor = (ClientInterceptor)getClientInterceptroMethod.invoke(null, new Object[0]);
            }
            catch (ClassNotFoundException e) {
                log.log(Level.FINE, "Unable to apply census stats", e);
            }
            catch (NoSuchMethodException e) {
                log.log(Level.FINE, "Unable to apply census stats", e);
            }
            catch (IllegalAccessException e) {
                log.log(Level.FINE, "Unable to apply census stats", e);
            }
            catch (InvocationTargetException e) {
                log.log(Level.FINE, "Unable to apply census stats", e);
            }
            if (tracingInterceptor != null) {
                effectiveInterceptors.add(0, tracingInterceptor);
            }
        }
        return effectiveInterceptors;
    }

    int getDefaultPort() {
        return this.channelBuilderDefaultPortProvider.getDefaultPort();
    }

    public ObjectPool<? extends Executor> getOffloadExecutorPool() {
        return this.offloadExecutorPool;
    }

    private static final class ManagedChannelDefaultPortProvider
    implements ChannelBuilderDefaultPortProvider {
        private ManagedChannelDefaultPortProvider() {
        }

        @Override
        public int getDefaultPort() {
            return 443;
        }
    }

    public static interface ChannelBuilderDefaultPortProvider {
        public int getDefaultPort();
    }

    public static interface ClientTransportFactoryBuilder {
        public ClientTransportFactory buildClientTransportFactory();
    }
}

