/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.io.netty.util.internal.shaded.org.jctools.queues;

import org.glowroot.agent.shaded.io.netty.util.internal.shaded.org.jctools.queues.MpscArrayQueueL3Pad;
import org.glowroot.agent.shaded.io.netty.util.internal.shaded.org.jctools.util.UnsafeRefArrayAccess;

public class MpscArrayQueue<E>
extends MpscArrayQueueL3Pad<E> {
    public MpscArrayQueue(int capacity) {
        super(capacity);
    }

    @Override
    public boolean offer(E e) {
        long pIndex;
        if (null == e) {
            throw new NullPointerException();
        }
        long mask = this.mask;
        long producerLimit = this.lvProducerLimit();
        do {
            if ((pIndex = this.lvProducerIndex()) < producerLimit) continue;
            long cIndex = this.lvConsumerIndex();
            producerLimit = cIndex + mask + 1L;
            if (pIndex >= producerLimit) {
                return false;
            }
            this.soProducerLimit(producerLimit);
        } while (!this.casProducerIndex(pIndex, pIndex + 1L));
        long offset = UnsafeRefArrayAccess.calcCircularRefElementOffset(pIndex, mask);
        UnsafeRefArrayAccess.soRefElement(this.buffer, offset, e);
        return true;
    }

    @Override
    public E poll() {
        Object[] buffer = this.buffer;
        long cIndex = this.lpConsumerIndex();
        long offset = UnsafeRefArrayAccess.calcCircularRefElementOffset(cIndex, this.mask);
        Object e = UnsafeRefArrayAccess.lvRefElement(buffer, offset);
        if (null == e) {
            if (cIndex != this.lvProducerIndex()) {
                while ((e = UnsafeRefArrayAccess.lvRefElement(buffer, offset)) == null) {
                }
            } else {
                return null;
            }
        }
        UnsafeRefArrayAccess.spRefElement(buffer, offset, null);
        this.soConsumerIndex(cIndex + 1L);
        return (E)e;
    }

    @Override
    public E peek() {
        Object[] buffer = this.buffer;
        long cIndex = this.lpConsumerIndex();
        long offset = UnsafeRefArrayAccess.calcCircularRefElementOffset(cIndex, this.mask);
        Object e = UnsafeRefArrayAccess.lvRefElement(buffer, offset);
        if (null == e) {
            if (cIndex != this.lvProducerIndex()) {
                while ((e = UnsafeRefArrayAccess.lvRefElement(buffer, offset)) == null) {
                }
            } else {
                return null;
            }
        }
        return (E)e;
    }
}

