/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.org.glowroot.common.config;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.glowroot.agent.shaded.org.glowroot.common.config.AlertConfig;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AlertConfig.SyntheticMonitorCondition", generator="Immutables")
@Immutable
final class ImmutableSyntheticMonitorCondition
implements AlertConfig.SyntheticMonitorCondition {
    private final String syntheticMonitorId;
    private final int thresholdMillis;
    private final int consecutiveCount;

    private ImmutableSyntheticMonitorCondition(String syntheticMonitorId, int thresholdMillis, int consecutiveCount) {
        this.syntheticMonitorId = syntheticMonitorId;
        this.thresholdMillis = thresholdMillis;
        this.consecutiveCount = consecutiveCount;
    }

    @Override
    @JsonProperty(value="syntheticMonitorId")
    public String syntheticMonitorId() {
        return this.syntheticMonitorId;
    }

    @Override
    @JsonProperty(value="thresholdMillis")
    public int thresholdMillis() {
        return this.thresholdMillis;
    }

    @Override
    @JsonProperty(value="consecutiveCount")
    public int consecutiveCount() {
        return this.consecutiveCount;
    }

    public final ImmutableSyntheticMonitorCondition withSyntheticMonitorId(String value) {
        String newValue = Objects.requireNonNull(value, "syntheticMonitorId");
        if (this.syntheticMonitorId.equals(newValue)) {
            return this;
        }
        return new ImmutableSyntheticMonitorCondition(newValue, this.thresholdMillis, this.consecutiveCount);
    }

    public final ImmutableSyntheticMonitorCondition withThresholdMillis(int value) {
        if (this.thresholdMillis == value) {
            return this;
        }
        return new ImmutableSyntheticMonitorCondition(this.syntheticMonitorId, value, this.consecutiveCount);
    }

    public final ImmutableSyntheticMonitorCondition withConsecutiveCount(int value) {
        if (this.consecutiveCount == value) {
            return this;
        }
        return new ImmutableSyntheticMonitorCondition(this.syntheticMonitorId, this.thresholdMillis, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSyntheticMonitorCondition && this.equalTo((ImmutableSyntheticMonitorCondition)another);
    }

    private boolean equalTo(ImmutableSyntheticMonitorCondition another) {
        return this.syntheticMonitorId.equals(another.syntheticMonitorId) && this.thresholdMillis == another.thresholdMillis && this.consecutiveCount == another.consecutiveCount;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.syntheticMonitorId.hashCode();
        h += (h << 5) + this.thresholdMillis;
        h += (h << 5) + this.consecutiveCount;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("SyntheticMonitorCondition").omitNullValues().add("syntheticMonitorId", this.syntheticMonitorId).add("thresholdMillis", this.thresholdMillis).add("consecutiveCount", this.consecutiveCount).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableSyntheticMonitorCondition fromJson(Json json) {
        Builder builder = ImmutableSyntheticMonitorCondition.builder();
        if (json.syntheticMonitorId != null) {
            builder.syntheticMonitorId(json.syntheticMonitorId);
        }
        if (json.thresholdMillisIsSet) {
            builder.thresholdMillis(json.thresholdMillis);
        }
        if (json.consecutiveCountIsSet) {
            builder.consecutiveCount(json.consecutiveCount);
        }
        return builder.build();
    }

    public static ImmutableSyntheticMonitorCondition copyOf(AlertConfig.SyntheticMonitorCondition instance) {
        if (instance instanceof ImmutableSyntheticMonitorCondition) {
            return (ImmutableSyntheticMonitorCondition)instance;
        }
        return ImmutableSyntheticMonitorCondition.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AlertConfig.SyntheticMonitorCondition", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SYNTHETIC_MONITOR_ID = 1L;
        private static final long INIT_BIT_THRESHOLD_MILLIS = 2L;
        private static final long INIT_BIT_CONSECUTIVE_COUNT = 4L;
        private long initBits = 7L;
        @Nullable
        private String syntheticMonitorId;
        private int thresholdMillis;
        private int consecutiveCount;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(AlertConfig.SyntheticMonitorCondition instance) {
            Objects.requireNonNull(instance, "instance");
            this.syntheticMonitorId(instance.syntheticMonitorId());
            this.thresholdMillis(instance.thresholdMillis());
            this.consecutiveCount(instance.consecutiveCount());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder syntheticMonitorId(String syntheticMonitorId) {
            this.syntheticMonitorId = Objects.requireNonNull(syntheticMonitorId, "syntheticMonitorId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder thresholdMillis(int thresholdMillis) {
            this.thresholdMillis = thresholdMillis;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder consecutiveCount(int consecutiveCount) {
            this.consecutiveCount = consecutiveCount;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableSyntheticMonitorCondition build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSyntheticMonitorCondition(this.syntheticMonitorId, this.thresholdMillis, this.consecutiveCount);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("syntheticMonitorId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("thresholdMillis");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("consecutiveCount");
            }
            return "Cannot build SyntheticMonitorCondition, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AlertConfig.SyntheticMonitorCondition", generator="Immutables")
    static final class Json
    implements AlertConfig.SyntheticMonitorCondition {
        @Nullable
        String syntheticMonitorId;
        int thresholdMillis;
        boolean thresholdMillisIsSet;
        int consecutiveCount;
        boolean consecutiveCountIsSet;

        Json() {
        }

        @JsonProperty(value="syntheticMonitorId")
        public void setSyntheticMonitorId(String syntheticMonitorId) {
            this.syntheticMonitorId = syntheticMonitorId;
        }

        @JsonProperty(value="thresholdMillis")
        public void setThresholdMillis(int thresholdMillis) {
            this.thresholdMillis = thresholdMillis;
            this.thresholdMillisIsSet = true;
        }

        @JsonProperty(value="consecutiveCount")
        public void setConsecutiveCount(int consecutiveCount) {
            this.consecutiveCount = consecutiveCount;
            this.consecutiveCountIsSet = true;
        }

        @Override
        public String syntheticMonitorId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int thresholdMillis() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int consecutiveCount() {
            throw new UnsupportedOperationException();
        }
    }
}

