/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.org.glowroot.common.config;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.primitives.Doubles;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.glowroot.agent.shaded.org.glowroot.common.config.UiDefaultsConfig;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="UiDefaultsConfig", generator="Immutables")
@Immutable
public final class ImmutableUiDefaultsConfig
extends UiDefaultsConfig {
    private final String defaultTransactionType;
    private final ImmutableList<Double> defaultPercentiles;
    private final ImmutableList<String> defaultGaugeNames;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableUiDefaultsConfig(Builder builder) {
        if (builder.defaultTransactionType != null) {
            this.initShim.defaultTransactionType(builder.defaultTransactionType);
        }
        if (builder.defaultPercentilesIsSet()) {
            this.initShim.defaultPercentiles((ImmutableList<Double>)builder.defaultPercentiles.build());
        }
        if (builder.defaultGaugeNamesIsSet()) {
            this.initShim.defaultGaugeNames((ImmutableList<String>)builder.defaultGaugeNames.build());
        }
        this.defaultTransactionType = this.initShim.defaultTransactionType();
        this.defaultPercentiles = this.initShim.defaultPercentiles();
        this.defaultGaugeNames = this.initShim.defaultGaugeNames();
        this.initShim = null;
    }

    private ImmutableUiDefaultsConfig(String defaultTransactionType, ImmutableList<Double> defaultPercentiles, ImmutableList<String> defaultGaugeNames) {
        this.defaultTransactionType = defaultTransactionType;
        this.defaultPercentiles = defaultPercentiles;
        this.defaultGaugeNames = defaultGaugeNames;
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="defaultTransactionType")
    public String defaultTransactionType() {
        InitShim shim = this.initShim;
        return shim != null ? shim.defaultTransactionType() : this.defaultTransactionType;
    }

    @Override
    @JsonProperty(value="defaultPercentiles")
    public ImmutableList<Double> defaultPercentiles() {
        InitShim shim = this.initShim;
        return shim != null ? shim.defaultPercentiles() : this.defaultPercentiles;
    }

    @Override
    @JsonProperty(value="defaultGaugeNames")
    public ImmutableList<String> defaultGaugeNames() {
        InitShim shim = this.initShim;
        return shim != null ? shim.defaultGaugeNames() : this.defaultGaugeNames;
    }

    public final ImmutableUiDefaultsConfig withDefaultTransactionType(String value) {
        String newValue = Objects.requireNonNull(value, "defaultTransactionType");
        if (this.defaultTransactionType.equals(newValue)) {
            return this;
        }
        return new ImmutableUiDefaultsConfig(newValue, this.defaultPercentiles, this.defaultGaugeNames);
    }

    public final ImmutableUiDefaultsConfig withDefaultPercentiles(double ... elements) {
        ImmutableList<Double> newValue = ImmutableList.copyOf(Doubles.asList(elements));
        return new ImmutableUiDefaultsConfig(this.defaultTransactionType, newValue, this.defaultGaugeNames);
    }

    public final ImmutableUiDefaultsConfig withDefaultPercentiles(Iterable<Double> elements) {
        if (this.defaultPercentiles == elements) {
            return this;
        }
        ImmutableList<Double> newValue = ImmutableList.copyOf(elements);
        return new ImmutableUiDefaultsConfig(this.defaultTransactionType, newValue, this.defaultGaugeNames);
    }

    public final ImmutableUiDefaultsConfig withDefaultGaugeNames(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableUiDefaultsConfig(this.defaultTransactionType, this.defaultPercentiles, newValue);
    }

    public final ImmutableUiDefaultsConfig withDefaultGaugeNames(Iterable<String> elements) {
        if (this.defaultGaugeNames == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableUiDefaultsConfig(this.defaultTransactionType, this.defaultPercentiles, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUiDefaultsConfig && this.equalTo((ImmutableUiDefaultsConfig)another);
    }

    private boolean equalTo(ImmutableUiDefaultsConfig another) {
        return this.defaultTransactionType.equals(another.defaultTransactionType) && this.defaultPercentiles.equals(another.defaultPercentiles) && this.defaultGaugeNames.equals(another.defaultGaugeNames);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.defaultTransactionType.hashCode();
        h += (h << 5) + this.defaultPercentiles.hashCode();
        h += (h << 5) + this.defaultGaugeNames.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("UiDefaultsConfig").omitNullValues().add("defaultTransactionType", this.defaultTransactionType).add("defaultPercentiles", this.defaultPercentiles).add("defaultGaugeNames", this.defaultGaugeNames).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableUiDefaultsConfig fromJson(Json json) {
        Builder builder = ImmutableUiDefaultsConfig.builder();
        if (json.defaultTransactionType != null) {
            builder.defaultTransactionType(json.defaultTransactionType);
        }
        if (json.defaultPercentilesIsSet) {
            builder.addAllDefaultPercentiles(json.defaultPercentiles);
        }
        if (json.defaultGaugeNamesIsSet) {
            builder.addAllDefaultGaugeNames(json.defaultGaugeNames);
        }
        return builder.build();
    }

    public static ImmutableUiDefaultsConfig copyOf(UiDefaultsConfig instance) {
        if (instance instanceof ImmutableUiDefaultsConfig) {
            return (ImmutableUiDefaultsConfig)instance;
        }
        return ImmutableUiDefaultsConfig.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="UiDefaultsConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_DEFAULT_PERCENTILES = 1L;
        private static final long OPT_BIT_DEFAULT_GAUGE_NAMES = 2L;
        private long optBits;
        @Nullable
        private String defaultTransactionType;
        private ImmutableList.Builder<Double> defaultPercentiles = ImmutableList.builder();
        private ImmutableList.Builder<String> defaultGaugeNames = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(UiDefaultsConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.defaultTransactionType(instance.defaultTransactionType());
            this.addAllDefaultPercentiles(instance.defaultPercentiles());
            this.addAllDefaultGaugeNames(instance.defaultGaugeNames());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder defaultTransactionType(String defaultTransactionType) {
            this.defaultTransactionType = Objects.requireNonNull(defaultTransactionType, "defaultTransactionType");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addDefaultPercentiles(double element) {
            this.defaultPercentiles.add((Object)element);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addDefaultPercentiles(double ... elements) {
            this.defaultPercentiles.addAll(Doubles.asList(elements));
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder defaultPercentiles(Iterable<Double> elements) {
            this.defaultPercentiles = ImmutableList.builder();
            return this.addAllDefaultPercentiles(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllDefaultPercentiles(Iterable<Double> elements) {
            this.defaultPercentiles.addAll((Iterable)elements);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addDefaultGaugeNames(String element) {
            this.defaultGaugeNames.add((Object)element);
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addDefaultGaugeNames(String ... elements) {
            this.defaultGaugeNames.add(elements);
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder defaultGaugeNames(Iterable<String> elements) {
            this.defaultGaugeNames = ImmutableList.builder();
            return this.addAllDefaultGaugeNames(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllDefaultGaugeNames(Iterable<String> elements) {
            this.defaultGaugeNames.addAll((Iterable)elements);
            this.optBits |= 2L;
            return this;
        }

        public ImmutableUiDefaultsConfig build() {
            return new ImmutableUiDefaultsConfig(this);
        }

        private boolean defaultPercentilesIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean defaultGaugeNamesIsSet() {
            return (this.optBits & 2L) != 0L;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="UiDefaultsConfig", generator="Immutables")
    static final class Json
    extends UiDefaultsConfig {
        @Nullable
        String defaultTransactionType;
        @Nullable
        ImmutableList<Double> defaultPercentiles = ImmutableList.of();
        boolean defaultPercentilesIsSet;
        @Nullable
        ImmutableList<String> defaultGaugeNames = ImmutableList.of();
        boolean defaultGaugeNamesIsSet;

        Json() {
        }

        @JsonProperty(value="defaultTransactionType")
        public void setDefaultTransactionType(String defaultTransactionType) {
            this.defaultTransactionType = defaultTransactionType;
        }

        @JsonProperty(value="defaultPercentiles")
        public void setDefaultPercentiles(ImmutableList<Double> defaultPercentiles) {
            this.defaultPercentiles = defaultPercentiles;
            this.defaultPercentilesIsSet = true;
        }

        @JsonProperty(value="defaultGaugeNames")
        public void setDefaultGaugeNames(ImmutableList<String> defaultGaugeNames) {
            this.defaultGaugeNames = defaultGaugeNames;
            this.defaultGaugeNamesIsSet = true;
        }

        @Override
        public String defaultTransactionType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ImmutableList<Double> defaultPercentiles() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ImmutableList<String> defaultGaugeNames() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="UiDefaultsConfig", generator="Immutables")
    private final class InitShim {
        private byte defaultTransactionTypeBuildStage = 0;
        private String defaultTransactionType;
        private byte defaultPercentilesBuildStage = 0;
        private ImmutableList<Double> defaultPercentiles;
        private byte defaultGaugeNamesBuildStage = 0;
        private ImmutableList<String> defaultGaugeNames;

        private InitShim() {
        }

        String defaultTransactionType() {
            if (this.defaultTransactionTypeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.defaultTransactionTypeBuildStage == 0) {
                this.defaultTransactionTypeBuildStage = (byte)-1;
                this.defaultTransactionType = Objects.requireNonNull(ImmutableUiDefaultsConfig.super.defaultTransactionType(), "defaultTransactionType");
                this.defaultTransactionTypeBuildStage = 1;
            }
            return this.defaultTransactionType;
        }

        void defaultTransactionType(String defaultTransactionType) {
            this.defaultTransactionType = defaultTransactionType;
            this.defaultTransactionTypeBuildStage = 1;
        }

        ImmutableList<Double> defaultPercentiles() {
            if (this.defaultPercentilesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.defaultPercentilesBuildStage == 0) {
                this.defaultPercentilesBuildStage = (byte)-1;
                this.defaultPercentiles = Objects.requireNonNull(ImmutableUiDefaultsConfig.super.defaultPercentiles(), "defaultPercentiles");
                this.defaultPercentilesBuildStage = 1;
            }
            return this.defaultPercentiles;
        }

        void defaultPercentiles(ImmutableList<Double> defaultPercentiles) {
            this.defaultPercentiles = defaultPercentiles;
            this.defaultPercentilesBuildStage = 1;
        }

        ImmutableList<String> defaultGaugeNames() {
            if (this.defaultGaugeNamesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.defaultGaugeNamesBuildStage == 0) {
                this.defaultGaugeNamesBuildStage = (byte)-1;
                this.defaultGaugeNames = Objects.requireNonNull(ImmutableUiDefaultsConfig.super.defaultGaugeNames(), "defaultGaugeNames");
                this.defaultGaugeNamesBuildStage = 1;
            }
            return this.defaultGaugeNames;
        }

        void defaultGaugeNames(ImmutableList<String> defaultGaugeNames) {
            this.defaultGaugeNames = defaultGaugeNames;
            this.defaultGaugeNamesBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.defaultTransactionTypeBuildStage == -1) {
                attributes.add("defaultTransactionType");
            }
            if (this.defaultPercentilesBuildStage == -1) {
                attributes.add("defaultPercentiles");
            }
            if (this.defaultGaugeNamesBuildStage == -1) {
                attributes.add("defaultGaugeNames");
            }
            return "Cannot build UiDefaultsConfig, attribute initializers form cycle " + attributes;
        }
    }
}

