/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.org.glowroot.common.config;

import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.org.glowroot.common.config.ImmutableSlowThresholdOverride;
import org.glowroot.agent.shaded.org.glowroot.common.config.ImmutableTransactionConfig;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.AgentConfigOuterClass;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.Proto;
import org.immutables.value.Value;

@Value.Immutable
public abstract class TransactionConfig {
    @Value.Default
    public int slowThresholdMillis() {
        return 2000;
    }

    @Value.Default
    public int profilingIntervalMillis() {
        return 1000;
    }

    @Value.Default
    public boolean captureThreadStats() {
        return true;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public abstract ImmutableList<ImmutableSlowThresholdOverride> slowThresholdOverrides();

    public AgentConfigOuterClass.AgentConfig.TransactionConfig toProto() {
        AgentConfigOuterClass.AgentConfig.TransactionConfig.Builder builder = AgentConfigOuterClass.AgentConfig.TransactionConfig.newBuilder().setSlowThresholdMillis(TransactionConfig.of(this.slowThresholdMillis())).setProfilingIntervalMillis(TransactionConfig.of(this.profilingIntervalMillis())).setCaptureThreadStats(this.captureThreadStats());
        for (SlowThresholdOverride slowThresholdOverride : this.slowThresholdOverrides()) {
            builder.addSlowThresholdOverride(AgentConfigOuterClass.AgentConfig.SlowThresholdOverride.newBuilder().setTransactionType(slowThresholdOverride.transactionType()).setTransactionName(slowThresholdOverride.transactionName()).setUser(slowThresholdOverride.user()).setThresholdMillis(slowThresholdOverride.thresholdMillis()).build());
        }
        return builder.build();
    }

    public static ImmutableTransactionConfig create(AgentConfigOuterClass.AgentConfig.TransactionConfig config) {
        ImmutableTransactionConfig.Builder builder = ImmutableTransactionConfig.builder();
        if (config.hasSlowThresholdMillis()) {
            builder.slowThresholdMillis(config.getSlowThresholdMillis().getValue());
        }
        if (config.hasProfilingIntervalMillis()) {
            builder.profilingIntervalMillis(config.getProfilingIntervalMillis().getValue());
        }
        builder.captureThreadStats(config.getCaptureThreadStats());
        for (AgentConfigOuterClass.AgentConfig.SlowThresholdOverride slowThresholdOverride : config.getSlowThresholdOverrideList()) {
            builder.addSlowThresholdOverrides(ImmutableSlowThresholdOverride.builder().transactionType(slowThresholdOverride.getTransactionType()).transactionName(slowThresholdOverride.getTransactionName()).user(slowThresholdOverride.getUser()).thresholdMillis(slowThresholdOverride.getThresholdMillis()).build());
        }
        return builder.build();
    }

    private static Proto.OptionalInt32 of(int value) {
        return Proto.OptionalInt32.newBuilder().setValue(value).build();
    }

    @Value.Immutable
    public static abstract class SlowThresholdOverride {
        public abstract String transactionType();

        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @Value.Default
        public String transactionName() {
            return "";
        }

        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @Value.Default
        public String user() {
            return "";
        }

        public abstract int thresholdMillis();
    }
}

