/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.org.glowroot.common.model;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.primitives.Doubles;
import org.glowroot.agent.shaded.com.google.common.primitives.Longs;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.glowroot.agent.shaded.org.glowroot.common.model.OverallSummaryCollector;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="OverallSummaryCollector.OverallSummary", generator="Immutables")
@Immutable
public final class ImmutableOverallSummary
implements OverallSummaryCollector.OverallSummary {
    private final double totalDurationNanos;
    private final double totalCpuNanos;
    private final double totalAllocatedBytes;
    private final long transactionCount;

    private ImmutableOverallSummary(double totalDurationNanos, double totalCpuNanos, double totalAllocatedBytes, long transactionCount) {
        this.totalDurationNanos = totalDurationNanos;
        this.totalCpuNanos = totalCpuNanos;
        this.totalAllocatedBytes = totalAllocatedBytes;
        this.transactionCount = transactionCount;
    }

    @Override
    @JsonProperty(value="totalDurationNanos")
    public double totalDurationNanos() {
        return this.totalDurationNanos;
    }

    @Override
    @JsonProperty(value="totalCpuNanos")
    public double totalCpuNanos() {
        return this.totalCpuNanos;
    }

    @Override
    @JsonProperty(value="totalAllocatedBytes")
    public double totalAllocatedBytes() {
        return this.totalAllocatedBytes;
    }

    @Override
    @JsonProperty(value="transactionCount")
    public long transactionCount() {
        return this.transactionCount;
    }

    public final ImmutableOverallSummary withTotalDurationNanos(double value) {
        if (Double.doubleToLongBits(this.totalDurationNanos) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableOverallSummary(value, this.totalCpuNanos, this.totalAllocatedBytes, this.transactionCount);
    }

    public final ImmutableOverallSummary withTotalCpuNanos(double value) {
        if (Double.doubleToLongBits(this.totalCpuNanos) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableOverallSummary(this.totalDurationNanos, value, this.totalAllocatedBytes, this.transactionCount);
    }

    public final ImmutableOverallSummary withTotalAllocatedBytes(double value) {
        if (Double.doubleToLongBits(this.totalAllocatedBytes) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableOverallSummary(this.totalDurationNanos, this.totalCpuNanos, value, this.transactionCount);
    }

    public final ImmutableOverallSummary withTransactionCount(long value) {
        if (this.transactionCount == value) {
            return this;
        }
        return new ImmutableOverallSummary(this.totalDurationNanos, this.totalCpuNanos, this.totalAllocatedBytes, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableOverallSummary && this.equalTo((ImmutableOverallSummary)another);
    }

    private boolean equalTo(ImmutableOverallSummary another) {
        return Double.doubleToLongBits(this.totalDurationNanos) == Double.doubleToLongBits(another.totalDurationNanos) && Double.doubleToLongBits(this.totalCpuNanos) == Double.doubleToLongBits(another.totalCpuNanos) && Double.doubleToLongBits(this.totalAllocatedBytes) == Double.doubleToLongBits(another.totalAllocatedBytes) && this.transactionCount == another.transactionCount;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Doubles.hashCode(this.totalDurationNanos);
        h += (h << 5) + Doubles.hashCode(this.totalCpuNanos);
        h += (h << 5) + Doubles.hashCode(this.totalAllocatedBytes);
        h += (h << 5) + Longs.hashCode(this.transactionCount);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("OverallSummary").omitNullValues().add("totalDurationNanos", this.totalDurationNanos).add("totalCpuNanos", this.totalCpuNanos).add("totalAllocatedBytes", this.totalAllocatedBytes).add("transactionCount", this.transactionCount).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableOverallSummary fromJson(Json json) {
        Builder builder = ImmutableOverallSummary.builder();
        if (json.totalDurationNanosIsSet) {
            builder.totalDurationNanos(json.totalDurationNanos);
        }
        if (json.totalCpuNanosIsSet) {
            builder.totalCpuNanos(json.totalCpuNanos);
        }
        if (json.totalAllocatedBytesIsSet) {
            builder.totalAllocatedBytes(json.totalAllocatedBytes);
        }
        if (json.transactionCountIsSet) {
            builder.transactionCount(json.transactionCount);
        }
        return builder.build();
    }

    public static ImmutableOverallSummary copyOf(OverallSummaryCollector.OverallSummary instance) {
        if (instance instanceof ImmutableOverallSummary) {
            return (ImmutableOverallSummary)instance;
        }
        return ImmutableOverallSummary.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="OverallSummaryCollector.OverallSummary", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TOTAL_DURATION_NANOS = 1L;
        private static final long INIT_BIT_TOTAL_CPU_NANOS = 2L;
        private static final long INIT_BIT_TOTAL_ALLOCATED_BYTES = 4L;
        private static final long INIT_BIT_TRANSACTION_COUNT = 8L;
        private long initBits = 15L;
        private double totalDurationNanos;
        private double totalCpuNanos;
        private double totalAllocatedBytes;
        private long transactionCount;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(OverallSummaryCollector.OverallSummary instance) {
            Objects.requireNonNull(instance, "instance");
            this.totalDurationNanos(instance.totalDurationNanos());
            this.totalCpuNanos(instance.totalCpuNanos());
            this.totalAllocatedBytes(instance.totalAllocatedBytes());
            this.transactionCount(instance.transactionCount());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder totalDurationNanos(double totalDurationNanos) {
            this.totalDurationNanos = totalDurationNanos;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder totalCpuNanos(double totalCpuNanos) {
            this.totalCpuNanos = totalCpuNanos;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder totalAllocatedBytes(double totalAllocatedBytes) {
            this.totalAllocatedBytes = totalAllocatedBytes;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder transactionCount(long transactionCount) {
            this.transactionCount = transactionCount;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableOverallSummary build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableOverallSummary(this.totalDurationNanos, this.totalCpuNanos, this.totalAllocatedBytes, this.transactionCount);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("totalDurationNanos");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("totalCpuNanos");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("totalAllocatedBytes");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("transactionCount");
            }
            return "Cannot build OverallSummary, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="OverallSummaryCollector.OverallSummary", generator="Immutables")
    static final class Json
    implements OverallSummaryCollector.OverallSummary {
        double totalDurationNanos;
        boolean totalDurationNanosIsSet;
        double totalCpuNanos;
        boolean totalCpuNanosIsSet;
        double totalAllocatedBytes;
        boolean totalAllocatedBytesIsSet;
        long transactionCount;
        boolean transactionCountIsSet;

        Json() {
        }

        @JsonProperty(value="totalDurationNanos")
        public void setTotalDurationNanos(double totalDurationNanos) {
            this.totalDurationNanos = totalDurationNanos;
            this.totalDurationNanosIsSet = true;
        }

        @JsonProperty(value="totalCpuNanos")
        public void setTotalCpuNanos(double totalCpuNanos) {
            this.totalCpuNanos = totalCpuNanos;
            this.totalCpuNanosIsSet = true;
        }

        @JsonProperty(value="totalAllocatedBytes")
        public void setTotalAllocatedBytes(double totalAllocatedBytes) {
            this.totalAllocatedBytes = totalAllocatedBytes;
            this.totalAllocatedBytesIsSet = true;
        }

        @JsonProperty(value="transactionCount")
        public void setTransactionCount(long transactionCount) {
            this.transactionCount = transactionCount;
            this.transactionCountIsSet = true;
        }

        @Override
        public double totalDurationNanos() {
            throw new UnsupportedOperationException();
        }

        @Override
        public double totalCpuNanos() {
            throw new UnsupportedOperationException();
        }

        @Override
        public double totalAllocatedBytes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long transactionCount() {
            throw new UnsupportedOperationException();
        }
    }
}

