/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;

public class IterableWithSelfRemovableEntries<E>
implements Iterable<E> {
    private final ReferenceQueue<E> queue = new ReferenceQueue();
    private final Entry headEntry;
    private Entry tailEntry = this.headEntry = new Entry(null, this.queue);
    private final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SelfRemovableEntry add(E e) {
        Entry newTailEntry = new Entry(e, this.queue);
        Object object = this.lock;
        synchronized (object) {
            this.expungeStaleEntries();
            this.tailEntry.nextEntry = newTailEntry;
            newTailEntry.prevEntry = this.tailEntry;
            this.tailEntry = newTailEntry;
        }
        return newTailEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<E> iterator() {
        Object object = this.lock;
        synchronized (object) {
            this.expungeStaleEntries();
        }
        return new ElementIterator();
    }

    private void expungeStaleEntries() {
        Reference<E> ref = this.queue.poll();
        if (ref == null) {
            return;
        }
        while (this.queue.poll() != null) {
        }
        Entry currEntry = this.headEntry.nextEntry;
        while (currEntry != null) {
            if (currEntry.getElement() == null) {
                currEntry.remove();
            }
            currEntry = currEntry.nextEntry;
        }
    }

    private class Entry
    implements SelfRemovableEntry {
        private final @Nullable WeakReference<E> ref;
        private @Nullable Entry prevEntry;
        private volatile @Nullable Entry nextEntry;

        private Entry(E e, ReferenceQueue<E> queue) {
            this.ref = e == null ? null : new WeakReference(e, queue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            Object object = IterableWithSelfRemovableEntries.this.lock;
            synchronized (object) {
                if (this.prevEntry == null) {
                    return;
                }
                Entry localPrevEntry = Preconditions.checkNotNull(this.prevEntry);
                localPrevEntry.nextEntry = this.nextEntry;
                if (this.nextEntry != null) {
                    this.nextEntry.prevEntry = localPrevEntry;
                }
                if (this == IterableWithSelfRemovableEntries.this.tailEntry) {
                    IterableWithSelfRemovableEntries.this.tailEntry = localPrevEntry;
                }
                this.prevEntry = null;
            }
        }

        private @Nullable E getElement() {
            if (this.ref == null) {
                return null;
            }
            return this.ref.get();
        }
    }

    private class ElementIterator
    implements Iterator<E> {
        private @Nullable Entry nextEntry;
        private @Nullable E nextElement;

        private ElementIterator() {
            this.nextEntry = IterableWithSelfRemovableEntries.this.headEntry;
            this.advance();
        }

        @Override
        public boolean hasNext() {
            return this.nextElement != null;
        }

        @Override
        public E next() {
            Object currElement = this.nextElement;
            if (currElement == null) {
                throw new NoSuchElementException();
            }
            this.advance();
            return currElement;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void advance() {
            this.advanceOne();
            while (this.nextElement == null && this.nextEntry != null) {
                this.advanceOne();
            }
        }

        private void advanceOne() {
            Preconditions.checkNotNull(this.nextEntry);
            this.nextEntry = this.nextEntry.nextEntry;
            this.nextElement = this.nextEntry == null ? null : this.nextEntry.getElement();
        }
    }

    public static interface SelfRemovableEntry {
        public void remove();
    }
}

