/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.weaving;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.glowroot.agent.shaded.org.objectweb.asm.Type;
import org.glowroot.agent.weaving.ClassLoaders;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ClassLoaders.LazyDefinedClass", generator="Immutables")
@Immutable
public final class ImmutableLazyDefinedClass
implements ClassLoaders.LazyDefinedClass {
    private final Type type;
    private final byte[] bytes;
    private final ImmutableList<ClassLoaders.LazyDefinedClass> dependencies;

    private ImmutableLazyDefinedClass(Type type, byte[] bytes, ImmutableList<ClassLoaders.LazyDefinedClass> dependencies) {
        this.type = type;
        this.bytes = bytes;
        this.dependencies = dependencies;
    }

    @Override
    @JsonProperty(value="type")
    public Type type() {
        return this.type;
    }

    @Override
    @JsonProperty(value="bytes")
    public byte[] bytes() {
        return (byte[])this.bytes.clone();
    }

    @Override
    @JsonProperty(value="dependencies")
    public ImmutableList<ClassLoaders.LazyDefinedClass> dependencies() {
        return this.dependencies;
    }

    public final ImmutableLazyDefinedClass withType(Type value) {
        if (this.type == value) {
            return this;
        }
        Type newValue = Objects.requireNonNull(value, "type");
        return new ImmutableLazyDefinedClass(newValue, this.bytes, this.dependencies);
    }

    public final ImmutableLazyDefinedClass withBytes(byte ... elements) {
        byte[] newValue = (byte[])elements.clone();
        return new ImmutableLazyDefinedClass(this.type, newValue, this.dependencies);
    }

    public final ImmutableLazyDefinedClass withDependencies(ClassLoaders.LazyDefinedClass ... elements) {
        ImmutableList<ClassLoaders.LazyDefinedClass> newValue = ImmutableList.copyOf(elements);
        return new ImmutableLazyDefinedClass(this.type, this.bytes, newValue);
    }

    public final ImmutableLazyDefinedClass withDependencies(Iterable<? extends ClassLoaders.LazyDefinedClass> elements) {
        if (this.dependencies == elements) {
            return this;
        }
        ImmutableList<ClassLoaders.LazyDefinedClass> newValue = ImmutableList.copyOf(elements);
        return new ImmutableLazyDefinedClass(this.type, this.bytes, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLazyDefinedClass && this.equalTo((ImmutableLazyDefinedClass)another);
    }

    private boolean equalTo(ImmutableLazyDefinedClass another) {
        return this.type.equals(another.type) && Arrays.equals(this.bytes, another.bytes) && this.dependencies.equals(another.dependencies);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + Arrays.hashCode(this.bytes);
        h += (h << 5) + this.dependencies.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("LazyDefinedClass").omitNullValues().add("type", this.type).add("bytes", Arrays.toString(this.bytes)).add("dependencies", this.dependencies).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableLazyDefinedClass fromJson(Json json) {
        Builder builder = ImmutableLazyDefinedClass.builder();
        if (json.type != null) {
            builder.type(json.type);
        }
        if (json.bytes != null) {
            builder.bytes(json.bytes);
        }
        if (json.dependencies != null) {
            builder.addAllDependencies(json.dependencies);
        }
        return builder.build();
    }

    public static ImmutableLazyDefinedClass copyOf(ClassLoaders.LazyDefinedClass instance) {
        if (instance instanceof ImmutableLazyDefinedClass) {
            return (ImmutableLazyDefinedClass)instance;
        }
        return ImmutableLazyDefinedClass.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ClassLoaders.LazyDefinedClass", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_BYTES = 2L;
        private long initBits = 3L;
        @Nullable
        private Type type;
        @Nullable
        private byte[] bytes;
        private ImmutableList.Builder<ClassLoaders.LazyDefinedClass> dependencies = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(ClassLoaders.LazyDefinedClass instance) {
            Objects.requireNonNull(instance, "instance");
            this.type(instance.type());
            this.bytes(instance.bytes());
            this.addAllDependencies(instance.dependencies());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder type(Type type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder bytes(byte ... bytes) {
            this.bytes = (byte[])bytes.clone();
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addDependencies(ClassLoaders.LazyDefinedClass element) {
            this.dependencies.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addDependencies(ClassLoaders.LazyDefinedClass ... elements) {
            this.dependencies.add(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder dependencies(Iterable<? extends ClassLoaders.LazyDefinedClass> elements) {
            this.dependencies = ImmutableList.builder();
            return this.addAllDependencies(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllDependencies(Iterable<? extends ClassLoaders.LazyDefinedClass> elements) {
            this.dependencies.addAll(elements);
            return this;
        }

        public ImmutableLazyDefinedClass build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableLazyDefinedClass(this.type, this.bytes, (ImmutableList)this.dependencies.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("bytes");
            }
            return "Cannot build LazyDefinedClass, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ClassLoaders.LazyDefinedClass", generator="Immutables")
    static final class Json
    implements ClassLoaders.LazyDefinedClass {
        @Nullable
        Type type;
        @Nullable
        byte[] bytes;
        @Nullable
        ImmutableList<ClassLoaders.LazyDefinedClass> dependencies = ImmutableList.of();

        Json() {
        }

        @JsonProperty(value="type")
        public void setType(Type type) {
            this.type = type;
        }

        @JsonProperty(value="bytes")
        public void setBytes(byte[] bytes) {
            this.bytes = bytes;
        }

        @JsonProperty(value="dependencies")
        public void setDependencies(ImmutableList<ClassLoaders.LazyDefinedClass> dependencies) {
            this.dependencies = dependencies;
        }

        @Override
        public Type type() {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte[] bytes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ImmutableList<ClassLoaders.LazyDefinedClass> dependencies() {
            throw new UnsupportedOperationException();
        }
    }
}

