/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.weaving;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.checkerframework.checker.nullness.qual.PolyNull;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.com.google.common.collect.Sets;
import org.glowroot.agent.shaded.org.objectweb.asm.ClassReader;
import org.glowroot.agent.shaded.org.objectweb.asm.ClassWriter;
import org.glowroot.agent.shaded.org.objectweb.asm.Type;
import org.glowroot.agent.shaded.org.objectweb.asm.commons.ClassRemapper;
import org.glowroot.agent.shaded.org.objectweb.asm.commons.Method;
import org.glowroot.agent.shaded.org.objectweb.asm.commons.Remapper;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;
import org.glowroot.agent.weaving.Advice;
import org.glowroot.agent.weaving.ClassLoaders;
import org.glowroot.agent.weaving.ImmutableAdvice;
import org.glowroot.agent.weaving.ImmutableAdviceParameter;
import org.glowroot.agent.weaving.ImmutableLazyDefinedClass;
import org.glowroot.agent.weaving.PluginDetail;
import org.glowroot.agent.weaving.PluginDetailBuilder;

class PluginClassRenamer {
    static final String SHIM_SUFFIX = "Shim";
    static final String MIXIN_SUFFIX = "Mixin";
    private static final Logger logger = LoggerFactory.getLogger(PluginClassRenamer.class);
    private final PluginDetail.PointcutClass adviceClass;
    private final String rootPackageName;
    private final String bootstrapSafePackageName;
    private final Set<String> processed = Sets.newHashSet();

    PluginClassRenamer(PluginDetail.PointcutClass adviceClass) {
        this.adviceClass = adviceClass;
        String internalName = adviceClass.type().getInternalName();
        int index = internalName.lastIndexOf(47);
        this.rootPackageName = index == -1 ? "" : internalName.substring(0, index);
        this.bootstrapSafePackageName = this.rootPackageName + "/_/";
    }

    @Nullable
    Advice buildNonBootstrapLoaderAdvice(Advice advice) {
        if (this.rootPackageName.isEmpty()) {
            logger.warn("advice needs to be in a named package in order to collocate the advice in the class loader that it is used from (as opposed to located in the bootstrap class loader)");
            return null;
        }
        return ImmutableAdvice.builder().copyFrom(advice).adviceType(this.hack(advice.adviceType())).travelerType(this.hack(advice.travelerType())).isEnabledAdvice(this.hack(advice.isEnabledAdvice())).onBeforeAdvice(this.hack(advice.onBeforeAdvice())).onReturnAdvice(this.hack(advice.onReturnAdvice())).onThrowAdvice(this.hack(advice.onThrowAdvice())).onAfterAdvice(this.hack(advice.onAfterAdvice())).isEnabledParameters(this.hack(advice.isEnabledParameters())).onBeforeParameters(this.hack(advice.onBeforeParameters())).onReturnParameters(this.hack(advice.onReturnParameters())).onThrowParameters(this.hack(advice.onThrowParameters())).onAfterParameters(this.hack(advice.onAfterParameters())).build();
    }

    @Nullable
    ClassLoaders.LazyDefinedClass buildNonBootstrapLoaderAdviceClass() throws IOException {
        if (this.rootPackageName.isEmpty()) {
            logger.warn("advice needs to be in a named package in order to co-locate the advice in the class loader that it is used from (as opposed to located in the bootstrap class loader)");
            return null;
        }
        return this.build(this.adviceClass.type().getInternalName(), this.adviceClass.bytes());
    }

    private ClassLoaders.LazyDefinedClass build(String internalName, byte[] origBytes) throws IOException {
        this.processed.add(internalName);
        PluginClassRemapper remapper = new PluginClassRemapper();
        ImmutableLazyDefinedClass.Builder builder = ImmutableLazyDefinedClass.builder().type(Type.getObjectType(remapper.mapType(internalName)));
        ClassWriter cw = new ClassWriter(1);
        ClassRemapper cv = new ClassRemapper(cw, remapper);
        ClassReader cr = new ClassReader(origBytes);
        cr.accept(cv, 0);
        builder.bytes(cw.toByteArray());
        for (String unprocessed : remapper.unprocessed) {
            builder.addDependencies(this.build(unprocessed));
        }
        return builder.build();
    }

    private ClassLoaders.LazyDefinedClass build(String internalName) throws IOException {
        return this.build(internalName, PluginDetailBuilder.getBytes(internalName, this.adviceClass.pluginJar()));
    }

    @Nullable
    private Method hack(@Nullable Method method) {
        if (method == null) {
            return null;
        }
        Type[] argumentTypes = method.getArgumentTypes();
        Type[] hackedArgumentTypes = new Type[argumentTypes.length];
        for (int i = 0; i < argumentTypes.length; ++i) {
            hackedArgumentTypes[i] = this.hack(argumentTypes[i]);
        }
        return new Method(method.getName(), this.hack(method.getReturnType()), hackedArgumentTypes);
    }

    private List<Advice.AdviceParameter> hack(List<Advice.AdviceParameter> parameters) {
        ArrayList<Advice.AdviceParameter> hackedParameters = Lists.newArrayList();
        for (Advice.AdviceParameter parameter : parameters) {
            hackedParameters.add(ImmutableAdviceParameter.builder().copyFrom(parameter).type(this.hack(parameter.type())).build());
        }
        return hackedParameters;
    }

    private @PolyNull Type hack(@PolyNull Type type) {
        if (type == null) {
            return null;
        }
        String internalName = type.getInternalName();
        if (this.collocate(internalName)) {
            return Type.getObjectType(internalName + "_");
        }
        return type;
    }

    private boolean collocate(String internalName) {
        return internalName.startsWith(this.rootPackageName) && !internalName.endsWith(MIXIN_SUFFIX) && !internalName.endsWith(SHIM_SUFFIX) && !internalName.startsWith(this.bootstrapSafePackageName);
    }

    private class PluginClassRemapper
    extends Remapper {
        private final Set<String> unprocessed = Sets.newHashSet();

        private PluginClassRemapper() {
        }

        @Override
        public String map(String internalName) {
            if (PluginClassRenamer.this.collocate(internalName)) {
                if (!PluginClassRenamer.this.processed.contains(internalName)) {
                    this.unprocessed.add(internalName);
                }
                return internalName + "_";
            }
            return internalName;
        }
    }
}

