/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.weaving;

import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.org.objectweb.asm.AnnotationVisitor;
import org.glowroot.agent.shaded.org.objectweb.asm.ClassVisitor;
import org.glowroot.agent.shaded.org.objectweb.asm.ClassWriter;
import org.glowroot.agent.shaded.org.objectweb.asm.Label;
import org.glowroot.agent.shaded.org.objectweb.asm.MethodVisitor;
import org.glowroot.agent.shaded.org.objectweb.asm.commons.GeneratorAdapter;
import org.glowroot.agent.weaving.WeavingMethodVisitor;

class PointcutClassVisitor
extends ClassVisitor {
    private final ClassWriter cw;
    private @Nullable String className;
    private @MonotonicNonNull PointcutMethodVisitor onBeforeMethodVisitor;
    private boolean constructorPointcut;

    PointcutClassVisitor(ClassWriter cw) {
        super(589824, cw);
        this.cw = cw;
    }

    boolean isConstructorPointcut() {
        return this.constructorPointcut;
    }

    boolean hasOnBeforeMethod() {
        return this.onBeforeMethodVisitor != null;
    }

    @Override
    public void visit(int version, int access, String name, @Nullable String signature, @Nullable String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.className = name;
    }

    @Override
    public @Nullable AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        AnnotationVisitor av = this.cw.visitAnnotation(descriptor, visible);
        if (descriptor.equals("Lorg/glowroot/agent/plugin/api/weaving/Pointcut;")) {
            return new PointcutAnnotationVisitor(av);
        }
        return av;
    }

    @Override
    public @Nullable MethodVisitor visitMethod(int access, String name, String descriptor, @Nullable String signature, String[] exceptions) {
        if (this.constructorPointcut) {
            return new PointcutMethodVisitor(this.cw.visitMethod(access, name, descriptor, signature, exceptions), access, name, descriptor, signature, exceptions);
        }
        return null;
    }

    @Override
    public void visitEnd() {
        if (this.onBeforeMethodVisitor != null) {
            int access = this.onBeforeMethodVisitor.access;
            String name = this.onBeforeMethodVisitor.name;
            String descriptor = "(Z" + this.onBeforeMethodVisitor.descriptor.substring(1);
            String signature = this.onBeforeMethodVisitor.signature;
            String[] exceptions = this.onBeforeMethodVisitor.exceptions;
            GeneratorAdapter mv = new GeneratorAdapter(this.cw.visitMethod(access, name, descriptor, signature, exceptions), access, name, descriptor);
            mv.visitCode();
            mv.visitVarInsn(21, 0);
            Label endWithDefaultLabel = new Label();
            mv.visitJumpInsn(153, endWithDefaultLabel);
            mv.loadArgs(1, mv.getArgumentTypes().length - 1);
            mv.visitMethodInsn(184, Preconditions.checkNotNull(this.className), name, this.onBeforeMethodVisitor.descriptor, false);
            mv.returnValue();
            mv.visitLabel(endWithDefaultLabel);
            mv.visitFrame(-1, 0, new Object[0], 0, new Object[0]);
            if (mv.getReturnType().getSort() != 0) {
                WeavingMethodVisitor.pushDefault(mv, mv.getReturnType());
            }
            mv.returnValue();
            mv.endMethod();
        }
        super.visitEnd();
    }

    private class PointcutMethodVisitor
    extends MethodVisitor {
        private final int access;
        private final String name;
        private final String descriptor;
        private final @Nullable String signature;
        private final String[] exceptions;

        private PointcutMethodVisitor(MethodVisitor mv, int access, String name, @Nullable String descriptor, String signature, String[] exceptions) {
            super(589824, mv);
            this.access = access;
            this.name = name;
            this.descriptor = descriptor;
            this.signature = signature;
            this.exceptions = exceptions;
        }

        @Override
        public @Nullable AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
            if (descriptor.equals("Lorg/glowroot/agent/plugin/api/weaving/OnBefore;")) {
                PointcutClassVisitor.this.onBeforeMethodVisitor = this;
            }
            return super.visitAnnotation(descriptor, visible);
        }
    }

    private class PointcutAnnotationVisitor
    extends AnnotationVisitor {
        private PointcutAnnotationVisitor(AnnotationVisitor av) {
            super(589824, av);
        }

        @Override
        public void visit(@Nullable String name, Object value) {
            if ("methodName".equals(name) && "<init>".equals(value)) {
                PointcutClassVisitor.this.constructorPointcut = true;
            }
            super.visit(name, value);
        }
    }
}

