/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.nativebridge.jni;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.graalvm.nativebridge.jni.JNI;
import org.graalvm.nativebridge.jni.JNIExceptionWrapper;
import org.graalvm.nativebridge.jni.JNIUtil;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class HotSpotCalls {
    private static final HotSpotCalls INSTANCE = new HotSpotCalls(JNIExceptionWrapper.ExceptionHandler.DEFAULT);
    private static final ThreadLocal<Boolean> inTrace = ThreadLocal.withInitial(() -> false);
    private final JNIExceptionWrapper.ExceptionHandler exceptionHandler;
    private static final Set<String> HOT_SPOT_CALL_NAMES;

    private HotSpotCalls(JNIExceptionWrapper.ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public static HotSpotCalls getDefault() {
        return INSTANCE;
    }

    public static HotSpotCalls createWithExceptionHandler(JNIExceptionWrapper.ExceptionHandler handler) {
        Objects.requireNonNull(handler, "Handler must be non null.");
        return new HotSpotCalls(handler);
    }

    @HotSpotCall
    public void callStaticVoid(JNI.JNIEnv env, JNI.JClass clazz, JNIMethod method, JNI.JValue args) {
        HotSpotCalls.traceCall(env, clazz, method);
        env.getFunctions().getCallStaticVoidMethodA().call(env, clazz, method.getJMethodID(), args);
        JNIExceptionWrapper.wrapAndThrowPendingJNIException(env, this.exceptionHandler);
    }

    @HotSpotCall
    public boolean callStaticBoolean(JNI.JNIEnv env, JNI.JClass clazz, JNIMethod method, JNI.JValue args) {
        HotSpotCalls.traceCall(env, clazz, method);
        boolean res = env.getFunctions().getCallStaticBooleanMethodA().call(env, clazz, method.getJMethodID(), args);
        JNIExceptionWrapper.wrapAndThrowPendingJNIException(env, this.exceptionHandler);
        return res;
    }

    @HotSpotCall
    public long callStaticLong(JNI.JNIEnv env, JNI.JClass clazz, JNIMethod method, JNI.JValue args) {
        HotSpotCalls.traceCall(env, clazz, method);
        long res = env.getFunctions().getCallStaticLongMethodA().call(env, clazz, method.getJMethodID(), args);
        JNIExceptionWrapper.wrapAndThrowPendingJNIException(env, this.exceptionHandler);
        return res;
    }

    @HotSpotCall
    public int callStaticInt(JNI.JNIEnv env, JNI.JClass clazz, JNIMethod method, JNI.JValue args) {
        HotSpotCalls.traceCall(env, clazz, method);
        int res = env.getFunctions().getCallStaticIntMethodA().call(env, clazz, method.getJMethodID(), args);
        JNIExceptionWrapper.wrapAndThrowPendingJNIException(env, this.exceptionHandler);
        return res;
    }

    @HotSpotCall
    public <R extends JNI.JObject> R callStaticJObject(JNI.JNIEnv env, JNI.JClass clazz, JNIMethod method, JNI.JValue args) {
        HotSpotCalls.traceCall(env, clazz, method);
        JNI.JObject res = env.getFunctions().getCallStaticObjectMethodA().call(env, clazz, method.getJMethodID(), args);
        JNIExceptionWrapper.wrapAndThrowPendingJNIException(env, this.exceptionHandler);
        return (R)res;
    }

    @HotSpotCall
    public <R extends JNI.JObject> R callNewObject(JNI.JNIEnv env, JNI.JClass clazz, JNIMethod constructor, JNI.JValue args) {
        HotSpotCalls.traceCall(env, clazz, constructor);
        JNI.JObject res = env.getFunctions().getNewObjectA().call(env, clazz, constructor.getJMethodID(), args);
        JNIExceptionWrapper.wrapAndThrowPendingJNIException(env, this.exceptionHandler);
        return (R)res;
    }

    @HotSpotCall
    public void callVoid(JNI.JNIEnv env, JNI.JObject object, JNIMethod method, JNI.JValue args) {
        HotSpotCalls.traceCall(env, object, method);
        env.getFunctions().getCallVoidMethodA().call(env, object, method.getJMethodID(), args);
        JNIExceptionWrapper.wrapAndThrowPendingJNIException(env, this.exceptionHandler);
    }

    @HotSpotCall
    public <R extends JNI.JObject> R callJObject(JNI.JNIEnv env, JNI.JObject object, JNIMethod method, JNI.JValue args) {
        HotSpotCalls.traceCall(env, object, method);
        JNI.JObject res = env.getFunctions().getCallObjectMethodA().call(env, object, method.getJMethodID(), args);
        JNIExceptionWrapper.wrapAndThrowPendingJNIException(env, this.exceptionHandler);
        return (R)res;
    }

    @HotSpotCall
    public boolean callBoolean(JNI.JNIEnv env, JNI.JObject object, JNIMethod method, JNI.JValue args) {
        HotSpotCalls.traceCall(env, object, method);
        boolean res = env.getFunctions().getCallBooleanMethodA().call(env, object, method.getJMethodID(), args);
        JNIExceptionWrapper.wrapAndThrowPendingJNIException(env, this.exceptionHandler);
        return res;
    }

    @HotSpotCall
    public short callShort(JNI.JNIEnv env, JNI.JObject object, JNIMethod method, JNI.JValue args) {
        HotSpotCalls.traceCall(env, object, method);
        short res = env.getFunctions().getCallShortMethodA().call(env, object, method.getJMethodID(), args);
        JNIExceptionWrapper.wrapAndThrowPendingJNIException(env, this.exceptionHandler);
        return res;
    }

    @HotSpotCall
    public int callInt(JNI.JNIEnv env, JNI.JObject object, JNIMethod method, JNI.JValue args) {
        HotSpotCalls.traceCall(env, object, method);
        int res = env.getFunctions().getCallIntMethodA().call(env, object, method.getJMethodID(), args);
        JNIExceptionWrapper.wrapAndThrowPendingJNIException(env, this.exceptionHandler);
        return res;
    }

    @HotSpotCall
    public long callLong(JNI.JNIEnv env, JNI.JObject object, JNIMethod method, JNI.JValue args) {
        HotSpotCalls.traceCall(env, object, method);
        long res = env.getFunctions().getCallLongMethodA().call(env, object, method.getJMethodID(), args);
        JNIExceptionWrapper.wrapAndThrowPendingJNIException(env, this.exceptionHandler);
        return res;
    }

    @HotSpotCall
    public double callDouble(JNI.JNIEnv env, JNI.JObject object, JNIMethod method, JNI.JValue args) {
        HotSpotCalls.traceCall(env, object, method);
        double res = env.getFunctions().getCallDoubleMethodA().call(env, object, method.getJMethodID(), args);
        JNIExceptionWrapper.wrapAndThrowPendingJNIException(env, this.exceptionHandler);
        return res;
    }

    @HotSpotCall
    public float callFloat(JNI.JNIEnv env, JNI.JObject object, JNIMethod method, JNI.JValue args) {
        HotSpotCalls.traceCall(env, object, method);
        float res = env.getFunctions().getCallFloatMethodA().call(env, object, method.getJMethodID(), args);
        JNIExceptionWrapper.wrapAndThrowPendingJNIException(env, this.exceptionHandler);
        return res;
    }

    @HotSpotCall
    public byte callByte(JNI.JNIEnv env, JNI.JObject object, JNIMethod method, JNI.JValue args) {
        HotSpotCalls.traceCall(env, object, method);
        byte res = env.getFunctions().getCallByteMethodA().call(env, object, method.getJMethodID(), args);
        JNIExceptionWrapper.wrapAndThrowPendingJNIException(env, this.exceptionHandler);
        return res;
    }

    @HotSpotCall
    public char callChar(JNI.JNIEnv env, JNI.JObject object, JNIMethod method, JNI.JValue args) {
        HotSpotCalls.traceCall(env, object, method);
        char res = env.getFunctions().getCallCharMethodA().call(env, object, method.getJMethodID(), args);
        JNIExceptionWrapper.wrapAndThrowPendingJNIException(env, this.exceptionHandler);
        return res;
    }

    private static void traceCall(JNI.JNIEnv env, JNI.JClass clazz, JNIMethod method) {
        if (!inTrace.get().booleanValue()) {
            inTrace.set(true);
            try {
                JNIUtil.trace(1, "%s->HS: %s::%s", JNIUtil.getFeatureName(), HotSpotCalls.toSimpleName(JNIUtil.createString(env, (JNI.JString)JNIExceptionWrapper.callGetClassName(env, clazz))), method.getDisplayName());
            }
            finally {
                inTrace.remove();
            }
        }
    }

    private static void traceCall(JNI.JNIEnv env, JNI.JObject receiver, JNIMethod method) {
        HotSpotCalls.traceCall(env, env.getFunctions().getGetObjectClass().call(env, receiver), method);
    }

    private static String toSimpleName(String fqn) {
        int separatorIndex = fqn.lastIndexOf(46);
        return separatorIndex < 0 || separatorIndex + 1 == fqn.length() ? fqn : fqn.substring(separatorIndex + 1);
    }

    static boolean isHotSpotCall(StackTraceElement frame) {
        if (!HotSpotCalls.class.getName().equals(frame.getClassName())) {
            return false;
        }
        return HOT_SPOT_CALL_NAMES.contains(frame.getMethodName());
    }

    static {
        HashMap<String, Method> entryPoints = new HashMap<String, Method>();
        HashMap<String, Method> others = new HashMap<String, Method>();
        for (Method m : HotSpotCalls.class.getDeclaredMethods()) {
            if (m.getAnnotation(HotSpotCall.class) != null) {
                Method existing = entryPoints.put(m.getName(), m);
                if (existing == null) continue;
                throw new InternalError("Method annotated by " + HotSpotCall.class.getSimpleName() + " must have unique name: " + m + " and " + existing);
            }
            others.put(m.getName(), m);
        }
        for (Map.Entry entry : entryPoints.entrySet()) {
            Method existing = (Method)others.get(entry.getKey());
            if (existing == null) continue;
            throw new InternalError("Method annotated by " + HotSpotCall.class.getSimpleName() + " must have unique name: " + entry.getValue() + " and " + existing);
        }
        HOT_SPOT_CALL_NAMES = Collections.unmodifiableSet(entryPoints.keySet());
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    private static @interface HotSpotCall {
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface JNIMethod {
        public JNI.JMethodID getJMethodID();

        public String getDisplayName();

        public static JNIMethod findMethod(JNI.JNIEnv env, JNI.JClass clazz, boolean staticMethod, String methodName, String methodSignature) {
            return JNIMethod.findMethod(env, clazz, staticMethod, true, methodName, methodSignature);
        }

        public static JNIMethod findMethod(JNI.JNIEnv env, JNI.JClass clazz, boolean staticMethod, boolean required, final String methodName, final String methodSignature) {
            final JNI.JMethodID methodID = JNIUtil.findMethod(env, clazz, staticMethod, required, methodName, methodSignature);
            return methodID.isNull() ? null : new JNIMethod(){

                @Override
                public JNI.JMethodID getJMethodID() {
                    return methodID;
                }

                @Override
                public String getDisplayName() {
                    return methodName;
                }

                public String toString() {
                    return methodName + methodSignature + "[0x" + Long.toHexString(methodID.rawValue()) + ']';
                }
            };
        }
    }
}

