/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.nativebridge.jni;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.graalvm.compiler.serviceprovider.IsolateUtil;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.nativebridge.jni.JNI;
import org.graalvm.nativebridge.jni.JNIExceptionWrapper;
import org.graalvm.nativebridge.jni.JNIMethodScope;
import org.graalvm.nativebridge.jni.NativeBridgeSupport;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.UnmanagedMemory;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.nativeimage.c.type.CLongPointer;
import org.graalvm.nativeimage.c.type.CShortPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.nativeimage.c.type.VoidPointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class JNIUtil {
    private static final String CLASS_SERVICES = "jdk/vm/ci/services/Services";
    private static final String[] METHOD_GET_JVMCI_CLASS_LOADER = new String[]{"getJVMCIClassLoader", "()Ljava/lang/ClassLoader;"};
    private static final String[] METHOD_GET_PLATFORM_CLASS_LOADER = new String[]{"getPlatformClassLoader", "()Ljava/lang/ClassLoader;"};
    private static final String[] METHOD_LOAD_CLASS = new String[]{"loadClass", "(Ljava/lang/String;)Ljava/lang/Class;"};

    public static boolean IsSameObject(JNI.JNIEnv env, JNI.JObject ref1, JNI.JObject ref2) {
        JNIUtil.traceJNI("IsSameObject");
        return env.getFunctions().getIsSameObject().call(env, ref1, ref2);
    }

    public static void DeleteLocalRef(JNI.JNIEnv env, JNI.JObject ref) {
        JNIUtil.traceJNI("DeleteLocalRef");
        env.getFunctions().getDeleteLocalRef().call(env, ref);
    }

    public static int PushLocalFrame(JNI.JNIEnv env, int capacity) {
        JNIUtil.traceJNI("PushLocalFrame");
        return env.getFunctions().getPushLocalFrame().call(env, capacity);
    }

    public static JNI.JObject PopLocalFrame(JNI.JNIEnv env, JNI.JObject result) {
        JNIUtil.traceJNI("PopLocalFrame");
        return env.getFunctions().getPopLocalFrame().call(env, result);
    }

    public static JNI.JClass DefineClass(JNI.JNIEnv env, CCharPointer name, JNI.JObject loader, CCharPointer buf, int bufLen) {
        return env.getFunctions().getDefineClass().call(env, name, loader, buf, bufLen);
    }

    public static JNI.JClass FindClass(JNI.JNIEnv env, CCharPointer name) {
        JNIUtil.traceJNI("FindClass");
        return env.getFunctions().getFindClass().call(env, name);
    }

    public static JNI.JClass GetObjectClass(JNI.JNIEnv env, JNI.JObject object) {
        JNIUtil.traceJNI("GetObjectClass");
        return env.getFunctions().getGetObjectClass().call(env, object);
    }

    public static JNI.JMethodID GetStaticMethodID(JNI.JNIEnv env, JNI.JClass clazz, CCharPointer name, CCharPointer sig) {
        JNIUtil.traceJNI("GetStaticMethodID");
        return env.getFunctions().getGetStaticMethodID().call(env, clazz, name, sig);
    }

    public static JNI.JMethodID GetMethodID(JNI.JNIEnv env, JNI.JClass clazz, CCharPointer name, CCharPointer sig) {
        JNIUtil.traceJNI("GetMethodID");
        return env.getFunctions().getGetMethodID().call(env, clazz, name, sig);
    }

    public static JNI.JFieldID GetStaticFieldID(JNI.JNIEnv env, JNI.JClass clazz, CCharPointer name, CCharPointer sig) {
        JNIUtil.traceJNI("GetStaticFieldID");
        return env.getFunctions().getGetStaticFieldID().call(env, clazz, name, sig);
    }

    public static JNI.JFieldID GetFieldID(JNI.JNIEnv env, JNI.JClass clazz, CCharPointer name, CCharPointer signature) {
        JNIUtil.traceJNI("GetFieldID");
        return env.getFunctions().getGetFieldID().call(env, clazz, name, signature);
    }

    public static JNI.JObject GetStaticObjectField(JNI.JNIEnv env, JNI.JClass clazz, JNI.JFieldID fieldID) {
        JNIUtil.traceJNI("GetFieldID");
        return env.getFunctions().getGetStaticObjectField().call(env, clazz, fieldID);
    }

    public static int GetIntField(JNI.JNIEnv env, JNI.JObject object, JNI.JFieldID fieldID) {
        JNIUtil.traceJNI("GetIntField");
        return env.getFunctions().getGetIntField().call(env, object, fieldID);
    }

    public static JNI.JObjectArray NewObjectArray(JNI.JNIEnv env, int len, JNI.JClass componentClass, JNI.JObject initialElement) {
        JNIUtil.traceJNI("NewObjectArray");
        return env.getFunctions().getNewObjectArray().call(env, len, componentClass, initialElement);
    }

    public static JNI.JByteArray NewByteArray(JNI.JNIEnv env, int len) {
        JNIUtil.traceJNI("NewByteArray");
        return env.getFunctions().getNewByteArray().call(env, len);
    }

    public static JNI.JIntArray NewIntArray(JNI.JNIEnv env, int len) {
        JNIUtil.traceJNI("NewIntArray");
        return env.getFunctions().getNewIntArray().call(env, len);
    }

    public static JNI.JLongArray NewLongArray(JNI.JNIEnv env, int len) {
        JNIUtil.traceJNI("NewLongArray");
        return env.getFunctions().getNewLongArray().call(env, len);
    }

    public static int GetArrayLength(JNI.JNIEnv env, JNI.JArray array) {
        JNIUtil.traceJNI("GetArrayLength");
        return env.getFunctions().getGetArrayLength().call(env, array);
    }

    public static void SetObjectArrayElement(JNI.JNIEnv env, JNI.JObjectArray array, int index, JNI.JObject value) {
        JNIUtil.traceJNI("SetObjectArrayElement");
        env.getFunctions().getSetObjectArrayElement().call(env, array, index, value);
    }

    public static JNI.JObject GetObjectArrayElement(JNI.JNIEnv env, JNI.JObjectArray array, int index) {
        JNIUtil.traceJNI("GetObjectArrayElement");
        return env.getFunctions().getGetObjectArrayElement().call(env, array, index);
    }

    public static CIntPointer GetIntArrayElements(JNI.JNIEnv env, JNI.JIntArray array, JNI.JValue isCopy) {
        JNIUtil.traceJNI("GetIntArrayElements");
        return env.getFunctions().getGetIntArrayElements().call(env, array, isCopy);
    }

    public static CLongPointer GetLongArrayElements(JNI.JNIEnv env, JNI.JLongArray array, JNI.JValue isCopy) {
        JNIUtil.traceJNI("GetLongArrayElements");
        return env.getFunctions().getGetLongArrayElements().call(env, array, isCopy);
    }

    public static void ReleaseIntArrayElements(JNI.JNIEnv env, JNI.JIntArray array, CIntPointer elems, int mode) {
        JNIUtil.traceJNI("ReleaseIntArrayElements");
        env.getFunctions().getReleaseIntArrayElements().call(env, array, elems, mode);
    }

    public static void ReleaseLongArrayElements(JNI.JNIEnv env, JNI.JLongArray array, CLongPointer elems, int mode) {
        JNIUtil.traceJNI("ReleaseLongArrayElements");
        env.getFunctions().getReleaseLongArrayElements().call(env, array, elems, mode);
    }

    public static CCharPointer GetByteArrayElements(JNI.JNIEnv env, JNI.JByteArray array, JNI.JValue isCopy) {
        JNIUtil.traceJNI("GetByteArrayElements");
        return env.getFunctions().getGetByteArrayElements().call(env, array, isCopy);
    }

    public static void ReleaseByteArrayElements(JNI.JNIEnv env, JNI.JByteArray array, CCharPointer elems, int mode) {
        JNIUtil.traceJNI("ReleaseByteArrayElements");
        env.getFunctions().getReleaseByteArrayElements().call(env, array, elems, mode);
    }

    public static JNI.JavaVM GetJavaVM(JNI.JNIEnv env) {
        JNIUtil.traceJNI("GetJavaVM");
        JNI.JavaVMPointer javaVMPointer = (JNI.JavaVMPointer)StackValue.get(JNI.JavaVMPointer.class);
        if (env.getFunctions().getGetJavaVM().call(env, javaVMPointer) == 0) {
            return javaVMPointer.readJavaVM();
        }
        return (JNI.JavaVM)WordFactory.nullPointer();
    }

    public static JNI.JNIEnv GetEnv(JNI.JavaVM vm) {
        JNIUtil.traceJNI("GetEnv");
        JNI.JNIEnvPointer envPointer = (JNI.JNIEnvPointer)StackValue.get(JNI.JNIEnvPointer.class);
        if (vm.getFunctions().getGetEnv().call(vm, envPointer, 65544) == 0) {
            return envPointer.readJNIEnv();
        }
        return (JNI.JNIEnv)WordFactory.nullPointer();
    }

    public static JNI.JNIEnv AttachCurrentThread(JNI.JavaVM vm, JNI.JavaVMAttachArgs args) {
        JNIUtil.traceJNI("AttachCurrentThread");
        JNI.JNIEnvPointer envPointer = (JNI.JNIEnvPointer)StackValue.get(JNI.JNIEnvPointer.class);
        if (vm.getFunctions().getAttachCurrentThread().call(vm, envPointer, args) == 0) {
            return envPointer.readJNIEnv();
        }
        return (JNI.JNIEnv)WordFactory.nullPointer();
    }

    public static JNI.JNIEnv AttachCurrentThreadAsDaemon(JNI.JavaVM vm, JNI.JavaVMAttachArgs args) {
        JNIUtil.traceJNI("AttachCurrentThreadAsDaemon");
        JNI.JNIEnvPointer envPointer = (JNI.JNIEnvPointer)StackValue.get(JNI.JNIEnvPointer.class);
        if (vm.getFunctions().getAttachCurrentThreadAsDaemon().call(vm, envPointer, args) == 0) {
            return envPointer.readJNIEnv();
        }
        return (JNI.JNIEnv)WordFactory.nullPointer();
    }

    public static boolean DetachCurrentThread(JNI.JavaVM vm) {
        JNIUtil.traceJNI("DetachCurrentThread");
        return vm.getFunctions().getDetachCurrentThread().call(vm) == 0;
    }

    public static void Throw(JNI.JNIEnv env, JNI.JThrowable throwable) {
        JNIUtil.traceJNI("Throw");
        env.getFunctions().getThrow().call(env, throwable);
    }

    public static boolean ExceptionCheck(JNI.JNIEnv env) {
        JNIUtil.traceJNI("ExceptionCheck");
        return env.getFunctions().getExceptionCheck().call(env);
    }

    public static void ExceptionClear(JNI.JNIEnv env) {
        JNIUtil.traceJNI("ExceptionClear");
        env.getFunctions().getExceptionClear().call(env);
    }

    public static void ExceptionDescribe(JNI.JNIEnv env) {
        JNIUtil.traceJNI("ExceptionDescribe");
        env.getFunctions().getExceptionDescribe().call(env);
    }

    public static JNI.JThrowable ExceptionOccurred(JNI.JNIEnv env) {
        JNIUtil.traceJNI("ExceptionOccurred");
        return env.getFunctions().getExceptionOccurred().call(env);
    }

    public static <T extends JNI.JObject> T NewGlobalRef(JNI.JNIEnv env, T ref, String type) {
        JNIUtil.traceJNI("NewGlobalRef");
        JNI.JObject res = env.getFunctions().getNewGlobalRef().call(env, ref);
        if (JNIUtil.tracingAt(3)) {
            JNIUtil.trace(3, "New global reference for 0x%x of type %s -> 0x%x", ref.rawValue(), type, res.rawValue());
        }
        return (T)res;
    }

    public static void DeleteGlobalRef(JNI.JNIEnv env, JNI.JObject ref) {
        JNIUtil.traceJNI("DeleteGlobalRef");
        if (JNIUtil.tracingAt(3)) {
            JNIUtil.trace(3, "Delete global reference 0x%x", ref.rawValue());
        }
        env.getFunctions().getDeleteGlobalRef().call(env, ref);
    }

    public static VoidPointer GetDirectBufferAddress(JNI.JNIEnv env, JNI.JObject buf) {
        JNIUtil.traceJNI("GetDirectBufferAddress");
        return env.getFunctions().getGetDirectBufferAddress().call(env, buf);
    }

    public static boolean IsInstanceOf(JNI.JNIEnv env, JNI.JObject obj, JNI.JClass clazz) {
        JNIUtil.traceJNI("IsInstanceOf");
        return env.getFunctions().getIsInstanceOf().call(env, obj, clazz);
    }

    private static void traceJNI(String function) {
        JNIUtil.trace(2, "%s->JNI: %s", JNIUtil.getFeatureName(), function);
    }

    private JNIUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createString(JNI.JNIEnv env, JNI.JString hsString) {
        if (hsString.isNull()) {
            return null;
        }
        int len = env.getFunctions().getGetStringLength().call(env, hsString);
        CShortPointer unicode = env.getFunctions().getGetStringChars().call(env, hsString, (JNI.JValue)WordFactory.nullPointer());
        try {
            char[] data = new char[len];
            for (int i = 0; i < len; ++i) {
                data[i] = (char)unicode.read(i);
            }
            String string = new String(data);
            return string;
        }
        finally {
            env.getFunctions().getReleaseStringChars().call(env, hsString, unicode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JNI.JString createHSString(JNI.JNIEnv env, String string) {
        if (string == null) {
            return (JNI.JString)WordFactory.nullPointer();
        }
        int len = string.length();
        CShortPointer buffer = (CShortPointer)UnmanagedMemory.malloc((int)(len << 1));
        try {
            for (int i = 0; i < len; ++i) {
                buffer.write(i, (short)string.charAt(i));
            }
            JNI.JString jString = env.getFunctions().getNewString().call(env, buffer, len);
            return jString;
        }
        finally {
            UnmanagedMemory.free((PointerBase)buffer);
        }
    }

    public static String getInternalName(String fqn) {
        return "L" + JNIUtil.getBinaryName(fqn) + ";";
    }

    public static String getBinaryName(String fqn) {
        return fqn.replace('.', '/');
    }

    public static String encodeMethodSignature(Class<?> returnType, Class<?> ... parameterTypes) {
        StringBuilder builder = new StringBuilder("(");
        for (Class<?> type : parameterTypes) {
            JNIUtil.encodeType(type, builder);
        }
        builder.append(")");
        JNIUtil.encodeType(returnType, builder);
        return builder.toString();
    }

    private static void encodeType(Class<?> type, StringBuilder buf) {
        String desc;
        if (type == Boolean.TYPE) {
            desc = "Z";
        } else if (type == Byte.TYPE) {
            desc = "B";
        } else if (type == Character.TYPE) {
            desc = "C";
        } else if (type == Short.TYPE) {
            desc = "S";
        } else if (type == Integer.TYPE) {
            desc = "I";
        } else if (type == Long.TYPE) {
            desc = "J";
        } else if (type == Float.TYPE) {
            desc = "F";
        } else if (type == Double.TYPE) {
            desc = "D";
        } else if (type == Void.TYPE) {
            desc = "V";
        } else {
            if (type.isArray()) {
                buf.append('[');
                JNIUtil.encodeType(type.getComponentType(), buf);
                return;
            }
            desc = "L" + type.getName().replace('.', '/') + ";";
        }
        buf.append(desc);
    }

    public static JNI.JClass findClass(JNI.JNIEnv env, String binaryName) {
        JNIUtil.trace(1, "%s->HS: findClass %s", JNIUtil.getFeatureName(), binaryName);
        try (CTypeConversion.CCharPointerHolder name = CTypeConversion.toCString((CharSequence)binaryName);){
            JNI.JClass jClass = JNIUtil.FindClass(env, name.get());
            return jClass;
        }
    }

    public static JNI.JClass findClass(JNI.JNIEnv env, JNI.JObject classLoader, String binaryName) {
        if (classLoader.isNull()) {
            throw new IllegalArgumentException("ClassLoader must be non null.");
        }
        JNIUtil.trace(1, "%s->HS: findClass %s", JNIUtil.getFeatureName(), binaryName);
        JNI.JMethodID findClassId = JNIUtil.findMethod(env, JNIUtil.GetObjectClass(env, classLoader), false, false, METHOD_LOAD_CLASS[0], METHOD_LOAD_CLASS[1]);
        JNI.JValue params = (JNI.JValue)StackValue.get((int)1, JNI.JValue.class);
        params.addressOf(0).setJObject(JNIUtil.createHSString(env, binaryName.replace('/', '.')));
        return (JNI.JClass)env.getFunctions().getCallObjectMethodA().call(env, classLoader, findClassId, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JNI.JClass findClass(JNI.JNIEnv env, JNI.JObject classLoader, String binaryName, boolean required) {
        Class allowedException;
        block3: {
            JNI.JClass jClass;
            allowedException = null;
            try {
                if (!classLoader.isNonNull()) break block3;
                allowedException = required ? null : ClassNotFoundException.class;
                jClass = JNIUtil.findClass(env, classLoader, binaryName);
                JNIExceptionWrapper.wrapAndThrowPendingJNIException(env, allowedException == null ? JNIExceptionWrapper.ExceptionHandler.DEFAULT : JNIExceptionWrapper.ExceptionHandler.allowExceptions(allowedException));
            }
            catch (Throwable throwable) {
                JNIExceptionWrapper.wrapAndThrowPendingJNIException(env, allowedException == null ? JNIExceptionWrapper.ExceptionHandler.DEFAULT : JNIExceptionWrapper.ExceptionHandler.allowExceptions(allowedException));
                throw throwable;
            }
            return jClass;
        }
        allowedException = required ? null : NoClassDefFoundError.class;
        JNI.JClass jClass = JNIUtil.findClass(env, binaryName);
        JNIExceptionWrapper.wrapAndThrowPendingJNIException(env, allowedException == null ? JNIExceptionWrapper.ExceptionHandler.DEFAULT : JNIExceptionWrapper.ExceptionHandler.allowExceptions(allowedException));
        return jClass;
    }

    public static JNI.JObject getJVMCIClassLoader(JNI.JNIEnv env) {
        JNI.JClass clazz;
        if (JavaVersionUtil.JAVA_SPEC <= 8) {
            JNI.JClass clazz2;
            try (CTypeConversion.CCharPointerHolder className = CTypeConversion.toCString((CharSequence)CLASS_SERVICES);){
                clazz2 = JNIUtil.FindClass(env, className.get());
            }
            if (clazz2.isNull()) {
                throw new InternalError("No such class jdk/vm/ci/services/Services");
            }
            JNI.JMethodID getClassLoaderId = JNIUtil.findMethod(env, clazz2, true, true, METHOD_GET_JVMCI_CLASS_LOADER[0], METHOD_GET_JVMCI_CLASS_LOADER[1]);
            if (getClassLoaderId.isNull()) {
                throw new InternalError(String.format("Cannot find method %s in class %s.", METHOD_GET_JVMCI_CLASS_LOADER[0], CLASS_SERVICES));
            }
            return env.getFunctions().getCallStaticObjectMethodA().call(env, clazz2, getClassLoaderId, (JNI.JValue)WordFactory.nullPointer());
        }
        try (CTypeConversion.CCharPointerHolder className = CTypeConversion.toCString((CharSequence)JNIUtil.getBinaryName(ClassLoader.class.getName()));){
            clazz = JNIUtil.FindClass(env, className.get());
        }
        if (clazz.isNull()) {
            throw new InternalError("No such class " + ClassLoader.class.getName());
        }
        JNI.JMethodID getClassLoaderId = JNIUtil.findMethod(env, clazz, true, true, METHOD_GET_PLATFORM_CLASS_LOADER[0], METHOD_GET_PLATFORM_CLASS_LOADER[1]);
        if (getClassLoaderId.isNull()) {
            throw new InternalError(String.format("Cannot find method %s in class %s.", METHOD_GET_PLATFORM_CLASS_LOADER[0], ClassLoader.class.getName()));
        }
        return env.getFunctions().getCallStaticObjectMethodA().call(env, clazz, getClassLoaderId, (JNI.JValue)WordFactory.nullPointer());
    }

    public static JNI.JMethodID findMethod(JNI.JNIEnv env, JNI.JClass clazz, boolean staticMethod, String methodName, String methodSignature) {
        return JNIUtil.findMethod(env, clazz, staticMethod, false, methodName, methodSignature);
    }

    /*
     * Exception decompiling
     */
    static JNI.JMethodID findMethod(JNI.JNIEnv env, JNI.JClass clazz, boolean staticMethod, boolean required, String methodName, String methodSignature) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static JNI.JFieldID findField(JNI.JNIEnv env, JNI.JClass clazz, boolean staticField, String fieldName, String fieldSignature) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static JNI.JNIEnv attachCurrentThread(JNI.JavaVM vm, boolean daemon, String name, JNI.JObject threadGroup) {
        try (CTypeConversion.CCharPointerHolder cname = CTypeConversion.toCString((CharSequence)name);){
            JNI.JavaVMAttachArgs args = (JNI.JavaVMAttachArgs)StackValue.get(JNI.JavaVMAttachArgs.class);
            args.setVersion(65544);
            args.setGroup(threadGroup);
            args.setName(cname.get());
            JNI.JNIEnv jNIEnv = daemon ? JNIUtil.AttachCurrentThreadAsDaemon(vm, args) : JNIUtil.AttachCurrentThread(vm, args);
            return jNIEnv;
        }
    }

    public static boolean tracingAt(int level) {
        return NativeBridgeSupport.getInstance().isTracingEnabled(level);
    }

    public static void trace(int level, String format, Object ... args) {
        if (JNIUtil.tracingAt(level)) {
            StringBuilder sb = new StringBuilder();
            sb.append('[').append(IsolateUtil.getIsolateID()).append(':').append(Thread.currentThread().getName()).append(']');
            JNIMethodScope scope = JNIMethodScope.scopeOrNull();
            if (scope != null) {
                sb.append(new String(new char[2 + scope.depth() * 2]).replace('\u0000', ' '));
            }
            NativeBridgeSupport.getInstance().trace(sb.append(String.format(format, args)).toString());
        }
    }

    public static void trace(int level, Throwable throwable) {
        if (JNIUtil.tracingAt(level)) {
            StringWriter stringWriter = new StringWriter();
            try (PrintWriter out = new PrintWriter(stringWriter);){
                throwable.printStackTrace(out);
            }
            JNIUtil.trace(level, stringWriter.toString(), new Object[0]);
        }
    }

    static String getFeatureName() {
        return NativeBridgeSupport.getInstance().getFeatureName();
    }
}

