/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.code;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import jdk.vm.ci.code.DebugInfo;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.code.site.Call;
import jdk.vm.ci.code.site.DataPatch;
import jdk.vm.ci.code.site.ExceptionHandler;
import jdk.vm.ci.code.site.Infopoint;
import jdk.vm.ci.code.site.InfopointReason;
import jdk.vm.ci.code.site.Reference;
import jdk.vm.ci.code.site.Site;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.InvokeTarget;
import jdk.vm.ci.meta.MetaUtil;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.collections.EconomicSet;
import org.graalvm.compiler.code.DataSection;
import org.graalvm.compiler.code.SourceMapping;
import org.graalvm.compiler.core.common.CompilationIdentifier;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.serviceprovider.GraalServices;

public class CompilationResult {
    private boolean closed;
    private int entryBCI = -1;
    private final DataSection dataSection = new DataSection();
    private final List<Infopoint> infopoints = new ArrayList<Infopoint>();
    private final List<SourceMapping> sourceMapping = new ArrayList<SourceMapping>();
    private final List<DataPatch> dataPatches = new ArrayList<DataPatch>();
    private final List<ExceptionHandler> exceptionHandlers = new ArrayList<ExceptionHandler>();
    private final List<CodeMark> marks = new ArrayList<CodeMark>();
    private int totalFrameSize = -1;
    private int maxInterpreterFrameSize = -1;
    private StackSlot customStackArea = null;
    private final String name;
    private final CompilationIdentifier compilationId;
    private byte[] targetCode;
    private int targetCodeSize;
    private ArrayList<CodeAnnotation> annotations;
    private Assumptions.Assumption[] assumptions;
    private ResolvedJavaMethod[] methods;
    private SpeculationLog speculationLog;
    private ResolvedJavaField[] fields;
    private int bytecodeSize;
    private boolean hasUnsafeAccess;
    private boolean isImmutablePIC;

    public CompilationResult(CompilationIdentifier compilationId) {
        this(compilationId, null, false);
    }

    public CompilationResult(CompilationIdentifier compilationId, String name) {
        this(compilationId, name, false);
    }

    public CompilationResult(CompilationIdentifier compilationId, boolean isImmutablePIC) {
        this(compilationId, null, isImmutablePIC);
    }

    public CompilationResult(CompilationIdentifier compilationId, String name, boolean isImmutablePIC) {
        this.compilationId = compilationId;
        this.name = name;
        this.isImmutablePIC = isImmutablePIC;
    }

    public CompilationResult(String name) {
        this(null, name);
    }

    public int hashCode() {
        throw new UnsupportedOperationException("hashCode");
    }

    public String toString() {
        if (this.methods != null) {
            return this.getClass().getName() + "[" + this.methods[0].format("%H.%n(%p)%r") + "]";
        }
        return MetaUtil.identityHashCodeString((Object)this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            CompilationResult that = (CompilationResult)obj;
            if (this.entryBCI == that.entryBCI && Objects.equals(this.customStackArea, that.customStackArea) && this.totalFrameSize == that.totalFrameSize && this.targetCodeSize == that.targetCodeSize && Objects.equals(this.name, that.name) && Objects.equals(this.compilationId, that.compilationId) && Objects.equals(this.annotations, that.annotations) && Objects.equals(this.dataSection, that.dataSection) && Objects.equals(this.exceptionHandlers, that.exceptionHandlers) && Objects.equals(this.dataPatches, that.dataPatches) && Objects.equals(this.infopoints, that.infopoints) && Objects.equals(this.marks, that.marks) && Arrays.equals(this.assumptions, that.assumptions) && Arrays.equals(this.targetCode, that.targetCode)) {
                return true;
            }
        }
        return false;
    }

    public int getEntryBCI() {
        return this.entryBCI;
    }

    public void setEntryBCI(int entryBCI) {
        this.checkOpen();
        this.entryBCI = entryBCI;
    }

    public void setAssumptions(Assumptions.Assumption[] assumptions) {
        this.assumptions = assumptions;
    }

    public Assumptions.Assumption[] getAssumptions() {
        return this.assumptions;
    }

    public void setMethods(ResolvedJavaMethod rootMethod, Collection<ResolvedJavaMethod> inlinedMethods) {
        this.checkOpen();
        assert (rootMethod != null);
        assert (inlinedMethods != null);
        EconomicSet methodSet = EconomicSet.create((int)inlinedMethods.size());
        methodSet.addAll(inlinedMethods);
        methodSet.remove((Object)rootMethod);
        this.methods = new ResolvedJavaMethod[1 + methodSet.size()];
        this.methods[0] = rootMethod;
        int i = 1;
        for (ResolvedJavaMethod m : methodSet) {
            this.methods[i++] = m;
        }
    }

    public ResolvedJavaMethod[] getMethods() {
        return this.methods;
    }

    public void setSpeculationLog(SpeculationLog speculationLog) {
        this.checkOpen();
        this.speculationLog = speculationLog;
    }

    public SpeculationLog getSpeculationLog() {
        return this.speculationLog;
    }

    public void setFields(EconomicSet<ResolvedJavaField> accessedFields) {
        if (accessedFields != null) {
            this.fields = (ResolvedJavaField[])accessedFields.toArray((Object[])new ResolvedJavaField[accessedFields.size()]);
        }
    }

    public ResolvedJavaField[] getFields() {
        return this.fields;
    }

    public void setBytecodeSize(int bytecodeSize) {
        this.checkOpen();
        this.bytecodeSize = bytecodeSize;
    }

    public int getBytecodeSize() {
        return this.bytecodeSize;
    }

    public DataSection getDataSection() {
        return this.dataSection;
    }

    public int getTotalFrameSize() {
        assert (this.totalFrameSize != -1) : "frame size not yet initialized!";
        return this.totalFrameSize;
    }

    public void setTotalFrameSize(int size) {
        this.checkOpen();
        this.totalFrameSize = size;
    }

    public int getMaxInterpreterFrameSize() {
        return this.maxInterpreterFrameSize;
    }

    public void setMaxInterpreterFrameSize(int maxInterpreterFrameSize) {
        this.checkOpen();
        this.maxInterpreterFrameSize = maxInterpreterFrameSize;
    }

    public boolean isImmutablePIC() {
        return this.isImmutablePIC;
    }

    public void setTargetCode(byte[] code, int size) {
        this.checkOpen();
        this.targetCode = code;
        this.targetCodeSize = size;
    }

    public void recordDataPatch(int codePos, Reference ref) {
        this.checkOpen();
        assert (codePos >= 0 && ref != null);
        this.dataPatches.add(new DataPatch(codePos, ref));
    }

    public void recordDataPatchWithNote(int codePos, Reference ref, Object note) {
        assert (codePos >= 0 && ref != null);
        this.dataPatches.add(new DataPatch(codePos, ref, note));
    }

    public Call recordCall(int codePos, int size, InvokeTarget target, DebugInfo debugInfo, boolean direct) {
        this.checkOpen();
        Call call = new Call(target, codePos, size, direct, debugInfo);
        this.addInfopoint((Infopoint)call);
        return call;
    }

    public void recordExceptionHandler(int codePos, int handlerPos) {
        this.checkOpen();
        assert (this.validateExceptionHandlerAdd(codePos, handlerPos)) : String.format("Duplicate exception handler for pc 0x%x handlerPos 0x%x", codePos, handlerPos);
        this.exceptionHandlers.add(new ExceptionHandler(codePos, handlerPos));
    }

    private boolean validateExceptionHandlerAdd(int codePos, int handlerPos) {
        ExceptionHandler exHandler = this.getExceptionHandlerForCodePos(codePos);
        return exHandler == null || exHandler.handlerPos == handlerPos;
    }

    private ExceptionHandler getExceptionHandlerForCodePos(int codePos) {
        for (ExceptionHandler h : this.exceptionHandlers) {
            if (h.pcOffset != codePos) continue;
            return h;
        }
        return null;
    }

    public void recordInfopoint(int codePos, DebugInfo debugInfo, InfopointReason reason) {
        this.addInfopoint(new Infopoint(codePos, debugInfo, reason));
    }

    public void recordImplicitException(int codePos, int dispatchPos, DebugInfo debugInfo) {
        this.addInfopoint(GraalServices.genImplicitException(codePos, dispatchPos, debugInfo));
    }

    public void addInfopoint(Infopoint infopoint) {
        this.checkOpen();
        this.infopoints.add(infopoint);
    }

    public void recordSourceMapping(int startOffset, int endOffset, NodeSourcePosition sourcePosition) {
        this.checkOpen();
        this.sourceMapping.add(new SourceMapping(startOffset, endOffset, sourcePosition));
    }

    public CodeMark recordMark(int codePos, MarkId markId) {
        this.checkOpen();
        CodeMark mark = new CodeMark(codePos, markId);
        this.marks.add(mark);
        return mark;
    }

    public StackSlot getCustomStackArea() {
        return this.customStackArea;
    }

    public void setCustomStackAreaOffset(StackSlot slot) {
        this.checkOpen();
        this.customStackArea = slot;
    }

    public byte[] getTargetCode() {
        return this.targetCode;
    }

    public int getTargetCodeSize() {
        return this.targetCodeSize;
    }

    public List<CodeAnnotation> getCodeAnnotations() {
        if (this.annotations == null) {
            return Collections.emptyList();
        }
        return this.annotations;
    }

    public void addAnnotation(CodeAnnotation annotation) {
        this.checkOpen();
        assert (annotation != null);
        if (this.annotations == null) {
            this.annotations = new ArrayList();
        }
        this.annotations.add(annotation);
    }

    public List<Infopoint> getInfopoints() {
        if (this.infopoints.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.infopoints);
    }

    public List<DataPatch> getDataPatches() {
        if (this.dataPatches.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.dataPatches);
    }

    public List<ExceptionHandler> getExceptionHandlers() {
        if (this.exceptionHandlers.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.exceptionHandlers);
    }

    public List<CodeMark> getMarks() {
        if (this.marks.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.marks);
    }

    public List<SourceMapping> getSourceMappings() {
        if (this.sourceMapping.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.sourceMapping);
    }

    public String getName() {
        return this.name;
    }

    public CompilationIdentifier getCompilationId() {
        return this.compilationId;
    }

    public void setHasUnsafeAccess(boolean hasUnsafeAccess) {
        this.checkOpen();
        this.hasUnsafeAccess = hasUnsafeAccess;
    }

    public boolean hasUnsafeAccess() {
        return this.hasUnsafeAccess;
    }

    public void resetForEmittingCode() {
        this.checkOpen();
        this.infopoints.clear();
        this.sourceMapping.clear();
        this.dataPatches.clear();
        this.exceptionHandlers.clear();
        this.marks.clear();
        this.dataSection.clear();
        if (this.annotations != null) {
            this.annotations.clear();
        }
    }

    public void clearInfopoints() {
        this.infopoints.clear();
    }

    public void clearExceptionHandlers() {
        this.exceptionHandlers.clear();
    }

    private void checkOpen() {
        if (this.closed) {
            throw new IllegalStateException();
        }
    }

    public void close(OptionValues options) {
        if (this.closed) {
            throw new IllegalStateException("Cannot re-close compilation result " + this);
        }
        this.dataSection.close(options);
        this.closed = true;
    }

    public static class CodeMark
    extends Site {
        public final MarkId id;

        public CodeMark(int pcOffset, MarkId id) {
            super(pcOffset);
            this.id = id;
            assert (id != null) : this;
        }

        public String toString() {
            return this.id + "@" + this.pcOffset;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof CodeMark) {
                CodeMark that = (CodeMark)((Object)obj);
                if (this.pcOffset == that.pcOffset && Objects.equals(this.id, that.id)) {
                    return true;
                }
            }
            return false;
        }
    }

    public static interface MarkId {
        public String getName();

        default public Object getId() {
            return this;
        }

        public boolean isMarkAfter();
    }

    public static final class JumpTable
    extends CodeAnnotation {
        public final int low;
        public final int high;
        public final int entrySize;

        public JumpTable(int position, int low, int high, int entrySize) {
            super(position);
            this.low = low;
            this.high = high;
            this.entrySize = entrySize;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof JumpTable) {
                JumpTable that = (JumpTable)obj;
                if (this.getPosition() == that.getPosition() && this.entrySize == that.entrySize && this.low == that.low && this.high == that.high) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName() + "@" + this.getPosition() + ": [" + this.low + " .. " + this.high + "]";
        }
    }

    public static final class CodeComment
    extends CodeAnnotation {
        public final String value;

        public CodeComment(int position, String comment) {
            super(position);
            this.value = comment;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof CodeComment) {
                CodeComment that = (CodeComment)obj;
                if (this.getPosition() == that.getPosition() && this.value.equals(that.value)) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName() + "@" + this.getPosition() + ": " + this.value;
        }
    }

    public static abstract class CodeAnnotation {
        private int position;

        public CodeAnnotation(int position) {
            this.position = position;
        }

        public final int hashCode() {
            throw new UnsupportedOperationException("hashCode");
        }

        public String toString() {
            return MetaUtil.identityHashCodeString((Object)this);
        }

        public abstract boolean equals(Object var1);

        public int getPosition() {
            return this.position;
        }

        void setPosition(int position) {
            this.position = position;
        }
    }
}

