/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.code;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.BiConsumer;
import jdk.vm.ci.code.site.DataSectionReference;
import jdk.vm.ci.meta.MetaUtil;
import jdk.vm.ci.meta.SerializableConstant;
import jdk.vm.ci.meta.VMConstant;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionType;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.serviceprovider.BufferUtil;

public final class DataSection
implements Iterable<Data> {
    private final ArrayList<Data> dataItems = new ArrayList();
    private boolean closed;
    private int sectionAlignment;
    private int sectionSize;

    public int hashCode() {
        throw new UnsupportedOperationException("hashCode");
    }

    public String toString() {
        return MetaUtil.identityHashCodeString((Object)this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DataSection) {
            DataSection that = (DataSection)obj;
            if (this.closed == that.closed && this.sectionAlignment == that.sectionAlignment && this.sectionSize == that.sectionSize && Objects.equals(this.dataItems, that.dataItems)) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSectionReference insertData(Data data) {
        this.checkOpen();
        Data data2 = data;
        synchronized (data2) {
            if (data.ref == null) {
                data.ref = new DataSectionReference();
                this.dataItems.add(data);
            }
            return data.ref;
        }
    }

    public void addAll(DataSection other) {
        this.checkOpen();
        other.checkOpen();
        for (Data data : other.dataItems) {
            assert (data.ref != null);
            this.dataItems.add(data);
        }
        other.dataItems.clear();
    }

    public boolean closed() {
        return this.closed;
    }

    public void close(OptionValues option) {
        this.checkOpen();
        this.closed = true;
        this.dataItems.sort((a, b) -> ((Data)a).alignment - ((Data)b).alignment);
        int position = 0;
        int alignment = 1;
        for (Data d : this.dataItems) {
            alignment = DataSection.lcm(alignment, d.alignment);
            position = DataSection.align(position, d.alignment);
            if (Options.ForceAdversarialLayout.getValue(option).booleanValue() && position % (d.alignment * 2) == 0) assert ((position += d.alignment) % d.alignment == 0);
            d.ref.setOffset(position);
            position += d.size;
        }
        this.sectionAlignment = alignment;
        this.sectionSize = position;
    }

    public int getSectionSize() {
        this.checkClosed();
        return this.sectionSize;
    }

    public int getSectionAlignment() {
        this.checkClosed();
        return this.sectionAlignment;
    }

    public void buildDataSection(ByteBuffer buffer, Patches patch) {
        this.buildDataSection(buffer, patch, (r, s) -> {});
    }

    public void buildDataSection(ByteBuffer buffer, Patches patch, BiConsumer<DataSectionReference, Integer> onEmit) {
        this.checkClosed();
        assert (buffer.remaining() >= this.sectionSize);
        int start = buffer.position();
        for (Data d : this.dataItems) {
            BufferUtil.asBaseBuffer(buffer).position(start + d.ref.getOffset());
            onEmit.accept(d.ref, d.getSize());
            d.emit(buffer, patch);
        }
        BufferUtil.asBaseBuffer(buffer).position(start + this.sectionSize);
    }

    public Data findData(DataSectionReference ref) {
        for (Data d : this.dataItems) {
            if (d.ref != ref) continue;
            return d;
        }
        return null;
    }

    public static void emit(ByteBuffer buffer, Data data, Patches patch) {
        data.emit(buffer, patch);
    }

    @Override
    public Iterator<Data> iterator() {
        return this.dataItems.iterator();
    }

    public static int lcm(int x, int y) {
        if (x == 0) {
            return y;
        }
        if (y == 0) {
            return x;
        }
        int a = Math.max(x, y);
        int b = Math.min(x, y);
        while (b > 0) {
            int tmp = a % b;
            a = b;
            b = tmp;
        }
        int gcd = a;
        return x * y / gcd;
    }

    private static int align(int position, int alignment) {
        return (position + alignment - 1) / alignment * alignment;
    }

    private void checkClosed() {
        if (!this.closed) {
            throw new IllegalStateException();
        }
    }

    private void checkOpen() {
        if (this.closed) {
            throw new IllegalStateException();
        }
    }

    public void clear() {
        this.checkOpen();
        this.dataItems.clear();
        this.sectionAlignment = 0;
        this.sectionSize = 0;
    }

    public static final class PackedData
    extends Data {
        private final Data[] nested;

        public PackedData(int alignment, int size, Data[] nested) {
            super(alignment, size);
            this.nested = nested;
        }

        @Override
        protected void emit(ByteBuffer buffer, Patches patches) {
            for (Data data : this.nested) {
                data.emit(buffer, patches);
            }
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + Arrays.hashCode(this.nested);
            return result;
        }

        @Override
        public String toString() {
            return "PackedData{alignment=" + this.getAlignment() + ", size=" + this.getSize() + ", nested=" + Arrays.toString(this.nested) + '}';
        }
    }

    public static class ZeroData
    extends Data {
        public ZeroData(int alignment, int size) {
            super(alignment, size);
        }

        @Override
        protected void emit(ByteBuffer buffer, Patches patches) {
            int rest;
            for (rest = this.getSize(); rest > 8; rest -= 8) {
                buffer.putLong(0L);
            }
            while (rest > 0) {
                buffer.put((byte)0);
                --rest;
            }
        }
    }

    public static final class SerializableData
    extends Data {
        private final SerializableConstant constant;

        public SerializableData(SerializableConstant constant, int alignment) {
            super(alignment, constant.getSerializedSize());
            this.constant = constant;
        }

        @Override
        protected void emit(ByteBuffer buffer, Patches patches) {
            int position = buffer.position();
            this.constant.serialize(buffer);
            assert (buffer.position() - position == this.constant.getSerializedSize()) : "wrong number of bytes written";
        }

        @Override
        public String toString() {
            return "SerializableData{alignment=" + this.getAlignment() + ", size=" + this.getSize() + ", constant=" + this.constant + '}';
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.constant);
        }
    }

    public static final class RawData
    extends Data {
        private final byte[] data;

        public RawData(byte[] data, int alignment) {
            super(alignment, data.length);
            this.data = data;
        }

        @Override
        protected void emit(ByteBuffer buffer, Patches patches) {
            buffer.put(this.data);
        }
    }

    public static abstract class Data {
        private int alignment;
        private final int size;
        private DataSectionReference ref;

        protected Data(int alignment, int size) {
            this.alignment = alignment;
            this.size = size;
            this.ref = null;
        }

        protected abstract void emit(ByteBuffer var1, Patches var2);

        public void updateAlignment(int newAlignment) {
            if (newAlignment == this.alignment) {
                return;
            }
            this.alignment = DataSection.lcm(this.alignment, newAlignment);
        }

        public int getAlignment() {
            return this.alignment;
        }

        public int getSize() {
            return this.size;
        }

        public int hashCode() {
            throw new UnsupportedOperationException("hashCode");
        }

        public String toString() {
            return MetaUtil.identityHashCodeString((Object)this);
        }

        public boolean equals(Object obj) {
            assert (this.ref != null);
            if (obj == this) {
                return true;
            }
            if (obj instanceof Data) {
                Data that = (Data)obj;
                if (this.alignment == that.alignment && this.size == that.size && this.ref.equals((Object)that.ref)) {
                    return true;
                }
            }
            return false;
        }
    }

    public static interface Patches {
        public void registerPatch(int var1, VMConstant var2);
    }

    static class Options {
        @Option(help={"Place N-byte constants in the data section such that they are misaligned with respect to N*2. For example, place 4 byte constants at offset 4, 12 or 20, etc. This layout is used to detect instructions that load constants with alignment smaller than the fetch size. For instance, an XORPS instruction that does a 16-byte fetch of a 4-byte float not aligned to 16 bytes will cause a segfault."}, type=OptionType.Debug)
        static final OptionKey<Boolean> ForceAdversarialLayout = new OptionKey<Boolean>(false);

        Options() {
        }
    }
}

