/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core;

import jdk.vm.ci.meta.JavaMethod;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.core.GraalCompilerOptions;
import org.graalvm.compiler.core.common.CompilationIdentifier;
import org.graalvm.compiler.core.common.spi.ForeignCallSignature;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.debug.TTY;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.serviceprovider.GraalServices;

public final class CompilationPrinter {
    private final CompilationIdentifier id;
    private final Object source;
    private final int entryBCI;
    private final long start;
    private final long allocatedBytesBefore;
    private static final CompilationPrinter DISABLED = new CompilationPrinter();

    public static CompilationPrinter begin(OptionValues options, CompilationIdentifier id, Object source, int entryBCI) {
        GraalError.guarantee(source instanceof JavaMethod || source instanceof ForeignCallSignature, "%s", source.getClass());
        if (GraalCompilerOptions.PrintCompilation.getValue(options).booleanValue() && !TTY.isSuppressed()) {
            return new CompilationPrinter(id, source, entryBCI);
        }
        return DISABLED;
    }

    private CompilationPrinter() {
        this.source = null;
        this.id = null;
        this.entryBCI = -1;
        this.start = -1L;
        this.allocatedBytesBefore = -1L;
    }

    private CompilationPrinter(CompilationIdentifier id, Object source, int entryBCI) {
        this.source = source;
        this.id = id;
        this.entryBCI = entryBCI;
        this.start = System.nanoTime();
        this.allocatedBytesBefore = GraalServices.isThreadAllocatedMemorySupported() ? GraalServices.getCurrentThreadAllocatedBytes() : -1L;
    }

    private String getMethodDescription() {
        if (this.source instanceof JavaMethod) {
            JavaMethod method = (JavaMethod)this.source;
            return String.format("%-30s %-70s %-45s %-50s %s", this.id.toString(CompilationIdentifier.Verbosity.ID), method.getDeclaringClass().getName(), method.getName(), method.getSignature().toMethodDescriptor(), this.entryBCI == -1 ? "" : "(OSR@" + this.entryBCI + ") ");
        }
        ForeignCallSignature sig = (ForeignCallSignature)this.source;
        return String.format("%-30s %-70s %-45s %-50s %s", this.id.toString(CompilationIdentifier.Verbosity.ID), "<stub>", sig.getName(), sig.toString(false), "");
    }

    public void finish(CompilationResult result) {
        if (this.id != null) {
            int bytecodeSize;
            long stop = System.nanoTime();
            long duration = (stop - this.start) / 1000L;
            int targetCodeSize = result != null ? result.getTargetCodeSize() : -1;
            int n = bytecodeSize = result != null ? result.getBytecodeSize() : 0;
            if (this.allocatedBytesBefore == -1L) {
                TTY.println(this.getMethodDescription() + String.format(" | %4dus %5dB bytecodes %5dB codesize", duration, bytecodeSize, targetCodeSize));
            } else {
                long allocatedBytesAfter = GraalServices.getCurrentThreadAllocatedBytes();
                long allocatedKBytes = (allocatedBytesAfter - this.allocatedBytesBefore) / 1024L;
                TTY.println(this.getMethodDescription() + String.format(" | %4dus %5dB bytecodes %5dB codesize %5dkB allocated", duration, bytecodeSize, targetCodeSize, allocatedKBytes));
            }
        }
    }
}

