/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.amd64;

import org.graalvm.compiler.core.common.memory.MemoryOrderMode;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.gc.WriteBarrier;
import org.graalvm.compiler.nodes.java.AbstractCompareAndSwapNode;
import org.graalvm.compiler.nodes.memory.AbstractWriteNode;
import org.graalvm.compiler.nodes.memory.MemoryAccess;
import org.graalvm.compiler.nodes.memory.OrderedMemoryAccess;
import org.graalvm.compiler.nodes.memory.VolatileWriteNode;
import org.graalvm.compiler.nodes.memory.WriteNode;
import org.graalvm.compiler.nodes.spi.LoweringProvider;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.replacements.amd64.AMD64ArrayIndexOfWithMaskNode;
import org.graalvm.compiler.replacements.amd64.AMD64ArrayRegionEqualsWithMaskNode;
import org.graalvm.compiler.replacements.amd64.AMD64TruffleArrayUtilsWithMaskSnippets;

public interface AMD64LoweringProviderMixin
extends LoweringProvider {
    @Override
    default public Integer smallestCompareWidth() {
        return 8;
    }

    @Override
    default public boolean supportsBulkZeroing() {
        return true;
    }

    default public boolean lowerAMD64(Node n, LoweringTool tool) {
        if (n instanceof AMD64ArrayIndexOfWithMaskNode) {
            tool.getReplacements().getSnippetTemplateCache(AMD64TruffleArrayUtilsWithMaskSnippets.Templates.class).lower((AMD64ArrayIndexOfWithMaskNode)n);
            return true;
        }
        if (n instanceof AMD64ArrayRegionEqualsWithMaskNode) {
            tool.getReplacements().getSnippetTemplateCache(AMD64TruffleArrayUtilsWithMaskSnippets.Templates.class).lower((AMD64ArrayRegionEqualsWithMaskNode)n);
            return true;
        }
        if (n instanceof VolatileWriteNode) {
            if (tool.getLoweringStage() != LoweringTool.StandardLoweringStage.LOW_TIER) {
                return false;
            }
            VolatileWriteNode write = (VolatileWriteNode)n;
            if (this.hasFollowingVolatileBarrier(write)) {
                StructuredGraph graph = write.graph();
                WriteNode add = graph.add(new WriteNode(write.getAddress(), write.getLocationIdentity(), write.value(), write.getBarrierType()));
                add.setLastLocationAccess(write.getLastLocationAccess());
                graph.replaceFixedWithFixed(write, add);
                return true;
            }
        }
        return false;
    }

    default public boolean hasFollowingVolatileBarrier(VolatileWriteNode n) {
        FixedWithNextNode cur = n;
        while (cur != null) {
            for (Node usage : cur.usages()) {
                if (usage instanceof MemoryAccess && usage instanceof FixedWithNextNode) continue;
                return false;
            }
            FixedNode next = cur.next();
            while (next instanceof WriteBarrier) {
                next = ((WriteBarrier)next).next();
            }
            if (next instanceof OrderedMemoryAccess) {
                if (next instanceof AbstractWriteNode || next instanceof AbstractCompareAndSwapNode) {
                    return ((OrderedMemoryAccess)((Object)next)).getMemoryOrder() == MemoryOrderMode.VOLATILE;
                }
                return false;
            }
            if (next instanceof WriteNode) {
                cur = (FixedWithNextNode)next;
                continue;
            }
            return false;
        }
        return false;
    }
}

