/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.common;

import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionStability;
import org.graalvm.compiler.options.OptionType;

public final class GraalOptions {
    @Option(help={"Use compiler intrinsifications."}, type=OptionType.Debug)
    public static final OptionKey<Boolean> Intrinsify = new OptionKey<Boolean>(true);
    @Option(help={"Rewrite signed comparisons to unsigned ones if the result is equal."}, type=OptionType.Debug)
    public static final OptionKey<Boolean> PreferUnsignedComparison = new OptionKey<Boolean>(true);
    @Option(help={"Inline calls with monomorphic type profile."}, type=OptionType.Expert)
    public static final OptionKey<Boolean> InlineMonomorphicCalls = new OptionKey<Boolean>(true);
    @Option(help={"Inline calls with polymorphic type profile."}, type=OptionType.Expert)
    public static final OptionKey<Boolean> InlinePolymorphicCalls = new OptionKey<Boolean>(true);
    @Option(help={"Inline calls with megamorphic type profile (i.e., not all types could be recorded)."}, type=OptionType.Expert)
    public static final OptionKey<Boolean> InlineMegamorphicCalls = new OptionKey<Boolean>(true);
    @Option(help={"Maximum desired size of the compiler graph in nodes."}, type=OptionType.User)
    public static final OptionKey<Integer> MaximumDesiredSize = new OptionKey<Integer>(20000);
    @Option(help={"Minimum probability for methods to be inlined for megamorphic type profiles."}, type=OptionType.Expert)
    public static final OptionKey<Double> MegamorphicInliningMinMethodProbability = new OptionKey<Double>(0.33);
    @Option(help={"Maximum level of recursive inlining."}, type=OptionType.Expert)
    public static final OptionKey<Integer> MaximumRecursiveInlining = new OptionKey<Integer>(5);
    @Option(help={"Graphs with less than this number of nodes are trivial and therefore always inlined."}, type=OptionType.Expert)
    public static final OptionKey<Integer> TrivialInliningSize = new OptionKey<Integer>(10);
    @Option(help={"Inlining is explored up to this number of nodes in the graph for each call site."}, type=OptionType.Expert)
    public static final OptionKey<Integer> MaximumInliningSize = new OptionKey<Integer>(300);
    @Option(help={"If the previous low-level graph size of the method exceeds the threshold, it is not inlined."}, type=OptionType.Expert)
    public static final OptionKey<Integer> SmallCompiledLowLevelGraphSize = new OptionKey<Integer>(330);
    @Option(help={""}, type=OptionType.Expert)
    public static final OptionKey<Double> LimitInlinedInvokes = new OptionKey<Double>(5.0);
    @Option(help={""}, type=OptionType.Expert)
    public static final OptionKey<Boolean> InlineEverything = new OptionKey<Boolean>(false);
    @Option(help={""}, type=OptionType.Debug)
    public static final OptionKey<Boolean> PartialEscapeAnalysis = new OptionKey<Boolean>(true);
    @Option(help={""}, type=OptionType.Debug)
    public static final OptionKey<Integer> EscapeAnalysisIterations = new OptionKey<Integer>(2);
    @Option(help={""}, type=OptionType.Debug)
    public static final OptionKey<Integer> EscapeAnalysisLoopCutoff = new OptionKey<Integer>(20);
    @Option(help={""}, type=OptionType.Debug)
    public static final OptionKey<String> EscapeAnalyzeOnly = new OptionKey<Object>(null);
    @Option(help={"The maximum length of an array that will be escape analyzed."}, type=OptionType.Expert)
    public static final OptionKey<Integer> MaximumEscapeAnalysisArrayLength = new OptionKey<Integer>(128);
    @Option(help={""}, type=OptionType.Expert)
    public static final OptionKey<Integer> DeoptsToDisableOptimisticOptimization = new OptionKey<Integer>(40);
    @Option(help={""}, type=OptionType.Debug)
    public static final OptionKey<Boolean> LoopPeeling = new OptionKey<Boolean>(true);
    @Option(help={"Re-associate loop invariants and constants."}, type=OptionType.Debug)
    public static final OptionKey<Boolean> ReassociateExpressions = new OptionKey<Boolean>(true);
    @Option(help={""}, type=OptionType.Debug)
    public static final OptionKey<Boolean> FullUnroll = new OptionKey<Boolean>(true);
    @Option(help={""}, type=OptionType.Debug)
    public static final OptionKey<Boolean> LoopUnswitch = new OptionKey<Boolean>(true);
    @Option(help={""}, type=OptionType.Debug)
    public static final OptionKey<Boolean> PartialUnroll = new OptionKey<Boolean>(true);
    @Option(help={""}, type=OptionType.Expert)
    public static final OptionKey<Float> MinimumPeelFrequency = new OptionKey<Float>(Float.valueOf(0.35f));
    @Option(help={""}, type=OptionType.Expert)
    public static final OptionKey<Integer> LoopMaxUnswitch = new OptionKey<Integer>(3);
    @Option(help={""}, type=OptionType.Debug)
    public static final OptionKey<Boolean> UseLoopLimitChecks = new OptionKey<Boolean>(true);
    @Option(help={"Hoists array bounds checks out of simple loops. This is ignored if SpeculativeGuardMovement is enabled."}, type=OptionType.Debug)
    public static final OptionKey<Boolean> LoopPredication = new OptionKey<Boolean>(true);
    @Option(help={"Restricts LoopPredication to only focus on array bounds checks that dominate the back edge of a loop."}, type=OptionType.Debug)
    public static final OptionKey<Boolean> LoopPredicationMainPath = new OptionKey<Boolean>(true);
    @Option(help={""}, type=OptionType.Debug)
    public static final OptionKey<Boolean> ZapStackOnMethodEntry = new OptionKey<Boolean>(false);
    @Option(help={""}, type=OptionType.Debug)
    public static final OptionKey<Boolean> DeoptALot = new OptionKey<Boolean>(false);
    @Option(help={"Stress the code emitting explicit exception throwing code."}, type=OptionType.Debug)
    public static final OptionKey<Boolean> StressExplicitExceptionCode = new OptionKey<Boolean>(false);
    @Option(help={"Stress the code emitting invokes with explicit exception edges."}, type=OptionType.Debug)
    public static final OptionKey<Boolean> StressInvokeWithExceptionNode = new OptionKey<Boolean>(false);
    @Option(help={"Stress the code by emitting reads at earliest instead of latest point."}, type=OptionType.Debug)
    public static final OptionKey<Boolean> StressTestEarlyReads = new OptionKey<Boolean>(false);
    @Option(help={""}, type=OptionType.Debug)
    public static final OptionKey<Boolean> VerifyPhases = new OptionKey<Boolean>(false);
    @Option(help={"Start tracing compiled GC barriers after N garbage collections (disabled if N <= 0)."}, type=OptionType.Debug)
    public static final OptionKey<Integer> GCDebugStartCycle = new OptionKey<Integer>(-1);
    @Option(help={"Perform platform dependent validation of the Java heap at returns"}, type=OptionType.Debug)
    public static final OptionKey<Boolean> VerifyHeapAtReturn = new OptionKey<Boolean>(false);
    @Option(help={"Print profiling information when parsing a method's bytecode"}, type=OptionType.Debug)
    public static final OptionKey<Boolean> PrintProfilingInformation = new OptionKey<Boolean>(false);
    @Option(help={""}, type=OptionType.Debug)
    public static final OptionKey<Boolean> TraceEscapeAnalysis = new OptionKey<Boolean>(false);
    @Option(help={"Print inlining optimizations"}, type=OptionType.Debug)
    public static final OptionKey<Boolean> HotSpotPrintInlining = new OptionKey<Boolean>(false);
    @Option(help={"Comma separated list of registers that register allocation is limited to."}, type=OptionType.Debug)
    public static final OptionKey<String> RegisterPressure = new OptionKey<Object>(null);
    @Option(help={""}, type=OptionType.Debug)
    public static final OptionKey<Boolean> ConditionalElimination = new OptionKey<Boolean>(true);
    @Option(help={""}, type=OptionType.Debug)
    public static final OptionKey<Integer> ConditionalEliminationMaxIterations = new OptionKey<Integer>(4);
    @Option(help={""}, type=OptionType.Debug)
    public static final OptionKey<Boolean> RawConditionalElimination = new OptionKey<Boolean>(true);
    @Option(help={""}, type=OptionType.Debug)
    public static final OptionKey<Boolean> ReplaceInputsWithConstantsBasedOnStamps = new OptionKey<Boolean>(true);
    @Option(help={""}, type=OptionType.Debug)
    public static final OptionKey<Boolean> RemoveNeverExecutedCode = new OptionKey<Boolean>(true);
    @Option(help={""}, type=OptionType.Debug)
    public static final OptionKey<Boolean> UseExceptionProbability = new OptionKey<Boolean>(true);
    @Option(help={""}, type=OptionType.Debug)
    public static final OptionKey<Boolean> OmitHotExceptionStacktrace = new OptionKey<Boolean>(false);
    @Option(help={""}, type=OptionType.Debug)
    public static final OptionKey<Boolean> GenLoopSafepoints = new OptionKey<Boolean>(true);
    @Option(help={""}, type=OptionType.Debug)
    public static final OptionKey<Boolean> UseTypeCheckHints = new OptionKey<Boolean>(true);
    @Option(help={""}, type=OptionType.Expert)
    public static final OptionKey<Boolean> InlineVTableStubs = new OptionKey<Boolean>(true);
    @Option(help={""}, type=OptionType.Expert)
    public static final OptionKey<Boolean> AlwaysInlineVTableStubs = new OptionKey<Boolean>(false);
    @Option(help={""}, type=OptionType.Debug)
    public static final OptionKey<Boolean> CanOmitFrame = new OptionKey<Boolean>(true);
    @Option(help={"Try to avoid emitting code where patching is required"}, type=OptionType.Expert)
    public static final OptionKey<Boolean> ImmutableCode = new OptionKey<Boolean>(false);
    @Option(help={"Generate position independent code"}, type=OptionType.Expert)
    public static final OptionKey<Boolean> GeneratePIC = new OptionKey<Boolean>(false);
    @Option(help={"Generate verify oop checks in AOT code"}, type=OptionType.Expert)
    public static final OptionKey<Boolean> AOTVerifyOops = new OptionKey<Boolean>(false);
    @Option(help={""}, type=OptionType.Expert)
    public static final OptionKey<Boolean> SupportJsrBytecodes = new OptionKey<Boolean>(true);
    @Option(help={""}, type=OptionType.Expert)
    public static final OptionKey<Boolean> OptAssumptions = new OptionKey<Boolean>(true);
    @Option(help={""}, type=OptionType.Debug)
    public static final OptionKey<Boolean> OptConvertDeoptsToGuards = new OptionKey<Boolean>(true);
    @Option(help={""}, type=OptionType.Debug)
    public static final OptionKey<Boolean> OptReadElimination = new OptionKey<Boolean>(true);
    @Option(help={""}, type=OptionType.Debug)
    public static final OptionKey<Integer> ReadEliminationMaxLoopVisits = new OptionKey<Integer>(5);
    @Option(help={""}, type=OptionType.Debug)
    public static final OptionKey<Boolean> OptDeoptimizationGrouping = new OptionKey<Boolean>(true);
    @Option(help={""}, type=OptionType.Debug)
    public static final OptionKey<Boolean> OptScheduleOutOfLoops = new OptionKey<Boolean>(true);
    @Option(help={""}, type=OptionType.Debug)
    public static final OptionKey<Boolean> GuardPriorities = new OptionKey<Boolean>(true);
    @Option(help={""}, type=OptionType.Debug)
    public static final OptionKey<Boolean> OptEliminateGuards = new OptionKey<Boolean>(true);
    @Option(help={""}, type=OptionType.Debug)
    public static final OptionKey<Boolean> OptImplicitNullChecks = new OptionKey<Boolean>(true);
    @Option(help={""}, type=OptionType.Debug)
    public static final OptionKey<Boolean> OptFloatingReads = new OptionKey<Boolean>(true);
    @Option(help={""}, type=OptionType.Debug)
    public static final OptionKey<Boolean> OptDevirtualizeInvokesOptimistically = new OptionKey<Boolean>(true);
    @Option(help={"Move loop invariant guards (e.g., array bounds checks) out of loops."}, type=OptionType.Debug)
    public static final OptionKey<Boolean> SpeculativeGuardMovement = new OptionKey<Boolean>(true);
    @Option(help={"Track the NodeSourcePosition."}, type=OptionType.Debug)
    public static final OptionKey<Boolean> TrackNodeSourcePosition = new OptionKey<Boolean>(false);
    @Option(help={"Track source stack trace where a node was inserted into the graph."}, type=OptionType.Debug)
    public static final OptionKey<Boolean> TrackNodeInsertion = new OptionKey<Boolean>(false);
    @Option(help={"Allow backend to match complex expressions."}, type=OptionType.Debug)
    public static final OptionKey<Boolean> MatchExpressions = new OptionKey<Boolean>(true);
    @Option(help={"Enable counters for various paths in snippets."}, type=OptionType.Debug)
    public static final OptionKey<Boolean> SnippetCounters = new OptionKey<Boolean>(false);
    @Option(help={"Eagerly construct extra snippet info."}, type=OptionType.Debug)
    public static final OptionKey<Boolean> EagerSnippets = new OptionKey<Boolean>(false);
    @Option(help={"Use a cache for snippet graphs."}, type=OptionType.Debug)
    public static final OptionKey<Boolean> UseSnippetGraphCache = new OptionKey<Boolean>(true);
    @Option(help={"file:doc-files/TraceInliningHelp.txt"}, type=OptionType.Debug, stability=OptionStability.STABLE)
    public static final OptionKey<Boolean> TraceInlining = new OptionKey<Boolean>(false);
    @Option(help={"Enable inlining decision tracing in stubs and snippets."}, type=OptionType.Debug)
    public static final OptionKey<Boolean> TraceInliningForStubsAndSnippets = new OptionKey<Boolean>(false);
    @Option(help={"Use Graal-generated stubs for complicated LIR operations instead of embedding all the emitted code."}, type=OptionType.Expert)
    public static final OptionKey<Boolean> UseGraalStubs = new OptionKey<Boolean>(true);
    @Option(help={"Encode and decode snippets and substitutions before parsing to test libgraal code path. This option is ignored in the context of libgraal."})
    public static final OptionKey<Boolean> UseEncodedGraphs = new OptionKey<Boolean>(false);
    @Option(help={"If applicable, use bulk zeroing instructions when the zeroing size in bytes exceeds this threshold."}, type=OptionType.Expert)
    public static final OptionKey<Integer> MinimalBulkZeroingSize = new OptionKey<Integer>(2048);
    @Option(help={"Alignment in bytes for loop header blocks."}, type=OptionType.Expert)
    public static final OptionKey<Integer> LoopHeaderAlignment = new OptionKey<Integer>(16);
    @Option(help={"String.indexOf invocations will be evaluated at compile time if the receiver is a constant and its length is lower than this value."}, type=OptionType.Expert)
    public static final OptionKey<Integer> StringIndexOfLimit = new OptionKey<Integer>(4096);
    @Option(help={"Emit substitutions for String methods"}, type=OptionType.Debug)
    public static final OptionKey<Boolean> EmitStringSubstitutions = new OptionKey<Boolean>(true);
    @Option(help={"Perform checks that guards and deopts aren't introduced in graphs that should handle exceptions explicitly"}, type=OptionType.Debug)
    public static final OptionKey<Boolean> StrictDeoptInsertionChecks = new OptionKey<Boolean>(false);
}

