/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.common.alloc;

import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterArray;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.meta.PlatformKind;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;

public class RegisterAllocationConfig {
    public static final String ALL_REGISTERS = "<all>";
    protected final RegisterConfig registerConfig;
    private final EconomicMap<PlatformKind.Key, AllocatableRegisters> categorized = EconomicMap.create((Equivalence)Equivalence.DEFAULT);
    private final String[] allocationRestrictedTo;
    private RegisterArray cachedRegisters;

    private static Register findRegister(String name, RegisterArray all) {
        for (Register reg : all) {
            if (!reg.name.equals(name)) continue;
            return reg;
        }
        throw new IllegalArgumentException("register " + name + " is not allocatable");
    }

    protected RegisterArray initAllocatable(RegisterArray registers) {
        if (this.allocationRestrictedTo != null) {
            Register[] regs = new Register[this.allocationRestrictedTo.length];
            for (int i = 0; i < this.allocationRestrictedTo.length; ++i) {
                regs[i] = RegisterAllocationConfig.findRegister(this.allocationRestrictedTo[i], registers);
            }
            return new RegisterArray(regs);
        }
        return registers;
    }

    public RegisterAllocationConfig(RegisterConfig registerConfig, String[] allocationRestrictedTo) {
        assert (registerConfig != null);
        this.registerConfig = registerConfig;
        this.allocationRestrictedTo = allocationRestrictedTo;
    }

    public AllocatableRegisters getAllocatableRegisters(PlatformKind kind) {
        PlatformKind.Key key = kind.getKey();
        if (this.categorized.containsKey((Object)key)) {
            AllocatableRegisters val = (AllocatableRegisters)this.categorized.get((Object)key);
            return val;
        }
        AllocatableRegisters ret = this.createAllocatableRegisters(this.registerConfig.filterAllocatableRegisters(kind, this.getAllocatableRegisters()));
        this.categorized.put((Object)key, (Object)ret);
        return ret;
    }

    public Register.RegisterCategory getRegisterCategory(PlatformKind kind) {
        return this.getAllocatableRegisters((PlatformKind)kind).allocatableRegisters[0].getRegisterCategory();
    }

    protected AllocatableRegisters createAllocatableRegisters(RegisterArray registers) {
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        for (Register reg : registers) {
            int number = reg.number;
            if (number < min) {
                min = number;
            }
            if (number <= max) continue;
            max = number;
        }
        assert (min < max);
        return new AllocatableRegisters(registers, min, max);
    }

    public RegisterArray getAllocatableRegisters() {
        if (this.cachedRegisters == null) {
            this.cachedRegisters = this.initAllocatable(this.registerConfig.getAllocatableRegisters());
        }
        assert (this.cachedRegisters != null);
        return this.cachedRegisters;
    }

    public RegisterConfig getRegisterConfig() {
        return this.registerConfig;
    }

    public static final class AllocatableRegisters {
        public final Register[] allocatableRegisters;
        public final int minRegisterNumber;
        public final int maxRegisterNumber;

        public AllocatableRegisters(RegisterArray allocatableRegisters, int minRegisterNumber, int maxRegisterNumber) {
            this.allocatableRegisters = allocatableRegisters.toArray();
            this.minRegisterNumber = minRegisterNumber;
            this.maxRegisterNumber = maxRegisterNumber;
            assert (AllocatableRegisters.verify(allocatableRegisters, minRegisterNumber, maxRegisterNumber));
        }

        private static boolean verify(RegisterArray allocatableRegisters, int minRegisterNumber, int maxRegisterNumber) {
            int min = Integer.MAX_VALUE;
            int max = Integer.MIN_VALUE;
            for (Register reg : allocatableRegisters) {
                int number = reg.number;
                if (number < min) {
                    min = number;
                }
                if (number <= max) continue;
                max = number;
            }
            assert (minRegisterNumber == min);
            assert (maxRegisterNumber == max);
            return true;
        }
    }
}

