/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.common.alloc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.graalvm.compiler.core.common.cfg.AbstractBlockBase;

public class Trace {
    private final AbstractBlockBase<?>[] blocks;
    private final ArrayList<Trace> successors;
    private int id = -1;

    public Trace(Collection<AbstractBlockBase<?>> blocks) {
        this(blocks.toArray(new AbstractBlockBase[0]));
    }

    public Trace(AbstractBlockBase<?>[] blocks) {
        this.blocks = blocks;
        this.successors = new ArrayList();
    }

    public AbstractBlockBase<?>[] getBlocks() {
        return this.blocks;
    }

    public ArrayList<Trace> getSuccessors() {
        return this.successors;
    }

    public int size() {
        return this.getBlocks().length;
    }

    public String toString() {
        return "Trace" + Arrays.toString(this.blocks);
    }

    public int getId() {
        assert (this.id != -1) : "id not initialized!";
        return this.id;
    }

    void setId(int id) {
        this.id = id;
    }
}

