/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.common.type;

import java.nio.ByteBuffer;
import java.util.Formatter;
import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MemoryAccessProvider;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.PrimitiveConstant;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.SerializableConstant;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.core.common.calc.FloatConvert;
import org.graalvm.compiler.core.common.calc.ReinterpretUtils;
import org.graalvm.compiler.core.common.spi.LIRKindTool;
import org.graalvm.compiler.core.common.type.ArithmeticOpTable;
import org.graalvm.compiler.core.common.type.FloatStamp;
import org.graalvm.compiler.core.common.type.PrimitiveStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.debug.GraalError;

public final class IntegerStamp
extends PrimitiveStamp {
    private final long lowerBound;
    private final long upperBound;
    private final long downMask;
    private final long upMask;
    public static final ArithmeticOpTable OPS = new ArithmeticOpTable(new ArithmeticOpTable.UnaryOp.Neg(){

        @Override
        public Constant foldConstant(Constant value) {
            PrimitiveConstant c = (PrimitiveConstant)value;
            return JavaConstant.forIntegerKind((JavaKind)c.getJavaKind(), (long)(-c.asLong()));
        }

        @Override
        public Stamp foldStamp(Stamp s) {
            if (s.isEmpty()) {
                return s;
            }
            IntegerStamp stamp = (IntegerStamp)s;
            int bits = stamp.getBits();
            if (stamp.lowerBound == stamp.upperBound) {
                long value = CodeUtil.convert((long)(-stamp.lowerBound()), (int)stamp.getBits(), (boolean)false);
                return StampFactory.forInteger(stamp.getBits(), value, value);
            }
            if (stamp.lowerBound() != CodeUtil.minValue((int)bits)) {
                return StampFactory.forInteger(bits, -stamp.upperBound(), -stamp.lowerBound());
            }
            return stamp.unrestricted();
        }
    }, new ArithmeticOpTable.BinaryOp.Add(true, true){

        @Override
        public Constant foldConstant(Constant const1, Constant const2) {
            PrimitiveConstant a = (PrimitiveConstant)const1;
            PrimitiveConstant b = (PrimitiveConstant)const2;
            assert (a.getJavaKind() == b.getJavaKind());
            return JavaConstant.forIntegerKind((JavaKind)a.getJavaKind(), (long)(a.asLong() + b.asLong()));
        }

        @Override
        public Stamp foldStamp(Stamp stamp1, Stamp stamp2) {
            long newUpperBound;
            long newLowerBound;
            if (stamp1.isEmpty()) {
                return stamp1;
            }
            if (stamp2.isEmpty()) {
                return stamp2;
            }
            IntegerStamp a = (IntegerStamp)stamp1;
            IntegerStamp b = (IntegerStamp)stamp2;
            int bits = a.getBits();
            assert (bits == b.getBits()) : String.format("stamp1.bits=%d, stamp2.bits=%d", bits, b.getBits());
            if (a.lowerBound == a.upperBound && b.lowerBound == b.upperBound) {
                long value = CodeUtil.convert((long)(a.lowerBound() + b.lowerBound()), (int)a.getBits(), (boolean)false);
                return StampFactory.forInteger(a.getBits(), value, value);
            }
            if (a.isUnrestricted()) {
                return a;
            }
            if (b.isUnrestricted()) {
                return b;
            }
            long defaultMask = CodeUtil.mask((int)bits);
            long variableBits = a.downMask() ^ a.upMask() | b.downMask() ^ b.upMask();
            long variableBitsWithCarry = variableBits | IntegerStamp.carryBits(a.downMask(), b.downMask()) ^ IntegerStamp.carryBits(a.upMask(), b.upMask());
            long newDownMask = a.downMask() + b.downMask() & (variableBitsWithCarry ^ 0xFFFFFFFFFFFFFFFFL);
            long newUpMask = a.downMask() + b.downMask() | variableBitsWithCarry;
            newDownMask &= defaultMask;
            newUpMask &= defaultMask;
            boolean lowerOverflowsPositively = IntegerStamp.addOverflowsPositively(a.lowerBound(), b.lowerBound(), bits);
            boolean upperOverflowsPositively = IntegerStamp.addOverflowsPositively(a.upperBound(), b.upperBound(), bits);
            boolean lowerOverflowsNegatively = IntegerStamp.addOverflowsNegatively(a.lowerBound(), b.lowerBound(), bits);
            boolean upperOverflowsNegatively = IntegerStamp.addOverflowsNegatively(a.upperBound(), b.upperBound(), bits);
            if (lowerOverflowsNegatively && !upperOverflowsNegatively || !lowerOverflowsPositively && upperOverflowsPositively) {
                newLowerBound = CodeUtil.minValue((int)bits);
                newUpperBound = CodeUtil.maxValue((int)bits);
            } else {
                newLowerBound = CodeUtil.signExtend((long)(a.lowerBound() + b.lowerBound() & defaultMask), (int)bits);
                newUpperBound = CodeUtil.signExtend((long)(a.upperBound() + b.upperBound() & defaultMask), (int)bits);
            }
            IntegerStamp limit = StampFactory.forInteger(bits, newLowerBound, newUpperBound);
            newUpperBound = CodeUtil.signExtend((long)(newUpperBound & (newUpMask &= limit.upMask())), (int)bits);
            return new IntegerStamp(bits, newLowerBound |= (newDownMask |= limit.downMask()), newUpperBound, newDownMask, newUpMask);
        }

        @Override
        public boolean isNeutral(Constant value) {
            PrimitiveConstant n = (PrimitiveConstant)value;
            return n.asLong() == 0L;
        }
    }, new ArithmeticOpTable.BinaryOp.Sub(true, false){

        @Override
        public Constant foldConstant(Constant const1, Constant const2) {
            PrimitiveConstant a = (PrimitiveConstant)const1;
            PrimitiveConstant b = (PrimitiveConstant)const2;
            assert (a.getJavaKind() == b.getJavaKind());
            return JavaConstant.forIntegerKind((JavaKind)a.getJavaKind(), (long)(a.asLong() - b.asLong()));
        }

        @Override
        public Stamp foldStamp(Stamp a, Stamp b) {
            return OPS.getAdd().foldStamp(a, OPS.getNeg().foldStamp(b));
        }

        @Override
        public boolean isNeutral(Constant value) {
            PrimitiveConstant n = (PrimitiveConstant)value;
            return n.asLong() == 0L;
        }

        @Override
        public Constant getZero(Stamp s) {
            IntegerStamp stamp = (IntegerStamp)s;
            return JavaConstant.forPrimitiveInt((int)stamp.getBits(), (long)0L);
        }
    }, new ArithmeticOpTable.BinaryOp.Mul(true, true){

        @Override
        public Constant foldConstant(Constant const1, Constant const2) {
            PrimitiveConstant a = (PrimitiveConstant)const1;
            PrimitiveConstant b = (PrimitiveConstant)const2;
            assert (a.getJavaKind() == b.getJavaKind());
            return JavaConstant.forIntegerKind((JavaKind)a.getJavaKind(), (long)(a.asLong() * b.asLong()));
        }

        @Override
        public Stamp foldStamp(Stamp stamp1, Stamp stamp2) {
            long minCandidate;
            long maxCandidate;
            if (stamp1.isEmpty()) {
                return stamp1;
            }
            if (stamp2.isEmpty()) {
                return stamp2;
            }
            IntegerStamp a = (IntegerStamp)stamp1;
            IntegerStamp b = (IntegerStamp)stamp2;
            int bits = a.getBits();
            assert (bits == b.getBits());
            if (a.lowerBound == a.upperBound && b.lowerBound == b.upperBound) {
                long value = CodeUtil.convert((long)(a.lowerBound() * b.lowerBound()), (int)a.getBits(), (boolean)false);
                return StampFactory.forInteger(a.getBits(), value, value);
            }
            if (a.upMask() == 0L) {
                return a;
            }
            if (b.upMask() == 0L) {
                return b;
            }
            if (a.isUnrestricted()) {
                return a;
            }
            if (b.isUnrestricted()) {
                return b;
            }
            long newLowerBound = Long.MAX_VALUE;
            long newUpperBound = Long.MIN_VALUE;
            long minNegA = a.lowerBound();
            long maxNegA = Math.min(0L, a.upperBound());
            long minPosA = Math.max(0L, a.lowerBound());
            long maxPosA = a.upperBound();
            long minNegB = b.lowerBound();
            long maxNegB = Math.min(0L, b.upperBound());
            long minPosB = Math.max(0L, b.lowerBound());
            long maxPosB = b.upperBound();
            long newUpMask = (CodeUtil.mask((int)Math.min(64, Long.numberOfTrailingZeros(a.upMask) + Long.numberOfTrailingZeros(b.upMask))) ^ 0xFFFFFFFFFFFFFFFFL) & CodeUtil.mask((int)bits);
            if (a.canBePositive()) {
                if (b.canBePositive()) {
                    if (IntegerStamp.multiplicationOverflows(maxPosA, maxPosB, bits)) {
                        return a.unrestricted();
                    }
                    maxCandidate = maxPosA * maxPosB;
                    if (IntegerStamp.multiplicationOverflows(minPosA, minPosB, bits)) {
                        return a.unrestricted();
                    }
                    minCandidate = minPosA * minPosB;
                    newLowerBound = Math.min(newLowerBound, minCandidate);
                    newUpperBound = Math.max(newUpperBound, maxCandidate);
                }
                if (b.canBeNegative()) {
                    if (IntegerStamp.multiplicationOverflows(minPosA, maxNegB, bits)) {
                        return a.unrestricted();
                    }
                    maxCandidate = minPosA * maxNegB;
                    if (IntegerStamp.multiplicationOverflows(maxPosA, minNegB, bits)) {
                        return a.unrestricted();
                    }
                    minCandidate = maxPosA * minNegB;
                    newLowerBound = Math.min(newLowerBound, minCandidate);
                    newUpperBound = Math.max(newUpperBound, maxCandidate);
                }
            }
            if (a.canBeNegative()) {
                if (b.canBePositive()) {
                    if (IntegerStamp.multiplicationOverflows(maxNegA, minPosB, bits)) {
                        return a.unrestricted();
                    }
                    maxCandidate = maxNegA * minPosB;
                    if (IntegerStamp.multiplicationOverflows(minNegA, maxPosB, bits)) {
                        return a.unrestricted();
                    }
                    minCandidate = minNegA * maxPosB;
                    newLowerBound = Math.min(newLowerBound, minCandidate);
                    newUpperBound = Math.max(newUpperBound, maxCandidate);
                }
                if (b.canBeNegative()) {
                    if (IntegerStamp.multiplicationOverflows(minNegA, minNegB, bits)) {
                        return a.unrestricted();
                    }
                    maxCandidate = minNegA * minNegB;
                    if (IntegerStamp.multiplicationOverflows(maxNegA, maxNegB, bits)) {
                        return a.unrestricted();
                    }
                    minCandidate = maxNegA * maxNegB;
                    newLowerBound = Math.min(newLowerBound, minCandidate);
                    newUpperBound = Math.max(newUpperBound, maxCandidate);
                }
            }
            assert (newLowerBound <= newUpperBound);
            return StampFactory.forIntegerWithMask(bits, newLowerBound, newUpperBound, 0L, newUpMask);
        }

        @Override
        public boolean isNeutral(Constant value) {
            PrimitiveConstant n = (PrimitiveConstant)value;
            return n.asLong() == 1L;
        }
    }, new ArithmeticOpTable.BinaryOp.MulHigh(true, true){

        @Override
        public Constant foldConstant(Constant const1, Constant const2) {
            PrimitiveConstant a = (PrimitiveConstant)const1;
            PrimitiveConstant b = (PrimitiveConstant)const2;
            assert (a.getJavaKind() == b.getJavaKind());
            return JavaConstant.forIntegerKind((JavaKind)a.getJavaKind(), (long)this.multiplyHigh(a.asLong(), b.asLong(), a.getJavaKind()));
        }

        @Override
        public Stamp foldStamp(Stamp stamp1, Stamp stamp2) {
            if (stamp1.isEmpty()) {
                return stamp1;
            }
            if (stamp2.isEmpty()) {
                return stamp2;
            }
            IntegerStamp a = (IntegerStamp)stamp1;
            IntegerStamp b = (IntegerStamp)stamp2;
            JavaKind javaKind = a.getStackKind();
            assert (a.getBits() == b.getBits());
            assert (javaKind == b.getStackKind());
            assert (javaKind == JavaKind.Int || javaKind == JavaKind.Long);
            if (a.isEmpty() || b.isEmpty()) {
                return a.empty();
            }
            if (a.isUnrestricted() || b.isUnrestricted()) {
                return a.unrestricted();
            }
            long[] xExtremes = new long[]{a.lowerBound(), a.upperBound()};
            long[] yExtremes = new long[]{b.lowerBound(), b.upperBound()};
            long min = Long.MAX_VALUE;
            long max = Long.MIN_VALUE;
            for (long x : xExtremes) {
                for (long y : yExtremes) {
                    long result = this.multiplyHigh(x, y, javaKind);
                    min = Math.min(min, result);
                    max = Math.max(max, result);
                }
            }
            return StampFactory.forInteger(javaKind, min, max);
        }

        @Override
        public boolean isNeutral(Constant value) {
            return false;
        }

        private long multiplyHigh(long x, long y, JavaKind javaKind) {
            if (javaKind == JavaKind.Int) {
                return x * y >> 32;
            }
            assert (javaKind == JavaKind.Long);
            long x0 = x & 0xFFFFFFFFL;
            long x1 = x >> 32;
            long y0 = y & 0xFFFFFFFFL;
            long y1 = y >> 32;
            long z0 = x0 * y0;
            long t = x1 * y0 + (z0 >>> 32);
            long z1 = t & 0xFFFFFFFFL;
            long z2 = t >> 32;
            return x1 * y1 + z2 + ((z1 += x0 * y1) >> 32);
        }
    }, new ArithmeticOpTable.BinaryOp.UMulHigh(true, true){

        @Override
        public Constant foldConstant(Constant const1, Constant const2) {
            PrimitiveConstant a = (PrimitiveConstant)const1;
            PrimitiveConstant b = (PrimitiveConstant)const2;
            assert (a.getJavaKind() == b.getJavaKind());
            return JavaConstant.forIntegerKind((JavaKind)a.getJavaKind(), (long)this.multiplyHighUnsigned(a.asLong(), b.asLong(), a.getJavaKind()));
        }

        @Override
        public Stamp foldStamp(Stamp stamp1, Stamp stamp2) {
            if (stamp1.isEmpty()) {
                return stamp1;
            }
            if (stamp2.isEmpty()) {
                return stamp2;
            }
            IntegerStamp a = (IntegerStamp)stamp1;
            IntegerStamp b = (IntegerStamp)stamp2;
            JavaKind javaKind = a.getStackKind();
            assert (a.getBits() == b.getBits());
            assert (javaKind == b.getStackKind());
            assert (javaKind == JavaKind.Int || javaKind == JavaKind.Long);
            if (a.isEmpty() || b.isEmpty()) {
                return a.empty();
            }
            if (a.isUnrestricted() || b.isUnrestricted()) {
                return a.unrestricted();
            }
            long[] xExtremes = this.getUnsignedExtremes(a);
            long[] yExtremes = this.getUnsignedExtremes(b);
            long min = Long.MAX_VALUE;
            long max = Long.MIN_VALUE;
            for (long x : xExtremes) {
                for (long y : yExtremes) {
                    long result = this.multiplyHighUnsigned(x, y, javaKind);
                    min = Math.min(min, result);
                    max = Math.max(max, result);
                }
            }
            if (min == max || min >= 0L) {
                return StampFactory.forInteger(javaKind, min, max);
            }
            return StampFactory.forKind(javaKind);
        }

        @Override
        public boolean isNeutral(Constant value) {
            return false;
        }

        private long[] getUnsignedExtremes(IntegerStamp stamp) {
            if (stamp.lowerBound() < 0L && stamp.upperBound() >= 0L) {
                return new long[]{0L, -1L};
            }
            return new long[]{stamp.lowerBound(), stamp.upperBound()};
        }

        private long multiplyHighUnsigned(long x, long y, JavaKind javaKind) {
            if (javaKind == JavaKind.Int) {
                long xl = x & 0xFFFFFFFFL;
                long yl = y & 0xFFFFFFFFL;
                long r = xl * yl;
                return (int)(r >>> 32);
            }
            assert (javaKind == JavaKind.Long);
            long x0 = x & 0xFFFFFFFFL;
            long x1 = x >>> 32;
            long y0 = y & 0xFFFFFFFFL;
            long y1 = y >>> 32;
            long z0 = x0 * y0;
            long t = x1 * y0 + (z0 >>> 32);
            long z1 = t & 0xFFFFFFFFL;
            long z2 = t >>> 32;
            return x1 * y1 + z2 + ((z1 += x0 * y1) >>> 32);
        }
    }, new ArithmeticOpTable.BinaryOp.Div(true, false){

        @Override
        public Constant foldConstant(Constant const1, Constant const2) {
            PrimitiveConstant a = (PrimitiveConstant)const1;
            PrimitiveConstant b = (PrimitiveConstant)const2;
            assert (a.getJavaKind() == b.getJavaKind());
            if (b.asLong() == 0L) {
                return null;
            }
            return JavaConstant.forIntegerKind((JavaKind)a.getJavaKind(), (long)(a.asLong() / b.asLong()));
        }

        @Override
        public Stamp foldStamp(Stamp stamp1, Stamp stamp2) {
            if (stamp1.isEmpty()) {
                return stamp1;
            }
            if (stamp2.isEmpty()) {
                return stamp2;
            }
            IntegerStamp a = (IntegerStamp)stamp1;
            IntegerStamp b = (IntegerStamp)stamp2;
            assert (a.getBits() == b.getBits());
            if (a.lowerBound == a.upperBound && b.lowerBound == b.upperBound && b.lowerBound != 0L) {
                long value = CodeUtil.convert((long)(a.lowerBound() / b.lowerBound()), (int)a.getBits(), (boolean)false);
                return StampFactory.forInteger(a.getBits(), value, value);
            }
            if (b.isStrictlyPositive()) {
                long newLowerBound = a.lowerBound() < 0L ? a.lowerBound() / b.lowerBound() : a.lowerBound() / b.upperBound();
                long newUpperBound = a.upperBound() < 0L ? a.upperBound() / b.upperBound() : a.upperBound() / b.lowerBound();
                return StampFactory.forInteger(a.getBits(), newLowerBound, newUpperBound);
            }
            return a.unrestricted();
        }

        @Override
        public boolean isNeutral(Constant value) {
            PrimitiveConstant n = (PrimitiveConstant)value;
            return n.asLong() == 1L;
        }
    }, new ArithmeticOpTable.BinaryOp.Rem(false, false){

        @Override
        public Constant foldConstant(Constant const1, Constant const2) {
            PrimitiveConstant a = (PrimitiveConstant)const1;
            PrimitiveConstant b = (PrimitiveConstant)const2;
            assert (a.getJavaKind() == b.getJavaKind());
            if (b.asLong() == 0L) {
                return null;
            }
            return JavaConstant.forIntegerKind((JavaKind)a.getJavaKind(), (long)(a.asLong() % b.asLong()));
        }

        @Override
        public Stamp foldStamp(Stamp stamp1, Stamp stamp2) {
            if (stamp1.isEmpty()) {
                return stamp1;
            }
            if (stamp2.isEmpty()) {
                return stamp2;
            }
            IntegerStamp a = (IntegerStamp)stamp1;
            IntegerStamp b = (IntegerStamp)stamp2;
            assert (a.getBits() == b.getBits());
            if (a.lowerBound == a.upperBound && b.lowerBound == b.upperBound && b.lowerBound != 0L) {
                long value = CodeUtil.convert((long)(a.lowerBound() % b.lowerBound()), (int)a.getBits(), (boolean)false);
                return StampFactory.forInteger(a.getBits(), value, value);
            }
            long newLowerBound = Math.min(a.lowerBound(), 0L);
            long newUpperBound = Math.max(a.upperBound(), 0L);
            long magnitude = b.lowerBound() == CodeUtil.minValue((int)b.getBits()) ? CodeUtil.maxValue((int)b.getBits()) : Math.max(Math.abs(b.lowerBound()), Math.abs(b.upperBound())) - 1L;
            newLowerBound = Math.max(newLowerBound, -magnitude);
            newUpperBound = Math.min(newUpperBound, magnitude);
            return StampFactory.forInteger(a.getBits(), newLowerBound, newUpperBound);
        }
    }, new ArithmeticOpTable.UnaryOp.Not(){

        @Override
        public Constant foldConstant(Constant c) {
            PrimitiveConstant value = (PrimitiveConstant)c;
            return JavaConstant.forIntegerKind((JavaKind)value.getJavaKind(), (long)(value.asLong() ^ 0xFFFFFFFFFFFFFFFFL));
        }

        @Override
        public Stamp foldStamp(Stamp stamp) {
            if (stamp.isEmpty()) {
                return stamp;
            }
            IntegerStamp integerStamp = (IntegerStamp)stamp;
            int bits = integerStamp.getBits();
            long defaultMask = CodeUtil.mask((int)bits);
            return new IntegerStamp(bits, integerStamp.upperBound() ^ 0xFFFFFFFFFFFFFFFFL, integerStamp.lowerBound() ^ 0xFFFFFFFFFFFFFFFFL, (integerStamp.upMask() ^ 0xFFFFFFFFFFFFFFFFL) & defaultMask, (integerStamp.downMask() ^ 0xFFFFFFFFFFFFFFFFL) & defaultMask);
        }
    }, new ArithmeticOpTable.BinaryOp.And(true, true){

        @Override
        public Constant foldConstant(Constant const1, Constant const2) {
            PrimitiveConstant a = (PrimitiveConstant)const1;
            PrimitiveConstant b = (PrimitiveConstant)const2;
            assert (a.getJavaKind() == b.getJavaKind());
            return JavaConstant.forIntegerKind((JavaKind)a.getJavaKind(), (long)(a.asLong() & b.asLong()));
        }

        @Override
        public Stamp foldStamp(Stamp stamp1, Stamp stamp2) {
            if (stamp1.isEmpty()) {
                return stamp1;
            }
            if (stamp2.isEmpty()) {
                return stamp2;
            }
            IntegerStamp a = (IntegerStamp)stamp1;
            IntegerStamp b = (IntegerStamp)stamp2;
            assert (a.getBits() == b.getBits());
            return IntegerStamp.stampForMask(a.getBits(), a.downMask() & b.downMask(), a.upMask() & b.upMask());
        }

        @Override
        public boolean isNeutral(Constant value) {
            PrimitiveConstant n = (PrimitiveConstant)value;
            int bits = n.getJavaKind().getBitCount();
            long mask = CodeUtil.mask((int)bits);
            return (n.asLong() & mask) == mask;
        }
    }, new ArithmeticOpTable.BinaryOp.Or(true, true){

        @Override
        public Constant foldConstant(Constant const1, Constant const2) {
            PrimitiveConstant a = (PrimitiveConstant)const1;
            PrimitiveConstant b = (PrimitiveConstant)const2;
            assert (a.getJavaKind() == b.getJavaKind());
            return JavaConstant.forIntegerKind((JavaKind)a.getJavaKind(), (long)(a.asLong() | b.asLong()));
        }

        @Override
        public Stamp foldStamp(Stamp stamp1, Stamp stamp2) {
            if (stamp1.isEmpty()) {
                return stamp1;
            }
            if (stamp2.isEmpty()) {
                return stamp2;
            }
            IntegerStamp a = (IntegerStamp)stamp1;
            IntegerStamp b = (IntegerStamp)stamp2;
            assert (a.getBits() == b.getBits());
            return IntegerStamp.stampForMask(a.getBits(), a.downMask() | b.downMask(), a.upMask() | b.upMask());
        }

        @Override
        public boolean isNeutral(Constant value) {
            PrimitiveConstant n = (PrimitiveConstant)value;
            return n.asLong() == 0L;
        }
    }, new ArithmeticOpTable.BinaryOp.Xor(true, true){

        @Override
        public Constant foldConstant(Constant const1, Constant const2) {
            PrimitiveConstant a = (PrimitiveConstant)const1;
            PrimitiveConstant b = (PrimitiveConstant)const2;
            assert (a.getJavaKind() == b.getJavaKind());
            return JavaConstant.forIntegerKind((JavaKind)a.getJavaKind(), (long)(a.asLong() ^ b.asLong()));
        }

        @Override
        public Stamp foldStamp(Stamp stamp1, Stamp stamp2) {
            if (stamp1.isEmpty()) {
                return stamp1;
            }
            if (stamp2.isEmpty()) {
                return stamp2;
            }
            IntegerStamp a = (IntegerStamp)stamp1;
            IntegerStamp b = (IntegerStamp)stamp2;
            assert (a.getBits() == b.getBits());
            long variableBits = a.downMask() ^ a.upMask() | b.downMask() ^ b.upMask();
            long newDownMask = (a.downMask() ^ b.downMask()) & (variableBits ^ 0xFFFFFFFFFFFFFFFFL);
            long newUpMask = a.downMask() ^ b.downMask() | variableBits;
            return IntegerStamp.stampForMask(a.getBits(), newDownMask, newUpMask);
        }

        @Override
        public boolean isNeutral(Constant value) {
            PrimitiveConstant n = (PrimitiveConstant)value;
            return n.asLong() == 0L;
        }

        @Override
        public Constant getZero(Stamp s) {
            IntegerStamp stamp = (IntegerStamp)s;
            return JavaConstant.forPrimitiveInt((int)stamp.getBits(), (long)0L);
        }
    }, new ArithmeticOpTable.ShiftOp.Shl(){

        @Override
        public Constant foldConstant(Constant value, int amount) {
            PrimitiveConstant c = (PrimitiveConstant)value;
            switch (c.getJavaKind()) {
                case Short: {
                    return JavaConstant.forShort((short)((short)(c.asLong() << amount)));
                }
                case Int: {
                    return JavaConstant.forInt((int)(c.asInt() << amount));
                }
                case Long: {
                    return JavaConstant.forLong((long)(c.asLong() << amount));
                }
            }
            throw GraalError.shouldNotReachHere();
        }

        private boolean testNoSignChangeAfterShifting(int bits, long value, int shiftAmount) {
            long removedBits = -1L << bits - shiftAmount - 1;
            if (value < 0L) {
                return (value & removedBits) == removedBits;
            }
            return (value & removedBits) == 0L;
        }

        @Override
        public Stamp foldStamp(Stamp stamp, IntegerStamp shift) {
            IntegerStamp value = (IntegerStamp)stamp;
            int bits = value.getBits();
            if (value.isEmpty()) {
                return value;
            }
            if (shift.isEmpty()) {
                return StampFactory.forInteger(bits).empty();
            }
            if (value.upMask() == 0L) {
                return value;
            }
            int shiftMask = this.getShiftAmountMask(stamp);
            int shiftBits = Integer.bitCount(shiftMask);
            if (shift.lowerBound() == shift.upperBound()) {
                int shiftAmount = (int)(shift.lowerBound() & (long)shiftMask);
                if (shiftAmount == 0) {
                    return value;
                }
                if (shiftAmount >= bits) {
                    IntegerStamp result = IntegerStamp.create(bits, 0L, 0L, 0L, 0L);
                    return result;
                }
                if (this.testNoSignChangeAfterShifting(bits, value.lowerBound(), shiftAmount) && this.testNoSignChangeAfterShifting(bits, value.upperBound(), shiftAmount)) {
                    IntegerStamp result = new IntegerStamp(bits, value.lowerBound() << shiftAmount, value.upperBound() << shiftAmount, value.downMask() << shiftAmount & CodeUtil.mask((int)bits), value.upMask() << shiftAmount & CodeUtil.mask((int)bits));
                    return result;
                }
            }
            if (shift.lowerBound() >>> shiftBits == shift.upperBound() >>> shiftBits) {
                long defaultMask;
                long downMask = defaultMask = CodeUtil.mask((int)bits);
                long upMask = 0L;
                for (long i = shift.lowerBound(); i <= shift.upperBound(); ++i) {
                    if (!shift.contains(i)) continue;
                    downMask &= value.downMask() << (int)(i & (long)shiftMask);
                    upMask |= value.upMask() << (int)(i & (long)shiftMask);
                }
                return IntegerStamp.stampForMask(bits, downMask, upMask & defaultMask);
            }
            return value.unrestricted();
        }

        @Override
        public int getShiftAmountMask(Stamp s) {
            IntegerStamp stamp = (IntegerStamp)s;
            assert (CodeUtil.isPowerOf2((int)stamp.getBits()));
            return stamp.getBits() - 1;
        }
    }, new ArithmeticOpTable.ShiftOp.Shr(){

        @Override
        public Constant foldConstant(Constant value, int amount) {
            PrimitiveConstant c = (PrimitiveConstant)value;
            switch (c.getJavaKind()) {
                case Short: {
                    return JavaConstant.forShort((short)((short)(c.asLong() >> amount)));
                }
                case Int: {
                    return JavaConstant.forInt((int)(c.asInt() >> amount));
                }
                case Long: {
                    return JavaConstant.forLong((long)(c.asLong() >> amount));
                }
            }
            throw GraalError.shouldNotReachHere();
        }

        @Override
        public Stamp foldStamp(Stamp stamp, IntegerStamp shift) {
            IntegerStamp value = (IntegerStamp)stamp;
            int bits = value.getBits();
            if (value.isEmpty()) {
                return value;
            }
            if (shift.isEmpty()) {
                return StampFactory.forInteger(bits).empty();
            }
            if (shift.lowerBound() == shift.upperBound()) {
                long shiftCount = shift.lowerBound() & (long)this.getShiftAmountMask(stamp);
                if (shiftCount == 0L) {
                    return stamp;
                }
                int extraBits = 64 - bits;
                long defaultMask = CodeUtil.mask((int)bits);
                long downMask = value.downMask() << extraBits >> (int)(shiftCount + (long)extraBits) & defaultMask;
                long upMask = value.upMask() << extraBits >> (int)(shiftCount + (long)extraBits) & defaultMask;
                return new IntegerStamp(bits, value.lowerBound() >> (int)shiftCount, value.upperBound() >> (int)shiftCount, downMask, upMask);
            }
            long mask = IntegerStamp.upMaskFor(bits, value.lowerBound(), value.upperBound());
            return IntegerStamp.stampForMask(bits, 0L, mask);
        }

        @Override
        public int getShiftAmountMask(Stamp s) {
            IntegerStamp stamp = (IntegerStamp)s;
            assert (CodeUtil.isPowerOf2((int)stamp.getBits()));
            return stamp.getBits() - 1;
        }
    }, new ArithmeticOpTable.ShiftOp.UShr(){

        @Override
        public Constant foldConstant(Constant value, int amount) {
            PrimitiveConstant c = (PrimitiveConstant)value;
            switch (c.getJavaKind()) {
                case Int: {
                    return JavaConstant.forInt((int)(c.asInt() >>> amount));
                }
                case Long: {
                    return JavaConstant.forLong((long)(c.asLong() >>> amount));
                }
            }
            throw GraalError.shouldNotReachHere();
        }

        @Override
        public Stamp foldStamp(Stamp stamp, IntegerStamp shift) {
            IntegerStamp value = (IntegerStamp)stamp;
            int bits = value.getBits();
            if (value.isEmpty()) {
                return value;
            }
            if (shift.isEmpty()) {
                return StampFactory.forInteger(bits).empty();
            }
            if (shift.lowerBound() == shift.upperBound()) {
                long shiftCount = shift.lowerBound() & (long)this.getShiftAmountMask(stamp);
                if (shiftCount == 0L) {
                    return stamp;
                }
                long downMask = value.downMask() >>> (int)shiftCount;
                long upMask = value.upMask() >>> (int)shiftCount;
                if (value.lowerBound() < 0L) {
                    return new IntegerStamp(bits, downMask, upMask, downMask, upMask);
                }
                return new IntegerStamp(bits, value.lowerBound() >>> (int)shiftCount, value.upperBound() >>> (int)shiftCount, downMask, upMask);
            }
            long mask = IntegerStamp.upMaskFor(bits, value.lowerBound(), value.upperBound());
            return IntegerStamp.stampForMask(bits, 0L, mask);
        }

        @Override
        public int getShiftAmountMask(Stamp s) {
            IntegerStamp stamp = (IntegerStamp)s;
            assert (CodeUtil.isPowerOf2((int)stamp.getBits()));
            return stamp.getBits() - 1;
        }
    }, new ArithmeticOpTable.UnaryOp.Abs(){

        @Override
        public Constant foldConstant(Constant value) {
            PrimitiveConstant c = (PrimitiveConstant)value;
            return JavaConstant.forIntegerKind((JavaKind)c.getJavaKind(), (long)Math.abs(c.asLong()));
        }

        @Override
        public Stamp foldStamp(Stamp input) {
            if (input.isEmpty()) {
                return input;
            }
            IntegerStamp stamp = (IntegerStamp)input;
            int bits = stamp.getBits();
            if (stamp.lowerBound == stamp.upperBound) {
                long value = CodeUtil.convert((long)Math.abs(stamp.lowerBound()), (int)stamp.getBits(), (boolean)false);
                return StampFactory.forInteger(stamp.getBits(), value, value);
            }
            if (stamp.lowerBound() == CodeUtil.minValue((int)bits)) {
                return input.unrestricted();
            }
            long limit = Math.max(-stamp.lowerBound(), stamp.upperBound());
            return StampFactory.forInteger(bits, 0L, limit);
        }
    }, null, new ArithmeticOpTable.IntegerConvertOp.ZeroExtend(){

        @Override
        public Constant foldConstant(int inputBits, int resultBits, Constant c) {
            PrimitiveConstant value = (PrimitiveConstant)c;
            return JavaConstant.forPrimitiveInt((int)resultBits, (long)CodeUtil.zeroExtend((long)value.asLong(), (int)inputBits));
        }

        @Override
        public Stamp foldStamp(int inputBits, int resultBits, Stamp input) {
            if (input.isEmpty()) {
                return StampFactory.forInteger(resultBits).empty();
            }
            IntegerStamp stamp = (IntegerStamp)input;
            assert (inputBits == stamp.getBits()) : "Input bits" + inputBits + " stamp bits " + stamp.getBits() + " result bits " + resultBits;
            assert (inputBits <= resultBits);
            if (inputBits == resultBits) {
                return input;
            }
            if (input.isEmpty()) {
                return StampFactory.forInteger(resultBits).empty();
            }
            long downMask = CodeUtil.zeroExtend((long)stamp.downMask(), (int)inputBits);
            long upMask = CodeUtil.zeroExtend((long)stamp.upMask(), (int)inputBits);
            long lowerBound = stamp.unsignedLowerBound();
            long upperBound = stamp.unsignedUpperBound();
            return IntegerStamp.create(resultBits, lowerBound, upperBound, downMask, upMask);
        }

        @Override
        public Stamp invertStamp(int inputBits, int resultBits, Stamp outStamp) {
            IntegerStamp stamp = (IntegerStamp)outStamp;
            if (stamp.isEmpty()) {
                return StampFactory.forInteger(inputBits).empty();
            }
            long mustBeSetOutputBits = stamp.downMask();
            long mustBeSetExtensionBits = mustBeSetOutputBits >>> inputBits;
            if (mustBeSetExtensionBits != 0L) {
                return IntegerStamp.createEmptyStamp(inputBits);
            }
            long lowerBound = Math.max(stamp.lowerBound(), 0L);
            assert (stamp.upperBound() >= 0L) : "Cannot invert ZeroExtend for stamp with msb=1, which implies a negative value after ZeroExtend!";
            return StampFactory.forUnsignedInteger(inputBits, lowerBound, stamp.upperBound(), stamp.downMask(), stamp.upMask());
        }
    }, new ArithmeticOpTable.IntegerConvertOp.SignExtend(){

        @Override
        public Constant foldConstant(int inputBits, int resultBits, Constant c) {
            PrimitiveConstant value = (PrimitiveConstant)c;
            return JavaConstant.forPrimitiveInt((int)resultBits, (long)CodeUtil.signExtend((long)value.asLong(), (int)inputBits));
        }

        @Override
        public Stamp foldStamp(int inputBits, int resultBits, Stamp input) {
            if (input.isEmpty()) {
                return StampFactory.forInteger(resultBits).empty();
            }
            IntegerStamp stamp = (IntegerStamp)input;
            assert (inputBits == stamp.getBits());
            assert (inputBits <= resultBits);
            long defaultMask = CodeUtil.mask((int)resultBits);
            long downMask = CodeUtil.signExtend((long)stamp.downMask(), (int)inputBits) & defaultMask;
            long upMask = CodeUtil.signExtend((long)stamp.upMask(), (int)inputBits) & defaultMask;
            return new IntegerStamp(resultBits, stamp.lowerBound(), stamp.upperBound(), downMask, upMask);
        }

        @Override
        public Stamp invertStamp(int inputBits, int resultBits, Stamp outStamp) {
            boolean inputMSBZero;
            long extensionMask;
            IntegerStamp stamp = (IntegerStamp)outStamp;
            if (stamp.isEmpty()) {
                return StampFactory.forInteger(inputBits).empty();
            }
            long mustBeSetExtensionBits = stamp.downMask() >>> inputBits;
            long mayBeSetExtensionBits = stamp.upMask() >>> inputBits;
            boolean zeroInExtension = mayBeSetExtensionBits != (extensionMask = CodeUtil.mask((int)stamp.getBits()) >>> inputBits);
            boolean oneInExtension = mustBeSetExtensionBits != 0L;
            boolean inputMSBOne = IntegerStamp.significantBit(inputBits, stamp.downMask()) == 1L;
            boolean bl = inputMSBZero = IntegerStamp.significantBit(inputBits, stamp.upMask()) == 0L;
            if (zeroInExtension && oneInExtension || inputMSBOne && zeroInExtension || inputMSBZero && oneInExtension) {
                return IntegerStamp.createEmptyStamp(inputBits);
            }
            long inputMask = CodeUtil.mask((int)inputBits);
            long inputMustBeSet = stamp.downMask() & inputMask;
            long inputMayBeSet = stamp.upMask() & inputMask;
            if (!inputMSBOne && !inputMSBZero) {
                if (zeroInExtension) {
                    long msbZeroMask = ~(1 << inputBits - 1);
                    inputMustBeSet &= msbZeroMask;
                    inputMayBeSet &= msbZeroMask;
                } else if (oneInExtension) {
                    long msbOneMask = 1 << inputBits - 1;
                    inputMustBeSet |= msbOneMask;
                    inputMayBeSet |= msbOneMask;
                }
            }
            long inputUpperBound = IntegerStamp.maxValueForMasks(inputBits, inputMustBeSet, inputMayBeSet);
            long inputLowerBound = IntegerStamp.minValueForMasks(inputBits, inputMustBeSet, inputMayBeSet);
            if (stamp.upperBound() < inputLowerBound || stamp.lowerBound() > inputUpperBound) {
                return IntegerStamp.createEmptyStamp(inputBits);
            }
            inputUpperBound = Math.min(inputUpperBound, stamp.upperBound());
            inputLowerBound = Math.max(inputLowerBound, stamp.lowerBound());
            return StampFactory.forIntegerWithMask(inputBits, inputLowerBound, inputUpperBound, inputMustBeSet, inputMayBeSet);
        }
    }, new ArithmeticOpTable.IntegerConvertOp.Narrow(){

        @Override
        public Constant foldConstant(int inputBits, int resultBits, Constant c) {
            PrimitiveConstant value = (PrimitiveConstant)c;
            return JavaConstant.forPrimitiveInt((int)resultBits, (long)CodeUtil.narrow((long)value.asLong(), (int)resultBits));
        }

        @Override
        public Stamp foldStamp(int inputBits, int resultBits, Stamp input) {
            if (input.isEmpty()) {
                return StampFactory.forInteger(resultBits).empty();
            }
            IntegerStamp stamp = (IntegerStamp)input;
            assert (inputBits == stamp.getBits());
            assert (resultBits <= inputBits);
            if (resultBits == inputBits) {
                return stamp;
            }
            long upperBound = stamp.lowerBound() < CodeUtil.minValue((int)resultBits) ? CodeUtil.maxValue((int)resultBits) : IntegerStamp.saturate(stamp.upperBound(), resultBits);
            long lowerBound = stamp.upperBound() > CodeUtil.maxValue((int)resultBits) ? CodeUtil.minValue((int)resultBits) : IntegerStamp.saturate(stamp.lowerBound(), resultBits);
            long defaultMask = CodeUtil.mask((int)resultBits);
            long newDownMask = stamp.downMask() & defaultMask;
            long newUpMask = stamp.upMask() & defaultMask;
            long newLowerBound = CodeUtil.signExtend((long)((lowerBound | newDownMask) & newUpMask), (int)resultBits);
            long newUpperBound = CodeUtil.signExtend((long)((upperBound | newDownMask) & newUpMask), (int)resultBits);
            IntegerStamp result = new IntegerStamp(resultBits, newLowerBound, newUpperBound, newDownMask, newUpMask);
            assert (result.hasValues());
            return result;
        }
    }, null, null, new ArithmeticOpTable.ReinterpretOp(){

        @Override
        public Constant foldConstant(Stamp resultStamp, Constant constant) {
            return ReinterpretUtils.foldConstant(resultStamp, constant);
        }

        @Override
        public Stamp foldStamp(Stamp resultStamp, Stamp input) {
            if (input.isEmpty()) {
                return resultStamp.empty();
            }
            if (resultStamp instanceof FloatStamp && input instanceof IntegerStamp) {
                return ReinterpretUtils.intToFloat((IntegerStamp)input);
            }
            return resultStamp;
        }
    }, new ArithmeticOpTable.FloatConvertOp(FloatConvert.I2F){

        @Override
        public Constant foldConstant(Constant c) {
            PrimitiveConstant value = (PrimitiveConstant)c;
            return JavaConstant.forFloat((float)value.asInt());
        }

        @Override
        public Stamp foldStamp(Stamp input) {
            if (input.isEmpty()) {
                return StampFactory.empty(JavaKind.Float);
            }
            IntegerStamp stamp = (IntegerStamp)input;
            assert (stamp.getBits() == 32);
            float lowerBound = stamp.lowerBound();
            float upperBound = stamp.upperBound();
            return StampFactory.forFloat(JavaKind.Float, lowerBound, upperBound, true);
        }
    }, new ArithmeticOpTable.FloatConvertOp(FloatConvert.L2F){

        @Override
        public Constant foldConstant(Constant c) {
            PrimitiveConstant value = (PrimitiveConstant)c;
            return JavaConstant.forFloat((float)value.asLong());
        }

        @Override
        public Stamp foldStamp(Stamp input) {
            if (input.isEmpty()) {
                return StampFactory.empty(JavaKind.Float);
            }
            IntegerStamp stamp = (IntegerStamp)input;
            assert (stamp.getBits() == 64);
            float lowerBound = stamp.lowerBound();
            float upperBound = stamp.upperBound();
            return StampFactory.forFloat(JavaKind.Float, lowerBound, upperBound, true);
        }
    }, new ArithmeticOpTable.FloatConvertOp(FloatConvert.I2D){

        @Override
        public Constant foldConstant(Constant c) {
            PrimitiveConstant value = (PrimitiveConstant)c;
            return JavaConstant.forDouble((double)value.asInt());
        }

        @Override
        public Stamp foldStamp(Stamp input) {
            if (input.isEmpty()) {
                return StampFactory.empty(JavaKind.Double);
            }
            IntegerStamp stamp = (IntegerStamp)input;
            assert (stamp.getBits() == 32);
            double lowerBound = stamp.lowerBound();
            double upperBound = stamp.upperBound();
            return StampFactory.forFloat(JavaKind.Double, lowerBound, upperBound, true);
        }
    }, new ArithmeticOpTable.FloatConvertOp(FloatConvert.L2D){

        @Override
        public Constant foldConstant(Constant c) {
            PrimitiveConstant value = (PrimitiveConstant)c;
            return JavaConstant.forDouble((double)value.asLong());
        }

        @Override
        public Stamp foldStamp(Stamp input) {
            if (input.isEmpty()) {
                return StampFactory.empty(JavaKind.Double);
            }
            IntegerStamp stamp = (IntegerStamp)input;
            assert (stamp.getBits() == 64);
            double lowerBound = stamp.lowerBound();
            double upperBound = stamp.upperBound();
            return StampFactory.forFloat(JavaKind.Double, lowerBound, upperBound, true);
        }
    });

    private IntegerStamp(int bits, long lowerBound, long upperBound, long downMask, long upMask) {
        super(bits, OPS);
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.downMask = downMask;
        this.upMask = upMask;
        assert (lowerBound >= CodeUtil.minValue((int)bits)) : this;
        assert (upperBound <= CodeUtil.maxValue((int)bits)) : this;
        assert ((downMask & CodeUtil.mask((int)bits)) == downMask) : this;
        assert ((upMask & CodeUtil.mask((int)bits)) == upMask) : this;
    }

    public static IntegerStamp create(int bits, long lowerBoundInput, long upperBoundInput) {
        return IntegerStamp.create(bits, lowerBoundInput, upperBoundInput, 0L, CodeUtil.mask((int)bits));
    }

    public static IntegerStamp create(int bits, long lowerBoundInput, long upperBoundInput, long downMask, long upMask) {
        long boundedUpMask;
        long boundedDownMask;
        if (lowerBoundInput > upperBoundInput || (downMask & (upMask ^ 0xFFFFFFFFFFFFFFFFL)) != 0L || upMask == 0L && (lowerBoundInput > 0L || upperBoundInput < 0L)) {
            return IntegerStamp.createEmptyStamp(bits);
        }
        assert ((downMask & (upMask ^ 0xFFFFFFFFFFFFFFFFL)) == 0L) : String.format("\u21ca: %016x \u21c8: %016x", downMask, upMask);
        long minValue = IntegerStamp.minValueForMasks(bits, downMask, upMask);
        long lowerBoundTmp = Math.max(lowerBoundInput, minValue);
        long maxValue = IntegerStamp.maxValueForMasks(bits, downMask, upMask);
        long upperBoundTmp = Math.min(upperBoundInput, maxValue);
        long defaultMask = CodeUtil.mask((int)bits);
        if (lowerBoundTmp == upperBoundTmp) {
            boundedDownMask = lowerBoundTmp;
            boundedUpMask = lowerBoundTmp;
        } else if (lowerBoundTmp >= 0L) {
            int upperBoundLeadingZeros = Long.numberOfLeadingZeros(upperBoundTmp);
            long differentBits = lowerBoundTmp ^ upperBoundTmp;
            int sameBitCount = Long.numberOfLeadingZeros(differentBits << upperBoundLeadingZeros);
            boundedUpMask = upperBoundTmp | -1L >>> upperBoundLeadingZeros + sameBitCount;
            boundedDownMask = upperBoundTmp & (-1L >>> upperBoundLeadingZeros + sameBitCount ^ 0xFFFFFFFFFFFFFFFFL);
        } else if (upperBoundTmp >= 0L) {
            boundedUpMask = defaultMask;
            boundedDownMask = 0L;
        } else {
            int lowerBoundLeadingOnes = Long.numberOfLeadingZeros(lowerBoundTmp ^ 0xFFFFFFFFFFFFFFFFL);
            long differentBits = lowerBoundTmp ^ upperBoundTmp;
            int sameBitCount = Long.numberOfLeadingZeros(differentBits << lowerBoundLeadingOnes);
            boundedUpMask = lowerBoundTmp | -1L >>> lowerBoundLeadingOnes + sameBitCount | -1L >>> lowerBoundLeadingOnes ^ 0xFFFFFFFFFFFFFFFFL;
            boundedDownMask = lowerBoundTmp & (-1L >>> lowerBoundLeadingOnes + sameBitCount ^ 0xFFFFFFFFFFFFFFFFL) | -1L >>> lowerBoundLeadingOnes ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return new IntegerStamp(bits, lowerBoundTmp, upperBoundTmp, defaultMask & (downMask | boundedDownMask), defaultMask & upMask & boundedUpMask);
    }

    private static long significantBit(long bits, long value) {
        return value >>> (int)(bits - 1L) & 1L;
    }

    private static long minValueForMasks(int bits, long downMask, long upMask) {
        if (IntegerStamp.significantBit(bits, upMask) == 0L) {
            assert (IntegerStamp.significantBit(bits, downMask) == 0L);
            return downMask;
        }
        return downMask | -1L << bits - 1;
    }

    private static long maxValueForMasks(int bits, long downMask, long upMask) {
        if (IntegerStamp.significantBit(bits, downMask) == 1L) {
            assert (IntegerStamp.significantBit(bits, upMask) == 1L);
            return CodeUtil.signExtend((long)upMask, (int)bits);
        }
        return upMask & CodeUtil.mask((int)bits) >>> 1;
    }

    public static IntegerStamp stampForMask(int bits, long downMask, long upMask) {
        return new IntegerStamp(bits, IntegerStamp.minValueForMasks(bits, downMask, upMask), IntegerStamp.maxValueForMasks(bits, downMask, upMask), downMask, upMask);
    }

    @Override
    public IntegerStamp unrestricted() {
        return new IntegerStamp(this.getBits(), CodeUtil.minValue((int)this.getBits()), CodeUtil.maxValue((int)this.getBits()), 0L, CodeUtil.mask((int)this.getBits()));
    }

    @Override
    public IntegerStamp empty() {
        return new IntegerStamp(this.getBits(), CodeUtil.maxValue((int)this.getBits()), CodeUtil.minValue((int)this.getBits()), CodeUtil.mask((int)this.getBits()), 0L);
    }

    static IntegerStamp createEmptyStamp(int bits) {
        return new IntegerStamp(bits, CodeUtil.maxValue((int)bits), CodeUtil.minValue((int)bits), CodeUtil.mask((int)bits), 0L);
    }

    @Override
    public Stamp constant(Constant c, MetaAccessProvider meta) {
        if (c instanceof PrimitiveConstant) {
            PrimitiveConstant primitiveConstant = (PrimitiveConstant)c;
            long value = primitiveConstant.asLong();
            if (primitiveConstant.getJavaKind() == JavaKind.Boolean && value == 1L) {
                value = -1L;
            }
            IntegerStamp returnedStamp = StampFactory.forInteger(this.getBits(), value, value);
            assert (((Stamp)returnedStamp).hasValues());
            return returnedStamp;
        }
        return this;
    }

    @Override
    public SerializableConstant deserialize(ByteBuffer buffer) {
        switch (this.getBits()) {
            case 1: {
                return JavaConstant.forBoolean((buffer.get() != 0 ? 1 : 0) != 0);
            }
            case 8: {
                return JavaConstant.forByte((byte)buffer.get());
            }
            case 16: {
                return JavaConstant.forShort((short)buffer.getShort());
            }
            case 32: {
                return JavaConstant.forInt((int)buffer.getInt());
            }
            case 64: {
                return JavaConstant.forLong((long)buffer.getLong());
            }
        }
        throw GraalError.shouldNotReachHere();
    }

    @Override
    public boolean hasValues() {
        return this.lowerBound <= this.upperBound;
    }

    @Override
    public JavaKind getStackKind() {
        if (this.getBits() > 32) {
            return JavaKind.Long;
        }
        return JavaKind.Int;
    }

    @Override
    public LIRKind getLIRKind(LIRKindTool tool) {
        return tool.getIntegerKind(this.getBits());
    }

    @Override
    public ResolvedJavaType javaType(MetaAccessProvider metaAccess) {
        switch (this.getBits()) {
            case 1: {
                return metaAccess.lookupJavaType(Boolean.TYPE);
            }
            case 8: {
                return metaAccess.lookupJavaType(Byte.TYPE);
            }
            case 16: {
                return metaAccess.lookupJavaType(Short.TYPE);
            }
            case 32: {
                return metaAccess.lookupJavaType(Integer.TYPE);
            }
            case 64: {
                return metaAccess.lookupJavaType(Long.TYPE);
            }
        }
        throw GraalError.shouldNotReachHere();
    }

    @Override
    public Constant readConstant(MemoryAccessProvider provider, Constant base, long displacement, Stamp accessStamp) {
        PrimitiveStamp primitiveAccess = (PrimitiveStamp)accessStamp;
        int accessBits = primitiveAccess.getBits();
        GraalError.guarantee(this.getBits() >= ((PrimitiveStamp)accessStamp).getBits(), "access size should be less than or equal the result");
        JavaConstant constant = super.readJavaConstant(provider, base, displacement, accessBits);
        if (constant == null) {
            return null;
        }
        if (constant.getJavaKind().getBitCount() != accessBits) {
            constant = this.canBeNegative() ? JavaConstant.forPrimitiveInt((int)this.getBits(), (long)CodeUtil.signExtend((long)constant.asLong(), (int)accessBits)) : JavaConstant.forPrimitiveInt((int)this.getBits(), (long)CodeUtil.zeroExtend((long)constant.asLong(), (int)accessBits));
        }
        return constant;
    }

    public long lowerBound() {
        return this.lowerBound;
    }

    public long upperBound() {
        return this.upperBound;
    }

    public long downMask() {
        return this.downMask;
    }

    public long upMask() {
        return this.upMask;
    }

    @Override
    public boolean isUnrestricted() {
        return this.lowerBound == CodeUtil.minValue((int)this.getBits()) && this.upperBound == CodeUtil.maxValue((int)this.getBits()) && this.downMask == 0L && this.upMask == CodeUtil.mask((int)this.getBits());
    }

    public boolean contains(long value) {
        return value >= this.lowerBound && value <= this.upperBound && (value & this.downMask) == this.downMask && (value & this.upMask) == (value & CodeUtil.mask((int)this.getBits()));
    }

    public boolean isPositive() {
        return this.lowerBound() >= 0L;
    }

    public boolean isNegative() {
        return this.upperBound() <= 0L;
    }

    public boolean isStrictlyPositive() {
        return this.lowerBound() > 0L;
    }

    public boolean isStrictlyNegative() {
        return this.upperBound() < 0L;
    }

    public boolean canBePositive() {
        return this.upperBound() > 0L;
    }

    public boolean canBeNegative() {
        return this.lowerBound() < 0L;
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append('i');
        str.append(this.getBits());
        if (this.hasValues()) {
            if (this.lowerBound == this.upperBound) {
                str.append(" [").append(this.lowerBound).append(']');
            } else if (this.lowerBound != CodeUtil.minValue((int)this.getBits()) || this.upperBound != CodeUtil.maxValue((int)this.getBits())) {
                str.append(" [").append(this.lowerBound).append(" - ").append(this.upperBound).append(']');
            }
            if (this.downMask != 0L) {
                str.append(" \u21ca");
                new Formatter(str).format("%016x", this.downMask);
            }
            if (this.upMask != CodeUtil.mask((int)this.getBits())) {
                str.append(" \u21c8");
                new Formatter(str).format("%016x", this.upMask);
            }
        } else {
            str.append("<empty>");
        }
        return str.toString();
    }

    private IntegerStamp createStamp(IntegerStamp other, long newUpperBound, long newLowerBound, long newDownMask, long newUpMask) {
        assert (this.getBits() == other.getBits());
        if (newLowerBound > newUpperBound || (newDownMask & (newUpMask ^ 0xFFFFFFFFFFFFFFFFL)) != 0L || newUpMask == 0L && (newLowerBound > 0L || newUpperBound < 0L)) {
            return this.empty();
        }
        if (newLowerBound == this.lowerBound && newUpperBound == this.upperBound && newDownMask == this.downMask && newUpMask == this.upMask) {
            return this;
        }
        if (newLowerBound == other.lowerBound && newUpperBound == other.upperBound && newDownMask == other.downMask && newUpMask == other.upMask) {
            return other;
        }
        return IntegerStamp.create(this.getBits(), newLowerBound, newUpperBound, newDownMask, newUpMask);
    }

    @Override
    public Stamp meet(Stamp otherStamp) {
        if (otherStamp == this) {
            return this;
        }
        if (this.isEmpty()) {
            return otherStamp;
        }
        if (otherStamp.isEmpty()) {
            return this;
        }
        IntegerStamp other = (IntegerStamp)otherStamp;
        return this.createStamp(other, Math.max(this.upperBound, other.upperBound), Math.min(this.lowerBound, other.lowerBound), this.downMask & other.downMask, this.upMask | other.upMask);
    }

    @Override
    public IntegerStamp join(Stamp otherStamp) {
        if (otherStamp == this) {
            return this;
        }
        IntegerStamp other = (IntegerStamp)otherStamp;
        long newDownMask = this.downMask | other.downMask;
        long newLowerBound = Math.max(this.lowerBound, other.lowerBound);
        long newUpperBound = Math.min(this.upperBound, other.upperBound);
        long newUpMask = this.upMask & other.upMask;
        return this.createStamp(other, newUpperBound, newLowerBound, newDownMask, newUpMask);
    }

    @Override
    public boolean isCompatible(Stamp stamp) {
        if (this == stamp) {
            return true;
        }
        if (stamp instanceof IntegerStamp) {
            IntegerStamp other = (IntegerStamp)stamp;
            return this.getBits() == other.getBits();
        }
        return false;
    }

    @Override
    public boolean isCompatible(Constant constant) {
        if (constant instanceof PrimitiveConstant) {
            PrimitiveConstant prim = (PrimitiveConstant)constant;
            JavaKind kind = prim.getJavaKind();
            return kind.isNumericInteger() && kind.getBitCount() == this.getBits();
        }
        return false;
    }

    public long unsignedUpperBound() {
        if (this.sameSignBounds()) {
            return CodeUtil.zeroExtend((long)this.upperBound(), (int)this.getBits());
        }
        return NumUtil.maxValueUnsigned(this.getBits());
    }

    public long unsignedLowerBound() {
        if (this.sameSignBounds()) {
            return CodeUtil.zeroExtend((long)this.lowerBound(), (int)this.getBits());
        }
        return 0L;
    }

    private boolean sameSignBounds() {
        return NumUtil.sameSign(this.lowerBound, this.upperBound);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + super.hashCode();
        result = 31 * result + (int)(this.lowerBound ^ this.lowerBound >>> 32);
        result = 31 * result + (int)(this.upperBound ^ this.upperBound >>> 32);
        result = 31 * result + (int)(this.downMask ^ this.downMask >>> 32);
        result = 31 * result + (int)(this.upMask ^ this.upMask >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass() || !super.equals(obj)) {
            return false;
        }
        IntegerStamp other = (IntegerStamp)obj;
        if (this.lowerBound != other.lowerBound || this.upperBound != other.upperBound || this.downMask != other.downMask || this.upMask != other.upMask) {
            return false;
        }
        return super.equals(other);
    }

    private static long upMaskFor(int bits, long lowerBound, long upperBound) {
        long mask = lowerBound | upperBound;
        if (mask == 0L) {
            return 0L;
        }
        return -1L >>> Long.numberOfLeadingZeros(mask) & CodeUtil.mask((int)bits);
    }

    public static boolean sameSign(IntegerStamp s1, IntegerStamp s2) {
        return s1.isPositive() && s2.isPositive() || s1.isStrictlyNegative() && s2.isStrictlyNegative();
    }

    public JavaConstant asConstant() {
        if (this.lowerBound == this.upperBound) {
            switch (this.getBits()) {
                case 1: {
                    return JavaConstant.forBoolean((this.lowerBound != 0L ? 1 : 0) != 0);
                }
                case 8: {
                    return JavaConstant.forByte((byte)((byte)this.lowerBound));
                }
                case 16: {
                    return JavaConstant.forShort((short)((short)this.lowerBound));
                }
                case 32: {
                    return JavaConstant.forInt((int)((int)this.lowerBound));
                }
                case 64: {
                    return JavaConstant.forLong((long)this.lowerBound);
                }
            }
        }
        return null;
    }

    public static boolean addCanOverflow(IntegerStamp a, IntegerStamp b) {
        assert (a.getBits() == b.getBits());
        return IntegerStamp.addOverflowsPositively(a.upperBound(), b.upperBound(), a.getBits()) || IntegerStamp.addOverflowsNegatively(a.lowerBound(), b.lowerBound(), a.getBits());
    }

    public static boolean addOverflowsPositively(long x, long y, int bits) {
        long result = x + y;
        if (bits == 64) {
            return ((x ^ 0xFFFFFFFFFFFFFFFFL) & (y ^ 0xFFFFFFFFFFFFFFFFL) & result) < 0L;
        }
        return result > CodeUtil.maxValue((int)bits);
    }

    public static boolean addOverflowsNegatively(long x, long y, int bits) {
        long result = x + y;
        if (bits == 64) {
            return (x & y & (result ^ 0xFFFFFFFFFFFFFFFFL)) < 0L;
        }
        return result < CodeUtil.minValue((int)bits);
    }

    public static long carryBits(long x, long y) {
        return x + y ^ x ^ y;
    }

    private static long saturate(long v, int bits) {
        if (bits < 64) {
            long max = CodeUtil.maxValue((int)bits);
            if (v > max) {
                return max;
            }
            long min = CodeUtil.minValue((int)bits);
            if (v < min) {
                return min;
            }
        }
        return v;
    }

    public static boolean multiplicationOverflows(long a, long b, int bits) {
        boolean positive;
        assert (bits <= 64 && bits >= 0);
        long result = a * b;
        boolean bl = positive = a >= 0L && b >= 0L || a < 0L && b < 0L;
        if (bits == 64) {
            if (a > 0L && b > 0L) {
                return a > Long.MAX_VALUE / b;
            }
            if (a > 0L && b <= 0L) {
                return b < Long.MIN_VALUE / a;
            }
            if (a <= 0L && b > 0L) {
                return a < Long.MIN_VALUE / b;
            }
            return a != 0L && b < Long.MAX_VALUE / a;
        }
        if (positive) {
            return result > CodeUtil.maxValue((int)bits);
        }
        return result < CodeUtil.minValue((int)bits);
    }

    public static boolean multiplicationCanOverflow(IntegerStamp a, IntegerStamp b) {
        assert (a.getBits() == b.getBits());
        if (a.upMask() == 0L) {
            return false;
        }
        if (b.upMask() == 0L) {
            return false;
        }
        if (a.isUnrestricted()) {
            return true;
        }
        if (b.isUnrestricted()) {
            return true;
        }
        int bits = a.getBits();
        long minNegA = a.lowerBound();
        long maxNegA = Math.min(0L, a.upperBound());
        long minPosA = Math.max(0L, a.lowerBound());
        long maxPosA = a.upperBound();
        long minNegB = b.lowerBound();
        long maxNegB = Math.min(0L, b.upperBound());
        long minPosB = Math.max(0L, b.lowerBound());
        long maxPosB = b.upperBound();
        boolean mayOverflow = false;
        if (a.canBePositive()) {
            if (b.canBePositive()) {
                mayOverflow |= IntegerStamp.multiplicationOverflows(maxPosA, maxPosB, bits);
                mayOverflow |= IntegerStamp.multiplicationOverflows(minPosA, minPosB, bits);
            }
            if (b.canBeNegative()) {
                mayOverflow |= IntegerStamp.multiplicationOverflows(minPosA, maxNegB, bits);
                mayOverflow |= IntegerStamp.multiplicationOverflows(maxPosA, minNegB, bits);
            }
        }
        if (a.canBeNegative()) {
            if (b.canBePositive()) {
                mayOverflow |= IntegerStamp.multiplicationOverflows(maxNegA, minPosB, bits);
                mayOverflow |= IntegerStamp.multiplicationOverflows(minNegA, maxPosB, bits);
            }
            if (b.canBeNegative()) {
                mayOverflow |= IntegerStamp.multiplicationOverflows(minNegA, minNegB, bits);
                mayOverflow |= IntegerStamp.multiplicationOverflows(maxNegA, maxNegB, bits);
            }
        }
        return mayOverflow;
    }

    public static boolean subtractionCanOverflow(IntegerStamp x, IntegerStamp y) {
        assert (x.getBits() == y.getBits());
        return IntegerStamp.subtractionOverflows(x.lowerBound(), y.upperBound(), x.getBits()) || IntegerStamp.subtractionOverflows(x.upperBound(), y.lowerBound(), x.getBits());
    }

    public static boolean subtractionOverflows(long x, long y, int bits) {
        long result = x - y;
        if (bits == 64) {
            return ((x ^ y) & (x ^ result)) < 0L;
        }
        return result < CodeUtil.minValue((int)bits) || result > CodeUtil.maxValue((int)bits);
    }
}

