/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.common.util;

public class TypeConversion {
    public static boolean isS1(long value) {
        return value >= -128L && value <= 127L;
    }

    public static boolean isU1(long value) {
        return value >= 0L && value <= 255L;
    }

    public static boolean isS2(long value) {
        return value >= -32768L && value <= 32767L;
    }

    public static boolean isU2(long value) {
        return value >= 0L && value <= 65535L;
    }

    public static boolean isS4(long value) {
        return value >= Integer.MIN_VALUE && value <= Integer.MAX_VALUE;
    }

    public static boolean isU4(long value) {
        return value >= 0L && value <= 0xFFFFFFFFL;
    }

    public static byte asS1(long value) {
        assert (TypeConversion.isS1(value));
        return (byte)value;
    }

    public static byte asU1(long value) {
        assert (TypeConversion.isU1(value));
        return (byte)value;
    }

    public static short asS2(long value) {
        assert (TypeConversion.isS2(value));
        return (short)value;
    }

    public static short asU2(long value) {
        assert (TypeConversion.isU2(value));
        return (short)value;
    }

    public static int asS4(long value) {
        assert (TypeConversion.isS4(value));
        return (int)value;
    }

    public static int asU4(long value) {
        assert (TypeConversion.isU4(value));
        return (int)value;
    }
}

