/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.phases;

import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.Graph;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.LogicConstantNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.PhaseSuite;
import org.graalvm.compiler.phases.common.util.EconomicSetNodeEventListener;

public class GraphChangeMonitoringPhase<C extends CoreProviders>
extends PhaseSuite<C> {
    private final String message;

    public GraphChangeMonitoringPhase(String message, BasePhase<C> phase) {
        this.message = message;
        this.appendPhase(phase);
    }

    public GraphChangeMonitoringPhase(String message) {
        this.message = message;
    }

    @Override
    protected void run(StructuredGraph graph, C context) {
        block55: {
            EconomicSetNodeEventListener listener = new EconomicSetNodeEventListener().exclude(Graph.NodeEvent.NODE_ADDED);
            StructuredGraph graphCopy = (StructuredGraph)graph.copy(graph.getDebug());
            DebugContext debug = graph.getDebug();
            Graph.NodeEventScope s = graphCopy.trackNodeEvents(listener);
            Object object = null;
            try {
                try (DebugContext.Scope s2 = debug.sandbox("WithoutMonitoring", null, new Object[0]);){
                    super.run(graphCopy, context);
                }
                catch (Throwable t) {
                    debug.handle(t);
                }
            }
            catch (Throwable t) {
                object = t;
                throw t;
            }
            finally {
                if (s != null) {
                    if (object != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable t) {
                            ((Throwable)object).addSuppressed(t);
                        }
                    } else {
                        s.close();
                    }
                }
            }
            EconomicSet filteredNodes = EconomicSet.create((Equivalence)Equivalence.IDENTITY);
            for (Node n : listener.getNodes()) {
                if (n instanceof LogicConstantNode) continue;
                filteredNodes.add((Object)n);
            }
            if (!filteredNodes.isEmpty()) {
                listener = new EconomicSetNodeEventListener();
                try (Graph.NodeEventScope s2 = graph.trackNodeEvents(listener);
                     DebugContext.Scope s22 = debug.scope("WithGraphChangeMonitoring");){
                    if (debug.isDumpEnabled(4)) {
                        debug.dump(4, (Object)graph, "*** Before phase %s", this.getName());
                    }
                    super.run(graph, context);
                    if (debug.isDumpEnabled(4)) {
                        debug.dump(4, graph, "*** After phase %s %s", this.getName(), filteredNodes);
                    }
                    debug.log("*** %s %s %s\n", (Object)this.message, (Object)graph, (Object)filteredNodes);
                    break block55;
                }
            }
            super.run(graph, context);
        }
    }
}

