/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.phases;

import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.SpectrePHTMitigations;
import org.graalvm.compiler.core.phases.BaseTier;
import org.graalvm.compiler.loop.phases.LoopPartialUnrollPhase;
import org.graalvm.compiler.loop.phases.LoopPredicationPhase;
import org.graalvm.compiler.loop.phases.LoopSafepointEliminationPhase;
import org.graalvm.compiler.loop.phases.SpeculativeGuardMovementPhase;
import org.graalvm.compiler.nodes.loop.DefaultLoopPolicies;
import org.graalvm.compiler.nodes.loop.LoopPolicies;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.common.CanonicalizerPhase;
import org.graalvm.compiler.phases.common.DeoptimizationGroupingPhase;
import org.graalvm.compiler.phases.common.FloatingReadPhase;
import org.graalvm.compiler.phases.common.FrameStateAssignmentPhase;
import org.graalvm.compiler.phases.common.GuardLoweringPhase;
import org.graalvm.compiler.phases.common.IncrementalCanonicalizerPhase;
import org.graalvm.compiler.phases.common.InsertGuardFencesPhase;
import org.graalvm.compiler.phases.common.IterativeConditionalEliminationPhase;
import org.graalvm.compiler.phases.common.LockEliminationPhase;
import org.graalvm.compiler.phases.common.LoopSafepointInsertionPhase;
import org.graalvm.compiler.phases.common.LoweringPhase;
import org.graalvm.compiler.phases.common.OptimizeDivPhase;
import org.graalvm.compiler.phases.common.ReassociationPhase;
import org.graalvm.compiler.phases.common.RemoveValueProxyPhase;
import org.graalvm.compiler.phases.common.VerifyHeapAtReturnPhase;
import org.graalvm.compiler.phases.common.WriteBarrierAdditionPhase;
import org.graalvm.compiler.phases.tiers.MidTierContext;

public class MidTier
extends BaseTier<MidTierContext> {
    public MidTier(OptionValues options) {
        CanonicalizerPhase canonicalizer = this.createCanonicalizerPhase(options);
        this.appendPhase(new LockEliminationPhase());
        if (GraalOptions.OptFloatingReads.getValue(options).booleanValue()) {
            this.appendPhase(new IncrementalCanonicalizerPhase<Object>(canonicalizer, new FloatingReadPhase()));
        }
        if (GraalOptions.ConditionalElimination.getValue(options).booleanValue()) {
            this.appendPhase(new IterativeConditionalEliminationPhase(canonicalizer, true));
        }
        if (GraalOptions.LoopPredication.getValue(options).booleanValue() && !GraalOptions.SpeculativeGuardMovement.getValue(options).booleanValue()) {
            this.appendPhase(new IncrementalCanonicalizerPhase<MidTierContext>(canonicalizer, new LoopPredicationPhase()));
        }
        this.appendPhase(new LoopSafepointEliminationPhase());
        if (GraalOptions.SpeculativeGuardMovement.getValue(options).booleanValue()) {
            this.appendPhase(new IncrementalCanonicalizerPhase<MidTierContext>(canonicalizer, new SpeculativeGuardMovementPhase()));
        }
        this.appendPhase(new GuardLoweringPhase());
        if (SpectrePHTMitigations.Options.SpectrePHTBarriers.getValue(options) == SpectrePHTMitigations.GuardTargets || SpectrePHTMitigations.Options.SpectrePHTBarriers.getValue(options) == SpectrePHTMitigations.NonDeoptGuardTargets) {
            this.appendPhase(new InsertGuardFencesPhase());
        }
        if (GraalOptions.VerifyHeapAtReturn.getValue(options).booleanValue()) {
            this.appendPhase(new VerifyHeapAtReturnPhase());
        }
        this.appendPhase(new IncrementalCanonicalizerPhase<Object>(canonicalizer, new RemoveValueProxyPhase()));
        this.appendPhase(new LoopSafepointInsertionPhase());
        this.appendPhase(new LoweringPhase(canonicalizer, LoweringTool.StandardLoweringStage.MID_TIER));
        this.appendPhase(new OptimizeDivPhase());
        this.appendPhase(new FrameStateAssignmentPhase());
        if (GraalOptions.PartialUnroll.getValue(options).booleanValue()) {
            LoopPolicies loopPolicies = this.createLoopPolicies(options);
            this.appendPhase(new LoopPartialUnrollPhase(loopPolicies, canonicalizer));
        }
        if (GraalOptions.ReassociateExpressions.getValue(options).booleanValue()) {
            this.appendPhase(new ReassociationPhase(canonicalizer));
        }
        if (GraalOptions.OptDeoptimizationGrouping.getValue(options).booleanValue()) {
            this.appendPhase(new DeoptimizationGroupingPhase());
        }
        this.appendPhase(canonicalizer);
        this.appendPhase(new WriteBarrierAdditionPhase());
    }

    @Override
    public LoopPolicies createLoopPolicies(OptionValues options) {
        return new DefaultLoopPolicies();
    }
}

