/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.target;

import java.util.ArrayList;
import jdk.vm.ci.code.CodeCacheProvider;
import jdk.vm.ci.code.CompilationRequest;
import jdk.vm.ci.code.CompiledCode;
import jdk.vm.ci.code.InstalledCode;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.code.ValueKindFactory;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.core.common.CompilationIdentifier;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.alloc.RegisterAllocationConfig;
import org.graalvm.compiler.core.common.spi.ForeignCallSignature;
import org.graalvm.compiler.core.common.spi.ForeignCallsProvider;
import org.graalvm.compiler.core.gen.LIRCompilerBackend;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.lir.asm.CompilationResultBuilderFactory;
import org.graalvm.compiler.lir.phases.LIRSuites;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.tiers.SuitesProvider;
import org.graalvm.compiler.phases.tiers.TargetProvider;
import org.graalvm.compiler.phases.util.Providers;

public abstract class Backend
implements TargetProvider,
ValueKindFactory<LIRKind> {
    private final Providers providers;
    private final ArrayList<CodeInstallationTaskFactory> codeInstallationTaskFactories;
    public static final ForeignCallSignature ARITHMETIC_FREM = new ForeignCallSignature("arithmeticFrem", Float.TYPE, Float.TYPE, Float.TYPE);
    public static final ForeignCallSignature ARITHMETIC_DREM = new ForeignCallSignature("arithmeticDrem", Double.TYPE, Double.TYPE, Double.TYPE);

    protected Backend(Providers providers) {
        this.providers = providers;
        this.codeInstallationTaskFactories = new ArrayList();
    }

    public synchronized void addCodeInstallationTask(CodeInstallationTaskFactory factory) {
        this.codeInstallationTaskFactories.add(factory);
    }

    public Providers getProviders() {
        return this.providers;
    }

    public CodeCacheProvider getCodeCache() {
        return this.providers.getCodeCache();
    }

    public MetaAccessProvider getMetaAccess() {
        return this.providers.getMetaAccess();
    }

    public ConstantReflectionProvider getConstantReflection() {
        return this.providers.getConstantReflection();
    }

    public ForeignCallsProvider getForeignCalls() {
        return this.providers.getForeignCalls();
    }

    public abstract SuitesProvider getSuites();

    @Override
    public TargetDescription getTarget() {
        return this.providers.getCodeCache().getTarget();
    }

    public LIRKind getValueKind(JavaKind javaKind) {
        return LIRKind.fromJavaKind(this.getTarget().arch, javaKind);
    }

    public abstract RegisterAllocationConfig newRegisterAllocationConfig(RegisterConfig var1, String[] var2);

    protected abstract CompiledCode createCompiledCode(ResolvedJavaMethod var1, CompilationRequest var2, CompilationResult var3, boolean var4, OptionValues var5);

    public InstalledCode createInstalledCode(DebugContext debug, ResolvedJavaMethod method, CompilationResult compilationResult, InstalledCode predefinedInstalledCode, boolean isDefault) {
        return this.createInstalledCode(debug, method, null, compilationResult, predefinedInstalledCode, isDefault, null);
    }

    public InstalledCode createInstalledCode(DebugContext debug, ResolvedJavaMethod method, CompilationRequest compilationRequest, CompilationResult compilationResult, InstalledCode predefinedInstalledCode, boolean isDefault) {
        return this.createInstalledCode(debug, method, compilationRequest, compilationResult, predefinedInstalledCode, isDefault, null);
    }

    /*
     * Exception decompiling
     */
    public InstalledCode createInstalledCode(DebugContext debug, ResolvedJavaMethod method, CompilationRequest compilationRequest, CompilationResult compilationResult, InstalledCode predefinedInstalledCode, boolean isDefault, Object[] context) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void failCodeInstallationTasks(CodeInstallationTask[] tasks, Throwable t) {
        for (CodeInstallationTask task : tasks) {
            task.installFailed(t);
        }
    }

    private static void preCodeInstallationTasks(CodeInstallationTask[] tasks, CompilationResult compilationResult) {
        for (CodeInstallationTask task : tasks) {
            task.preProcess(compilationResult);
        }
    }

    private static void postCodeInstallationTasks(CodeInstallationTask[] tasks, CompilationResult compilationResult, InstalledCode installedCode) {
        try {
            for (CodeInstallationTask task : tasks) {
                task.postProcess(compilationResult, installedCode);
            }
        }
        catch (Throwable t) {
            installedCode.invalidate();
            throw t;
        }
    }

    public InstalledCode addInstalledCode(DebugContext debug, ResolvedJavaMethod method, CompilationRequest compilationRequest, CompilationResult compilationResult) {
        return this.createInstalledCode(debug, method, compilationRequest, compilationResult, null, false);
    }

    public InstalledCode createDefaultInstalledCode(DebugContext debug, ResolvedJavaMethod method, CompilationResult compilationResult) {
        return this.createInstalledCode(debug, method, compilationResult, null, true);
    }

    public CompilationIdentifier getCompilationIdentifier(ResolvedJavaMethod resolvedJavaMethod) {
        return CompilationIdentifier.INVALID_COMPILATION_ID;
    }

    public void emitBackEnd(StructuredGraph graph, Object stub, ResolvedJavaMethod installedCodeOwner, CompilationResult compilationResult, CompilationResultBuilderFactory factory, RegisterConfig config, LIRSuites lirSuites) {
        LIRCompilerBackend.emitBackEnd(graph, stub, installedCodeOwner, this, compilationResult, factory, config, lirSuites);
    }

    public static abstract class CodeInstallationTaskFactory {
        public abstract CodeInstallationTask create();
    }

    public static abstract class CodeInstallationTask {
        public void preProcess(CompilationResult compilationResult) {
        }

        public void postProcess(CompilationResult compilationResult, InstalledCode installedCode) {
        }

        public void installFailed(Throwable cause) {
        }
    }
}

