/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.debug;

import java.io.IOException;
import org.graalvm.compiler.debug.DebugOptions;
import org.graalvm.compiler.debug.PathUtilities;
import org.graalvm.compiler.debug.TTY;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.serviceprovider.GraalServices;
import org.graalvm.compiler.serviceprovider.IsolateUtil;

public class DiagnosticsOutputDirectory {
    private static final String CLOSED = "\u0000";
    private final OptionValues options;
    private String path;

    public DiagnosticsOutputDirectory(OptionValues options) {
        this.options = options;
    }

    public String getPath() {
        return this.getPath(true);
    }

    private synchronized String getPath(boolean createIfNull) {
        if (this.path == null && createIfNull) {
            this.path = this.createPath();
            String dir = PathUtilities.getAbsolutePath(this.path);
            if (!PathUtilities.exists(dir)) {
                try {
                    PathUtilities.createDirectories(dir);
                }
                catch (IOException e) {
                    TTY.println("Warning: could not create Graal diagnostic directory " + dir + ": " + e);
                    return null;
                }
            }
        }
        if (CLOSED.equals(this.path)) {
            TTY.println("Warning: Graal diagnostic directory already closed");
            return null;
        }
        return this.path;
    }

    protected String createPath() {
        String baseDir;
        try {
            baseDir = DebugOptions.getDumpDirectory(this.options);
        }
        catch (IOException e) {
            baseDir = ".";
        }
        return PathUtilities.getPath(baseDir, "graal_diagnostics_" + GraalServices.getExecutionID() + '@' + IsolateUtil.getIsolateID());
    }

    public void close() {
        this.archiveAndDelete();
    }

    private synchronized void archiveAndDelete() {
        String outDir = this.getPath(false);
        if (outDir != null) {
            this.path = CLOSED;
            try {
                String zip = outDir + ".zip";
                PathUtilities.archiveAndDelete(outDir, zip);
            }
            catch (IOException e) {
                TTY.println(e.getMessage());
                TTY.println("Cause: " + e.getCause());
            }
        }
    }
}

