/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.graph;

import java.util.Objects;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.graph.NodeSourcePosition;

public class InlineCacheGuardPosition
extends NodeSourcePosition {
    private final ResolvedJavaType dispatchedType;
    private final ResolvedJavaMethod concreteMethod;
    private final int hashCode;

    public InlineCacheGuardPosition(NodeSourcePosition callStack, ResolvedJavaType dispatchedType, ResolvedJavaMethod targetMethod) {
        super(callStack.getCaller(), callStack.getMethod(), callStack.getBCI());
        this.concreteMethod = targetMethod;
        this.dispatchedType = dispatchedType;
        this.hashCode = super.hashCode() + 7 * (dispatchedType == null ? 0 : dispatchedType.hashCode()) + 31 * targetMethod.hashCode();
    }

    public ResolvedJavaType getDispatchedType() {
        return this.dispatchedType;
    }

    public ResolvedJavaMethod getTargetMethod() {
        return this.concreteMethod;
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && this.getClass() == obj.getClass()) {
            InlineCacheGuardPosition that = (InlineCacheGuardPosition)obj;
            if (this.hashCode != that.hashCode) {
                return false;
            }
            if (this.getBCI() == that.getBCI() && Objects.equals(this.getMethod(), that.getMethod()) && Objects.equals(this.getCaller(), that.getCaller()) && Objects.equals(this.concreteMethod, that.concreteMethod) && Objects.equals(this.dispatchedType, that.dispatchedType)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public String toString() {
        return "dispatchedType=" + (this.dispatchedType == null ? "null" : this.dispatchedType.getName()) + " target_method=" + this.concreteMethod.getName() + " target_method_class=" + this.concreteMethod.getDeclaringClass().getName() + " position=" + super.toString();
    }
}

