/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.graph;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;
import java.util.stream.Stream;
import org.graalvm.compiler.core.common.PermanentBailoutException;
import org.graalvm.compiler.graph.Edges;
import org.graalvm.compiler.graph.Graph;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeInterface;
import org.graalvm.compiler.graph.iterators.NodeIterable;

public abstract class NodeList<T extends Node>
extends AbstractList<T>
implements NodeIterable<T>,
RandomAccess {
    private static final int MAX_ENTRIES = 65536;
    protected static final Node[] EMPTY_NODE_ARRAY = new Node[0];
    protected final Node self;
    protected Node[] nodes;
    private int size;
    protected final int initialSize;

    protected NodeList(Node self) {
        this.self = self;
        this.nodes = EMPTY_NODE_ARRAY;
        this.initialSize = 0;
    }

    protected NodeList(Node self, int initialSize) {
        this.self = self;
        NodeList.checkMaxSize(initialSize);
        this.size = initialSize;
        this.initialSize = initialSize;
        this.nodes = initialSize == 0 ? EMPTY_NODE_ARRAY : new Node[initialSize];
    }

    protected NodeList(Node self, T[] elements) {
        this.self = self;
        if (elements == null || elements.length == 0) {
            this.size = 0;
            this.nodes = EMPTY_NODE_ARRAY;
            this.initialSize = 0;
        } else {
            NodeList.checkMaxSize(elements.length);
            this.initialSize = this.size = elements.length;
            this.nodes = new Node[elements.length];
            for (int i = 0; i < elements.length; ++i) {
                this.nodes[i] = elements[i];
                assert (this.nodes[i] == null || !this.nodes[i].isDeleted()) : "Initializing nodelist with deleted element : " + this.nodes[i];
            }
        }
    }

    protected NodeList(Node self, List<? extends T> elements) {
        this.self = self;
        if (elements == null || elements.isEmpty()) {
            this.size = 0;
            this.nodes = EMPTY_NODE_ARRAY;
            this.initialSize = 0;
        } else {
            int newSize = elements.size();
            NodeList.checkMaxSize(newSize);
            this.size = newSize;
            this.initialSize = newSize;
            this.nodes = new Node[elements.size()];
            for (int i = 0; i < elements.size(); ++i) {
                this.nodes[i] = (Node)elements.get(i);
                assert (this.nodes[i] == null || !this.nodes[i].isDeleted());
            }
        }
    }

    private static void checkMaxSize(int value) {
        if (value > 65536) {
            throw new PermanentBailoutException("Number of elements in a node list too high: %d", value);
        }
    }

    protected NodeList(Node self, Collection<? extends NodeInterface> elements) {
        this.self = self;
        if (elements == null || elements.isEmpty()) {
            this.size = 0;
            this.nodes = EMPTY_NODE_ARRAY;
            this.initialSize = 0;
        } else {
            int newSize = elements.size();
            NodeList.checkMaxSize(newSize);
            this.size = newSize;
            this.initialSize = newSize;
            this.nodes = new Node[elements.size()];
            int i = 0;
            for (NodeInterface nodeInterface : elements) {
                this.nodes[i] = nodeInterface.asNode();
                assert (this.nodes[i] == null || !this.nodes[i].isDeleted());
                ++i;
            }
        }
    }

    public void trim() {
        int newSize = 0;
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[newSize] = this.nodes[i];
            ++newSize;
        }
        this.size = newSize;
    }

    protected abstract void update(T var1, T var2);

    public abstract Edges.Type getEdgesType();

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean isNotEmpty() {
        return this.size > 0;
    }

    @Override
    public int count() {
        return this.size;
    }

    protected final void incModCount() {
        ++this.modCount;
    }

    @Override
    public boolean add(Node node) {
        assert (node == null || !node.isDeleted()) : node;
        NodeList.checkMaxSize(this.size + 1);
        this.self.incModCount();
        this.incModCount();
        int length = this.nodes.length;
        if (length == 0) {
            this.nodes = new Node[2];
        } else if (this.size == length) {
            Node[] newNodes = new Node[this.nodes.length * 2 + 1];
            System.arraycopy(this.nodes, 0, newNodes, 0, length);
            this.nodes = newNodes;
        }
        this.nodes[this.size++] = node;
        this.update(null, node);
        return true;
    }

    @Override
    public T get(int index) {
        assert (this.assertInRange(index));
        return (T)this.nodes[index];
    }

    private boolean assertInRange(int index) {
        assert (index >= 0 && index < this.size()) : index + " < " + this.size();
        return true;
    }

    public T last() {
        return (T)this.get(this.size() - 1);
    }

    @Override
    public T set(int index, Node node) {
        this.incModCount();
        Node oldValue = this.nodes[index];
        assert (this.assertInRange(index));
        this.update(this.nodes[index], node);
        this.nodes[index] = node;
        return (T)oldValue;
    }

    public void initialize(int index, Node node) {
        this.incModCount();
        assert (index < this.size());
        this.nodes[index] = node;
    }

    void copy(NodeList<? extends Node> other) {
        Node[] newNodes;
        this.self.incModCount();
        this.incModCount();
        if (other.size == 0) {
            newNodes = EMPTY_NODE_ARRAY;
        } else {
            newNodes = new Node[other.size];
            System.arraycopy(other.nodes, 0, newNodes, 0, newNodes.length);
        }
        this.nodes = newNodes;
        this.size = other.size;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof List) {
            List otherList = (List)other;
            if (this.size != otherList.size()) {
                return false;
            }
            for (int i = 0; i < this.size; ++i) {
                if (this.nodes[i] == otherList.get(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public Stream<T> stream() {
        return super.stream();
    }

    @Override
    public void clear() {
        this.self.incModCount();
        this.incModCount();
        for (int i = 0; i < this.size; ++i) {
            this.update(this.nodes[i], null);
        }
        this.clearWithoutUpdate();
    }

    void clearWithoutUpdate() {
        this.nodes = EMPTY_NODE_ARRAY;
        this.size = 0;
    }

    void minimizeSize() {
        this.nodes = Graph.trimArrayToNewSize(this.nodes, this.size, EMPTY_NODE_ARRAY);
    }

    @Override
    public boolean remove(Object node) {
        int i;
        this.self.incModCount();
        this.incModCount();
        for (i = 0; i < this.size && this.nodes[i] != node; ++i) {
        }
        if (i < this.size) {
            Node oldValue = this.nodes[i];
            ++i;
            while (i < this.size) {
                this.nodes[i - 1] = this.nodes[i];
                ++i;
            }
            this.nodes[--this.size] = null;
            this.update(oldValue, null);
            return true;
        }
        return false;
    }

    @Override
    public T remove(int index) {
        this.self.incModCount();
        Node oldValue = this.nodes[index];
        this.incModCount();
        for (int i = index + 1; i < this.size; ++i) {
            this.nodes[i - 1] = this.nodes[i];
        }
        this.nodes[--this.size] = null;
        this.update(oldValue, null);
        return (T)oldValue;
    }

    boolean replaceFirst(Node node, Node other) {
        for (int i = 0; i < this.size; ++i) {
            if (this.nodes[i] != node) continue;
            this.nodes[i] = other;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<T> iterator() {
        return new NodeListIterator(this, 0);
    }

    @Override
    public boolean contains(T other) {
        for (int i = 0; i < this.size; ++i) {
            if (this.nodes[i] != other) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<T> snapshot() {
        return Arrays.asList(Arrays.copyOf(this.nodes, this.size));
    }

    @Override
    public void snapshotTo(Collection<? super T> to) {
        for (int i = 0; i < this.size; ++i) {
            to.add(this.get(i));
        }
    }

    public void setAll(NodeList<T> values) {
        int i;
        this.self.incModCount();
        this.incModCount();
        for (i = 0; i < this.size(); ++i) {
            this.update(this.nodes[i], null);
        }
        this.nodes = Arrays.copyOf(values.nodes, values.size());
        this.size = values.size();
        for (i = 0; i < this.size(); ++i) {
            this.update(null, this.nodes[i]);
        }
    }

    @Override
    public <A> A[] toArray(A[] a) {
        if (a.length >= this.size) {
            System.arraycopy(this.nodes, 0, a, 0, this.size);
            return a;
        }
        return Arrays.copyOf(this.nodes, this.size, a.getClass());
    }

    @Override
    public Object[] toArray() {
        return Arrays.copyOf(this.nodes, this.size);
    }

    protected void replace(T node, T other) {
        this.incModCount();
        for (int i = 0; i < this.size(); ++i) {
            if (this.nodes[i] != node) continue;
            this.nodes[i] = other;
            this.update(node, other);
        }
    }

    @Override
    public int indexOf(Object node) {
        for (int i = 0; i < this.size; ++i) {
            if (this.nodes[i] != node) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) != -1;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        for (Node e : c) {
            this.add(e);
        }
        return true;
    }

    public boolean addAll(T[] c) {
        for (T e : c) {
            this.add((Node)e);
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (int i = 0; i < this.size; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(this.nodes[i]);
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public T first() {
        if (this.size() > 0) {
            return (T)this.get(0);
        }
        return null;
    }

    public SubList<T> subList(int startIndex) {
        assert (this.assertInRange(startIndex));
        return new SubList(this, startIndex);
    }

    private static final class NodeListIterator<R extends Node>
    implements Iterator<R> {
        private final NodeList<R> list;
        private final int expectedModCount;
        private int index;

        private NodeListIterator(NodeList<R> list, int startIndex) {
            this.list = list;
            this.expectedModCount = ((NodeList)list).modCount;
            this.index = startIndex;
        }

        @Override
        public boolean hasNext() {
            assert (this.expectedModCount == ((NodeList)this.list).modCount);
            return this.index < ((NodeList)this.list).size;
        }

        @Override
        public R next() {
            assert (this.expectedModCount == ((NodeList)this.list).modCount);
            return (R)this.list.nodes[this.index++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static final class SubList<R extends Node>
    extends AbstractList<R>
    implements NodeIterable<R>,
    RandomAccess {
        private final NodeList<R> list;
        private final int offset;

        private SubList(NodeList<R> list, int offset) {
            this.list = list;
            this.offset = offset;
        }

        @Override
        public R get(int index) {
            assert (index >= 0) : index;
            return (R)this.list.get(this.offset + index);
        }

        @Override
        public int size() {
            return this.list.size() - this.offset;
        }

        public SubList<R> subList(int startIndex) {
            assert (startIndex >= 0 && startIndex < this.size()) : startIndex;
            return new SubList<R>(this.list, startIndex + this.offset);
        }

        @Override
        public Iterator<R> iterator() {
            return new NodeListIterator(this.list, this.offset);
        }

        @Override
        public Stream<R> stream() {
            return super.stream();
        }
    }
}

